/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.time;

import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;

public class Date
extends DateTimeBase {
    public Date(int n, int n2, int n3, int n4, int n5, int n6) throws DateTimeException {
        super(n, n2, n3, 0, 0, 0.0, n4, n5, n6);
    }

    public Date(DateTimeBase dateTimeBase) throws DateTimeException {
        super(dateTimeBase.year, dateTimeBase.month, dateTimeBase.day, 0, 0, 0.0, dateTimeBase.tzSign, dateTimeBase.tzHour, dateTimeBase.tzMinute);
    }

    public Date(long l) {
        this.setSecondsFromEpoch((double)l / 1000.0, Integer.MAX_VALUE);
    }

    public DateTimeBase parse(String string) throws DateTimeException {
        return Date.parseDate(string);
    }

    public DateTimeBase adjustToTimezone(int n, boolean bl) {
        DateTimeBase dateTimeBase = super.adjustToTimezone(n, bl);
        Date.normalize(dateTimeBase);
        return dateTimeBase;
    }

    public static void normalize(DateTimeBase dateTimeBase) {
        dateTimeBase.hour = 0;
        dateTimeBase.minute = 0;
        dateTimeBase.second = 0.0;
    }

    public static Date parseDate(String string) throws DateTimeException {
        int n;
        int[] nArray = new int[3];
        int n2 = string.length();
        if (n2 == 0) {
            throw new DateTimeException("date syntax", string);
        }
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(n3) == '-') {
            bl = true;
            ++n3;
        }
        if ((n = string.indexOf(45, n3)) < n3 + 4) {
            throw new DateTimeException("invalid syntax", string);
        }
        int n4 = Date.parseInt(string, n3, n);
        if (n4 < 10000 && n - n3 > 4) {
            throw new DateTimeException("invalid year: leading zeroes", string);
        }
        if (bl) {
            n4 = -n4;
        }
        if ((n3 = n + 1) + 2 >= n2 || string.charAt(n3 + 2) != '-') {
            throw new DateTimeException("invalid syntax", string);
        }
        int n5 = Date.parseInt(string, n3, n3 + 2);
        n = Date.parseTimeZone(string, n3 += 3, nArray);
        if (n != n3 + 2) {
            throw new DateTimeException("invalid syntax", string);
        }
        int n6 = Date.parseInt(string, n3, n);
        Date date = new Date(n4, n5, n6, nArray[0], nArray[1], nArray[2]);
        return date;
    }

    public DateTimeBase copy() {
        try {
            return new Date(this.year, this.month, this.day, this.tzSign, this.tzHour, this.tzMinute);
        }
        catch (DateTimeException dateTimeException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.year < 0) {
            stringBuffer.append('-');
            Date.appendPadded(-this.year, 4, stringBuffer);
        } else {
            Date.appendPadded(this.year, 4, stringBuffer);
        }
        stringBuffer.append('-');
        Date.appendPadded(this.month, 2, stringBuffer);
        stringBuffer.append('-');
        Date.appendPadded(this.day, 2, stringBuffer);
        Date.appendTimeZone(this.tzSign, this.tzHour, this.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }
}

