/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.time;

import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;

public class GDay
extends DateTimeBase {
    public GDay(int n, int n2, int n3, int n4) throws DateTimeException {
        super(1970, 1, n, 0, 0, 0.0, n2, n3, n4);
    }

    public GDay(DateTimeBase dateTimeBase) throws DateTimeException {
        this(dateTimeBase.day, dateTimeBase.tzSign, dateTimeBase.tzHour, dateTimeBase.tzMinute);
    }

    public DateTimeBase parse(String string) throws DateTimeException {
        return GDay.parseGDay(string);
    }

    public static GDay parseGDay(String string) throws DateTimeException {
        GDay gDay;
        int[] nArray = new int[3];
        if (!string.startsWith("---")) {
            throw new DateTimeException("invalid gDay syntax", string);
        }
        int n = 3;
        int n2 = GDay.parseTimeZone(string, n, nArray);
        if (n2 != n + 2) {
            throw new DateTimeException("invalid gDay syntax", string);
        }
        int n3 = GDay.parseInt(string, n, n2);
        try {
            gDay = new GDay(n3, nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DateTimeException("invalid gDay value", string);
        }
        return gDay;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("---");
        GDay.appendPadded(this.day, 2, stringBuffer);
        GDay.appendTimeZone(this.tzSign, this.tzHour, this.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }
}

