/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.time;

import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.util.basic.Comparison;

public class Time
extends DateTimeBase {
    private static final int DAY = 86400;

    public Time(int n, int n2, double d, int n3, int n4, int n5) throws DateTimeException {
        super(1972, 12, 31, n, n2, d, n3, n4, n5);
    }

    public Time(DateTimeBase dateTimeBase) throws DateTimeException {
        this(dateTimeBase.hour, dateTimeBase.minute, dateTimeBase.second, dateTimeBase.tzSign, dateTimeBase.tzHour, dateTimeBase.tzMinute);
    }

    public Time(long l, int n) {
        super(l % 86400000L, n);
    }

    public DateTimeBase parse(String string) throws DateTimeException {
        return Time.parseTime(string);
    }

    public static Time parseTime(String string) throws DateTimeException {
        int[] nArray = new int[3];
        int n = 0;
        int n2 = string.length();
        if (n + 2 >= n2 || string.charAt(n + 2) != ':') {
            throw new DateTimeException("invalid time syntax", string);
        }
        int n3 = Time.parseInt(string, n, n + 2);
        if ((n += 3) + 2 >= n2 || string.charAt(n + 2) != ':') {
            throw new DateTimeException("invalid time syntax", string);
        }
        int n4 = Time.parseInt(string, n, n + 2);
        int n5 = Time.parseTimeZone(string, n += 3, nArray);
        if (n5 < n + 2) {
            throw new DateTimeException("invalid time syntax", string);
        }
        double d = Time.parseDouble(string, n, n5);
        Time time = new Time(n3, n4, d, nArray[0], nArray[1], nArray[2]);
        return time;
    }

    public int compareTo(DateTimeBase dateTimeBase) {
        double d = this.getSecondsFromEpoch();
        double d2 = dateTimeBase.getSecondsFromEpoch();
        if (d < 0.0) {
            d += 86400.0;
        } else if (d > 86400.0) {
            d -= 86400.0;
        }
        if (d2 < 0.0) {
            d2 += 86400.0;
        } else if (d2 > 86400.0) {
            d2 -= 86400.0;
        }
        return Comparison.of(d, d2);
    }

    public DateTimeBase copy() {
        try {
            return new Time(this.hour, this.minute, this.second, this.tzSign, this.tzHour, this.tzMinute);
        }
        catch (DateTimeException dateTimeException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Time.appendPadded(this.hour, 2, stringBuffer);
        stringBuffer.append(':');
        Time.appendPadded(this.minute, 2, stringBuffer);
        stringBuffer.append(':');
        Time.appendPadded(this.second, 2, stringBuffer);
        Time.appendTimeZone(this.tzSign, this.tzHour, this.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }

    public DateTimeBase adjustToTimezone(int n, boolean bl) {
        DateTimeBase dateTimeBase = super.adjustToTimezone(n, bl);
        Time.normalize(dateTimeBase);
        return dateTimeBase;
    }

    public static void normalize(DateTimeBase dateTimeBase) {
        dateTimeBase.year = 1972;
        dateTimeBase.month = (byte)12;
        dateTimeBase.day = (byte)31;
    }
}

