/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.queries.FullText;
import com.qizx.queries.iterators.AllIterator;
import com.qizx.queries.iterators.ContainerIterator;
import com.qizx.queries.iterators.CountIterator;
import com.qizx.queries.iterators.MildNotIterator;
import com.qizx.queries.iterators.OrIterator;
import com.qizx.queries.iterators.PostingIterator;
import com.qizx.util.basic.Check;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xdm.IQName;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public abstract class Query {
    private PostingIterator.Filter[] filters;
    protected int depthTest = -1;

    public int getDepthTest() {
        return this.depthTest;
    }

    public void setDepthTest(int n) {
        this.depthTest = n;
    }

    public static PostingIterator realize(Query query, Instantiator instantiator) {
        return query.realize(instantiator);
    }

    protected abstract PostingIterator realize(Instantiator var1);

    protected PostingIterator filtered(PostingIterator postingIterator) {
        if (this.getFilters() != null) {
            postingIterator.setFilters(this.getFilters());
        }
        if (this.depthTest != -1) {
            postingIterator.setDepthTest(this.depthTest);
        }
        return postingIterator;
    }

    protected String header() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(36) + 1);
        return this.depthTest != -1 ? string2 + " d=" + this.depthTest : string2;
    }

    public abstract void display(Displayer var1);

    public void display() {
        new Displayer().display(this);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        new Displayer(new PrintWriter((Writer)stringWriter, true)).display(this);
        return stringWriter.toString();
    }

    public PostingIterator.Filter[] getFilters() {
        return this.filters;
    }

    public void addFilter(PostingIterator.Filter filter) {
        if (this.filters == null) {
            this.filters = new PostingIterator.Filter[]{filter};
        } else {
            PostingIterator.Filter[] filterArray = this.filters;
            this.filters = new PostingIterator.Filter[filterArray.length + 1];
            System.arraycopy(filterArray, 0, this.getFilters(), 0, filterArray.length);
            this.filters[filterArray.length] = filter;
        }
    }

    public void setFilters(PostingIterator.Filter[] filterArray) {
        this.filters = filterArray;
    }

    public static Query and(Query query, Query query2) {
        if (query == null) {
            return query2;
        }
        if (query instanceof And) {
            ((And)query).add(query2);
            return query;
        }
        if (query2 instanceof And) {
            ((And)query2).add(query);
            return query2;
        }
        if (query2 == null) {
            return query;
        }
        return new And(query, query2);
    }

    public static Query union(Query query, Query query2) {
        if (query == null) {
            return query2;
        }
        if (query2 == null) {
            return query;
        }
        Or or = new Or();
        or.add(query);
        or.add(query2);
        return or;
    }

    public static class Displayer {
        private PrintWriter out;
        int depth = -1;
        boolean bol = true;

        public Displayer() {
            this.out = new PrintWriter(System.err, true);
        }

        public Displayer(PrintWriter printWriter) {
            this.out = printWriter;
        }

        public void display(Query query) {
            ++this.depth;
            if (query == null) {
                this.indent();
                this.println("null?");
                --this.depth;
                return;
            }
            query.display(this);
            PostingIterator.Filter[] filterArray = query.getFilters();
            if (filterArray != null) {
                for (int i = 0; i < filterArray.length; ++i) {
                    this.println(" +Filter " + filterArray[i]);
                }
            }
            --this.depth;
        }

        public void display(FullText.Selection selection) {
            ++this.depth;
            if (selection == null) {
                this.indent();
                this.println("!null?");
                return;
            }
            selection.display(this);
            this.println("");
            --this.depth;
        }

        void print(String string) {
            this.indent();
            this.out.print(string);
        }

        void println(String string) {
            this.indent();
            this.out.println(string);
            this.bol = true;
        }

        void indent() {
            if (this.bol) {
                for (int i = 0; i < this.depth; ++i) {
                    this.out.print("   ");
                }
            }
            this.bol = false;
        }
    }

    public static interface Instantiator {
        public PostingIterator singleNodeIterator(FONIDataModel.FONINode var1);

        public PostingIterator enumDocNodes();

        public PostingIterator enumDocElements();

        public PostingIterator enumWord(char[] var1, FullText.MatchOptions var2);

        public PostingIterator enumWildcard(char[] var1, FullText.MatchOptions var2);

        public FullTextFactory getScoringFactory();
    }

    public static class SingleNode
    extends Query {
        protected FONIDataModel.FONINode node;

        public SingleNode(FONIDataModel.FONINode fONINode) {
            Check.nonNull(fONINode, "node");
            this.node = fONINode;
        }

        protected PostingIterator realize(Instantiator instantiator) {
            return this.filtered(instantiator.singleNodeIterator(this.node));
        }

        public void display(Displayer displayer) {
            displayer.print(this.header());
            try {
                displayer.println(" " + this.node.getNodeKind() + " " + this.node.getNodeName());
            }
            catch (DataModelException dataModelException) {
                displayer.println("DataModelException: " + dataModelException.getMessage());
            }
        }
    }

    public static class DocumentElements
    extends Documents {
        protected PostingIterator realize(Instantiator instantiator) {
            return this.filtered(instantiator.enumDocElements());
        }
    }

    public static class Documents
    extends Query {
        protected PostingIterator realize(Instantiator instantiator) {
            return this.filtered(instantiator.enumDocNodes());
        }

        public void display(Displayer displayer) {
            displayer.println(this.header());
        }
    }

    public static class Count
    extends Query {
        Query counted;
        int minCount;
        int maxCount;

        public Count(Query query, int n, int n2) {
            this.counted = query;
            this.minCount = n;
            this.maxCount = n2;
        }

        protected PostingIterator realize(Instantiator instantiator) {
            return this.filtered(new CountIterator(this.minCount, this.maxCount, this.counted.realize(instantiator)));
        }

        public void display(Displayer displayer) {
            displayer.println(this.header() + " " + this.minCount + " " + this.maxCount);
            displayer.display(this.counted);
        }
    }

    public static class Fulltext
    extends Query {
        protected Query container;
        protected FullText.Selection ftSelection;
        protected Query ignored;

        public Fulltext(Query query, FullText.Selection selection) {
            Check.nonNull(selection, "selection");
            this.container = query;
            this.ftSelection = selection;
        }

        public Query getIgnored() {
            return this.ignored;
        }

        public void setIgnored(Query query) {
            this.ignored = query;
        }

        public void display(Displayer displayer) {
            displayer.println("FTContains");
            displayer.display(this.container);
            displayer.display(this.ftSelection);
            if (this.ignored != null) {
                displayer.display(this.ignored);
            }
        }

        protected PostingIterator realize(Instantiator instantiator) {
            PostingIterator postingIterator = this.ftSelection.realize(instantiator);
            if (this.container == null) {
                if (this.ignored == null) {
                    return this.filtered(postingIterator);
                }
                return this.filtered(new MildNotIterator(postingIterator, this.ignored.realize(instantiator)));
            }
            ContainerIterator containerIterator = new ContainerIterator(this.container.realize(instantiator), postingIterator);
            if (this.ignored != null) {
                containerIterator.setIgnored(this.ignored.realize(instantiator));
            }
            return this.filtered(containerIterator);
        }

        protected PostingIterator filtered(PostingIterator postingIterator) {
            PostingIterator postingIterator2 = super.filtered(postingIterator);
            postingIterator2.setFulltextSelection(this.ftSelection);
            return postingIterator2;
        }
    }

    public static class Containment
    extends Binary {
        public Containment(Query query, Query query2) {
            super(query, query2);
        }

        protected PostingIterator realize(Instantiator instantiator) {
            PostingIterator postingIterator = this.q2.realize(instantiator);
            return this.filtered(new ContainerIterator(this.q1.realize(instantiator), postingIterator));
        }

        public int getDepthTest() {
            return this.q1.getDepthTest();
        }

        public void setDepthTest(int n) {
            this.q1.setDepthTest(n);
        }

        public void display(Displayer displayer) {
            displayer.println(this.header());
            displayer.display(this.q1);
            displayer.display(this.q2);
        }
    }

    public static class Or
    extends NAry {
        public Or() {
        }

        public Or(Query query, Query query2) {
            this.queries = new Query[]{query, query2};
        }

        protected PostingIterator realize(Instantiator instantiator) {
            PostingIterator[] postingIteratorArray = this.realizeSubQueries(instantiator);
            if (postingIteratorArray.length == 1 && this.getFilters() == null && this.depthTest == -1) {
                return postingIteratorArray[0];
            }
            return this.filtered(new OrIterator(postingIteratorArray));
        }
    }

    public static class And
    extends NAry {
        public And() {
        }

        public And(Query query, Query query2) {
            this.queries = new Query[]{query, query2};
        }

        protected PostingIterator realize(Instantiator instantiator) {
            return this.filtered(new AllIterator(this.realizeSubQueries(instantiator)));
        }
    }

    static abstract class WithName
    extends Query {
        public IQName name;

        WithName(QName qName) {
            this.name = qName == null ? null : IQName.get(qName);
        }
    }

    static abstract class NAry
    extends Query {
        protected Query[] queries;

        public Query getQuery(int n) {
            return this.queries[n];
        }

        public void add(Query query) {
            if (query == null) {
                return;
            }
            if (query.getClass() == this.getClass()) {
                this.queries = NAry.concatenate(this.queries, ((NAry)query).queries);
            } else {
                Query[] queryArray = this.queries;
                int n = queryArray == null ? 0 : queryArray.length;
                this.queries = new Query[n + 1];
                if (queryArray != null) {
                    System.arraycopy(queryArray, 0, this.queries, 0, n);
                }
                this.queries[n] = query;
            }
        }

        public static Query[] concatenate(Query[] queryArray, Query[] queryArray2) {
            if (queryArray == null) {
                return queryArray2;
            }
            if (queryArray2 == null) {
                return queryArray;
            }
            Query[] queryArray3 = new Query[queryArray.length + queryArray2.length];
            System.arraycopy(queryArray, 0, queryArray3, 0, queryArray.length);
            System.arraycopy(queryArray2, 0, queryArray3, queryArray.length, queryArray2.length);
            return queryArray3;
        }

        public void display(Displayer displayer) {
            displayer.println(this.header());
            for (int i = 0; i < this.queries.length; ++i) {
                displayer.display(this.queries[i]);
            }
        }

        protected PostingIterator[] realizeSubQueries(Instantiator instantiator) {
            int n = this.queries.length;
            PostingIterator[] postingIteratorArray = new PostingIterator[n];
            for (int i = 0; i < n; ++i) {
                postingIteratorArray[i] = this.queries[i].realize(instantiator);
            }
            return postingIteratorArray;
        }

        public void setDepthTest(int n) {
            for (int i = 0; i < this.queries.length; ++i) {
                this.queries[i].setDepthTest(n);
            }
        }
    }

    static abstract class Binary
    extends Query {
        protected Query q1;
        protected Query q2;

        public Binary(Query query, Query query2) {
            this.q1 = query;
            this.q2 = query2;
        }

        public void display(Displayer displayer) {
            displayer.println(this.header());
            displayer.display(this.q1);
            displayer.display(this.q2);
        }

        public Query getQuery1() {
            return this.q1;
        }

        public void setQuery1(Query query) {
            Check.nonNull(query, "query1");
            this.q1 = query;
        }

        public Query getQuery2() {
            return this.q2;
        }

        public void setQuery2(Query query) {
            Check.nonNull(query, "query2");
            this.q2 = query;
        }
    }
}

