/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries.iterators;

import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.fulltext.Scorer;
import com.qizx.queries.iterators.PolyIterator;
import com.qizx.queries.iterators.PostingIterator;

public class AllIterator
extends PolyIterator {
    protected PostingIterator fastest;
    protected boolean fastPhrase;
    protected boolean fastInit;

    public AllIterator(PostingIterator[] postingIteratorArray) {
        super(postingIteratorArray);
    }

    public PostingIterator bornAgain() {
        return this.copyConstraints(new AllIterator(this.copy(this.iterators)));
    }

    private void init() {
        if (!this.fastInit) {
            this.fastInit = true;
            boolean bl = this.fastPhrase = this.ordered && this.constraints != null && (this.constraints.window > 0 || this.constraints.maxDistance == 0);
            if (this.iterators.length > 0) {
                this.fastest = this.fastPhrase ? this.iterators[0] : this.iterators[this.iterators.length - 1];
            }
        }
    }

    protected boolean basicSkipToNode(int n, int n2) throws EvaluationException {
        return this.inRange(n, n2);
    }

    public void resetToNode(int n) {
        this.init();
        super.resetToNode(n);
        this.currentResetPos = n;
    }

    public boolean inRange(int n, int n2) throws EvaluationException {
        this.init();
        this.currentResetPos = n;
        if (this.iterators.length == 0) {
            return false;
        }
        if (this.fastPhrase) {
            return this.phraseInRange(n, n2);
        }
        int n3 = n;
        int n4 = this.iterators.length;
        for (int i = 0; i < n4; ++i) {
            if (!this.iterators[i].inRange(n3, n2)) {
                return false;
            }
            if (!this.ordered) continue;
            n3 = this.iterators[i].getNodeId();
        }
        this.computeBounds();
        if ((this.constraints == null || this.checkFTConstraints(n, n2)) && this.checkFilters()) {
            return true;
        }
        return this.nextBefore(n2);
    }

    private boolean phraseInRange(int n, int n2) throws EvaluationException {
        int n3 = n;
        while (true) {
            int n4 = this.iterators.length;
            for (int i = 0; i < n4; ++i) {
                if (!this.iterators[i].skipToNode(n3, n2)) {
                    return false;
                }
                n3 = this.iterators[i].getNodeId() + 1;
                if (n3 <= n2) continue;
                return false;
            }
            this.computeBounds();
            if ((this.constraints == null || this.checkFTConstraints(n, n2)) && this.checkFilters()) {
                return true;
            }
            n3 = this.iterators[0].getNodeId() + 1;
        }
    }

    public boolean nextBefore(int n) throws EvaluationException {
        this.init();
        if (this.fastPhrase) {
            return this.phraseNextBefore(n);
        }
        do {
            if (!this.fastest.nextBefore(n)) {
                if (!this.moveOtherIters(this.iterators.length - 2, n)) {
                    return false;
                }
                if (!this.fastest.nextBefore(n)) {
                    return false;
                }
            }
            this.computeBounds();
        } while (this.constraints != null && !this.checkFTConstraints(this.currentResetPos, n) || !this.checkFilters());
        return true;
    }

    private boolean moveOtherIters(int n, int n2) throws EvaluationException {
        if (n < 0) {
            return false;
        }
        if (!this.iterators[n].nextBefore(n2)) {
            if (!this.moveOtherIters(n - 1, n2)) {
                return false;
            }
            if (!this.iterators[n].goNextNode(n2)) {
                return false;
            }
        }
        if (this.ordered) {
            this.iterators[n + 1].resetToNode(this.iterators[n].getNodeId());
        } else {
            this.iterators[n + 1].resetToNode(this.currentResetPos);
        }
        return true;
    }

    private boolean phraseNextBefore(int n) throws EvaluationException {
        do {
            if (this.fastest.getNodeId() >= n || !this.fastest.nextBefore(n)) {
                return false;
            }
            int n2 = this.iterators[0].getNodeId();
            int n3 = this.iterators.length;
            for (int i = 1; i < n3; ++i) {
                if (!this.iterators[i].skipToNode(n2, n)) {
                    return false;
                }
                n2 = this.iterators[i].getNodeId();
                if (n2 < n) continue;
                return false;
            }
            this.computeBounds();
        } while (this.constraints != null && !this.checkFTConstraints(this.currentResetPos, n) || !this.checkFilters());
        return true;
    }

    protected void computeBounds() throws EvaluationException {
        if (this.ordered) {
            this.curNodeId = this.iterators[0].getNodeId();
            this.matchEnd = this.iterators[this.iterators.length - 1].getNodeEnd();
        } else {
            this.curNodeId = 0x7FFFFFFE;
            this.matchEnd = -1;
            int n = this.iterators.length;
            for (int i = 0; i < n; ++i) {
                int n2 = this.iterators[i].getNodeId();
                int n3 = this.iterators[i].getNodeEnd();
                if (n2 < this.curNodeId) {
                    this.curNodeId = n2;
                }
                if (n3 <= this.matchEnd) continue;
                this.matchEnd = n3;
            }
        }
    }

    public boolean checkContiguity() throws EvaluationException {
        PostingIterator[] postingIteratorArray = this.getChildrenInOrder();
        int n = postingIteratorArray.length;
        if (n == 0) {
            return false;
        }
        PostingIterator postingIterator = postingIteratorArray[0];
        int n2 = postingIterator.getNodeEnd();
        for (int i = 1; i < n; ++i) {
            if (postingIteratorArray[i].getNodeId() > n2 + 1) {
                return false;
            }
            int n3 = postingIteratorArray[i].getNodeEnd();
            if (n3 > n2) {
                n2 = n3;
            }
            if (postingIteratorArray[i].checkContiguity()) continue;
            return false;
        }
        return true;
    }

    public PostingIterator[] getChildrenInOrder() {
        if (this.ordered) {
            return this.iterators;
        }
        return super.getChildrenInOrder();
    }

    public double getFulltextScore(Node node) throws EvaluationException {
        if (this.scoringInfo != null) {
            return this.doScoring(node);
        }
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.iterators.length; ++i) {
            double d2 = this.iterators[i].getFulltextScore(node);
            if (!(d2 >= 0.0)) continue;
            d += d2 * d2;
            ++n;
        }
        return n == 0 ? -1.0 : Math.sqrt(d / (double)n);
    }

    public float computeWeighting(Scorer scorer) {
        float[] fArray = new float[this.iterators.length];
        for (int i = 0; i < this.iterators.length; ++i) {
            fArray[i] = this.iterators[i].computeWeighting(scorer);
        }
        this.weightNorm = scorer.normAll(fArray);
        return this.weight / this.weightNorm;
    }

    public float computeScore(Scorer scorer) {
        if (this.subScores == null) {
            this.subScores = new float[this.iterators.length];
        }
        for (int i = 0; i < this.iterators.length; ++i) {
            this.subScores[i] = this.iterators[i].computeScore(scorer);
        }
        return this.weight * this.weightNorm * scorer.scoreAll(this.subScores);
    }
}

