/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries.iterators;

import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.queries.iterators.ContainerIterator;
import com.qizx.queries.iterators.PostingIterator;
import com.qizx.queries.iterators.PostingIteratorBase;

public abstract class BinaryIterator
extends PostingIteratorBase {
    protected PostingIterator it1;
    protected PostingIterator it2;
    protected int currentResetPos;
    protected int nodeSpan;
    protected int nodeDepth;

    protected BinaryIterator(PostingIterator postingIterator, PostingIterator postingIterator2) {
        this.it1 = postingIterator;
        this.it2 = postingIterator2;
    }

    public int getNodeSpan() {
        return this.nodeSpan;
    }

    public int getDepth() {
        return this.nodeDepth;
    }

    public boolean checkWordDistance(int n, int n2, int n3, int n4, int n5) throws EvaluationException {
        return this.it1.checkWordDistance(n, n2, n3, n4, n5);
    }

    public boolean checkBoundary(int n, int n2, boolean bl) throws EvaluationException {
        return this.it1.checkBoundary(n, n2, bl);
    }

    public int closestTextNode(int n, int n2, boolean bl) {
        return this.it1.closestTextNode(n, n2, bl);
    }

    public double getFulltextScore(Node node) throws EvaluationException {
        double d = this.it1.getFulltextScore(node);
        return d >= 0.0 ? d : this.it2.getFulltextScore(node);
    }

    public boolean skipToDoc(int n) throws EvaluationException {
        if (!this.it1.skipToDoc(n) || !this.it2.skipToDoc(n)) {
            return this.noMoreDocs();
        }
        while (this.it1.getDocId() != this.it2.getDocId()) {
            if (!this.it1.skipToDoc(this.it2.getDocId())) {
                return this.noMoreDocs();
            }
            if (this.it2.skipToDoc(this.it1.getDocId())) continue;
            return this.noMoreDocs();
        }
        if (this.it1.getDocId() > this.curDocId) {
            this.changeDoc(this.it1.getDocId());
        }
        return true;
    }

    public void resetToNode(int n) {
        this.currentResetPos = n;
        this.it1.resetToNode(n);
        this.it2.resetToNode(n);
        this.curNodeId = -1;
    }

    public void initContainer(ContainerIterator containerIterator, FullTextFactory fullTextFactory) {
        this.setContainer(containerIterator, fullTextFactory);
        this.it1.initContainer(containerIterator, fullTextFactory);
        this.it2.initContainer(containerIterator, fullTextFactory);
    }

    protected void getValues(PostingIterator postingIterator) {
        this.curNodeId = postingIterator.getNodeId();
        this.nodeSpan = postingIterator.getNodeSpan();
        this.nodeDepth = postingIterator.getDepth();
    }

    public void debug() throws EvaluationException {
        System.err.println(this + " -- iter1 ->");
        this.it1.debug();
        System.err.println(this + " -- iter2 ->");
        this.it2.debug();
        PostingIterator postingIterator = this.bornAgain();
        while (postingIterator.nextNode()) {
            System.err.println("= " + postingIterator.getNodeId());
        }
    }
}

