/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries.iterators;

import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.Scorer;
import com.qizx.queries.FullText;
import com.qizx.queries.iterators.ContainerIterator;
import com.qizx.queries.iterators.PostingIterator;
import com.qizx.util.basic.Util;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xdm.FONIDocument;

public abstract class PostingIteratorBase
implements PostingIterator {
    protected PostingIterator.Filter[] filters;
    protected int depthTest = -1;
    protected ContainerIterator container;
    protected boolean ordered;
    protected int curDocId = -1;
    protected int curNodeId = -1;
    protected int prevNodeEnd = -1;
    protected FullText.Selection ftSelection;
    protected ScoringInfo scoringInfo;
    protected float weight = 1.0f;
    protected float weightNorm;
    protected FONIDocument dm;

    public int getDocId() {
        return this.curDocId;
    }

    public FONIDocument currentDataModel() {
        return this.dm;
    }

    public void resetDoc() {
        this.curDocId = -1;
        this.curNodeId = -1;
    }

    public boolean goNextDoc() throws EvaluationException {
        this.dm = null;
        return this.skipToDoc(this.curDocId + 1);
    }

    public int getNodeId() {
        return this.curNodeId;
    }

    public int getNodeEnd() throws EvaluationException {
        if (this.curNodeId < 0) {
            this.skipToNode(0, 0x7FFFFFFE);
        }
        return this.curNodeId + this.getNodeSpan();
    }

    public int getPrevNodeEnd() {
        return this.prevNodeEnd;
    }

    public int getDepth() {
        return 0;
    }

    public boolean reachedEnd() {
        return this.curNodeId >= 0x7FFFFFFE;
    }

    public int getNodeSpan() {
        return 0;
    }

    public void setFulltextSelection(FullText.Selection selection) {
        this.ftSelection = selection;
    }

    public double getFulltextScore(Node node) throws EvaluationException {
        if (this.scoringInfo != null) {
            return this.doScoring(node);
        }
        return -1.0;
    }

    protected double doScoring(Node node) throws EvaluationException {
        if (this.scoringInfo.scorer == null) {
            this.scoringInfo.init();
        }
        return -1.0;
    }

    private boolean changeScoredDocument(int n, FONIDataModel.FONINode fONINode) {
        if (n <= 0 || n == this.scoringInfo.currentScoredDocId) {
            return false;
        }
        this.scoringInfo.currentScoredDocId = n;
        this.scoringInfo.currentScore = 0.0;
        return true;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public float computeWeighting(Scorer scorer) {
        System.err.println("OOPS computeWeighting !!! " + this);
        return 1.0f;
    }

    public float computeScore(Scorer scorer) {
        throw Util.shouldNotHappen();
    }

    public int computeWordDistance(int n, int n2) throws EvaluationException {
        throw Util.shouldNotHappen(this.getClass());
    }

    public boolean checkContiguity() throws EvaluationException {
        return true;
    }

    public boolean checkWordDistance(int n, int n2, int n3, int n4, int n5) throws EvaluationException {
        throw Util.shouldNotHappen(this.getClass());
    }

    public boolean checkBoundary(int n, int n2, boolean bl) throws EvaluationException {
        throw Util.shouldNotHappen(this.getClass());
    }

    public int closestTextNode(int n, int n2, boolean bl) {
        throw Util.shouldNotHappen(this.getClass());
    }

    protected void changeDoc(int n) {
        if (this.curDocId != n) {
            this.curNodeId = -1;
        }
        this.curDocId = n;
    }

    protected boolean noMoreDocs() {
        this.curDocId = 0x7FFFFFFE;
        return false;
    }

    protected boolean noMoreNodes() {
        this.curNodeId = 0x7FFFFFFE;
        return false;
    }

    protected boolean noMoreNodes(int n) {
        if (n == 0x7FFFFFFE) {
            this.curNodeId = n;
        }
        return false;
    }

    public boolean nextNode() throws EvaluationException {
        while (true) {
            if (this.goNextNode(0x7FFFFFFE)) {
                if (!this.checkFilters()) continue;
                return true;
            }
            this.dm = null;
            if (!this.skipToDoc(this.curDocId + 1)) break;
        }
        return false;
    }

    public boolean goNextNode(int n) throws EvaluationException {
        if (this.curDocId < 0 ? !this.skipToDoc(0) : this.curDocId >= 0x7FFFFFFE) {
            return false;
        }
        return this.skipToNode(this.curNodeId + 1, n);
    }

    public boolean skipToNode(int n, int n2) throws EvaluationException {
        if (this.curNodeId >= n2) {
            return false;
        }
        if (this.curNodeId >= n && this.checkFilters()) {
            return true;
        }
        this.prevNodeEnd = this.curNodeId + this.getNodeSpan();
        while (this.basicSkipToNode(n, n2)) {
            if (this.checkFilters() && this.curNodeId < n2) {
                return true;
            }
            if (this.curNodeId >= n2) {
                return false;
            }
            n = this.curNodeId + 1;
        }
        return false;
    }

    protected abstract boolean basicSkipToNode(int var1, int var2) throws EvaluationException;

    public boolean skipToEnclosing(int n) throws EvaluationException {
        if (this.curNodeId < 0 && !this.skipToNode(0, 0x7FFFFFFE)) {
            return false;
        }
        int n2 = this.getNodeEnd();
        int n3 = this.curNodeId;
        int n4 = 0;
        while (n2 < n) {
            if (!this.basicSkipToNode(n3 + 1, 0x7FFFFFFE)) {
                return false;
            }
            n3 = this.getNodeId();
            n2 = this.getNodeEnd();
            ++n4;
        }
        return true;
    }

    public boolean inRange(int n, int n2) throws EvaluationException {
        return this.skipToNode(n, n2) && this.getNodeId() < n2;
    }

    public boolean nextBefore(int n) throws EvaluationException {
        do {
            if (this.getNodeId() < n && this.goNextNode(n)) continue;
            return false;
        } while (this.getNodeId() >= n);
        return true;
    }

    public int firstFrom(int n) throws EvaluationException {
        this.resetToNode(n);
        return this.goNextNode(0x7FFFFFFE) ? this.getNodeId() : 0x7FFFFFFE;
    }

    public void initContainer(ContainerIterator containerIterator, FullTextFactory fullTextFactory) {
        this.setContainer(containerIterator, fullTextFactory);
    }

    protected void setContainer(ContainerIterator containerIterator, FullTextFactory fullTextFactory) {
        if (this.depthTest != -1) {
            this.container = containerIterator;
        }
        if (this.ftSelection != null) {
            this.scoringInfo = new ScoringInfo(this, fullTextFactory);
        }
    }

    public boolean checkFilters() throws EvaluationException {
        if (this.container != null && !this.basicCheckDepth(this.container)) {
            return false;
        }
        if (this.filters != null) {
            int n = this.filters.length;
            while (--n >= 0) {
                if (this.filters[n].check(this)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean basicCheckDepth(ContainerIterator containerIterator) {
        int n = containerIterator == null ? 0 : containerIterator.getDepth();
        int n2 = this.getDepth() - n;
        if (n2 < 0) {
            return false;
        }
        return this.depthTest < 0 ? n2 >= -1 - this.depthTest : n2 == this.depthTest;
    }

    public PostingIterator.Filter[] getFilters() {
        return this.filters;
    }

    public void setFilters(PostingIterator.Filter[] filterArray) {
        this.filters = filterArray;
    }

    public void addFilter(PostingIterator.Filter filter) {
        if (this.filters == null) {
            this.filters = new PostingIterator.Filter[]{filter};
        } else {
            PostingIterator.Filter[] filterArray = this.filters;
            this.filters = new PostingIterator.Filter[filterArray.length + 1];
            System.arraycopy(filterArray, 0, this.getFilters(), 0, filterArray.length);
            this.filters[filterArray.length] = filter;
        }
    }

    protected PostingIterator copyFilters(PostingIteratorBase postingIteratorBase) {
        postingIteratorBase.setFilters(this.filters);
        postingIteratorBase.setDepthTest(this.depthTest);
        postingIteratorBase.ftSelection = this.ftSelection;
        if (this.scoringInfo != null) {
            postingIteratorBase.scoringInfo = new ScoringInfo(postingIteratorBase, this.scoringInfo.scoringFactory);
        }
        return postingIteratorBase;
    }

    public void setDepthTest(int n) {
        this.depthTest = n;
    }

    static PostingIterator[] bornAgain(PostingIterator[] postingIteratorArray) {
        if (postingIteratorArray == null) {
            return null;
        }
        return PostingIteratorBase.bornAgain(postingIteratorArray, postingIteratorArray.length);
    }

    protected static PostingIterator[] bornAgain(PostingIterator[] postingIteratorArray, int n) {
        if (postingIteratorArray == null) {
            return null;
        }
        PostingIterator[] postingIteratorArray2 = new PostingIterator[n];
        int n2 = postingIteratorArray.length;
        while (--n2 >= 0) {
            PostingIterator postingIterator = postingIteratorArray[n2];
            if (postingIterator == null) continue;
            postingIteratorArray2[n2] = postingIterator.bornAgain();
        }
        return postingIteratorArray2;
    }

    public void debug() throws EvaluationException {
        while (this.nextNode()) {
            System.err.println("node " + this.getNodeId() + "-" + this.getNodeEnd() + " d=" + this.getDepth());
        }
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public boolean segmentOverlap(PostingIterator postingIterator) {
        return false;
    }

    protected static class ScoringInfo {
        public FullTextFactory scoringFactory;
        private PostingIterator ftIterator;
        public int currentScoredDocId;
        private double currentScore;
        private Scorer scorer;

        public ScoringInfo(PostingIterator postingIterator, FullTextFactory fullTextFactory) {
            this.ftIterator = postingIterator;
            this.scoringFactory = fullTextFactory;
            postingIterator.setWeight(1.0f);
        }

        public void init() {
            this.scorer = this.scoringFactory.createScorer();
            this.ftIterator.computeWeighting(this.scorer);
        }
    }
}

