/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;

public class Collations {
    public static final String CODEPOINT = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    public static final String CODEPOINT_SHORT = "/codepoint";
    public static final Locale[] LOCALES = Locale.getAvailableLocales();
    public static Collator CODEPOINT_COLLATOR = Collator.getInstance();
    static final int END = -1;

    public static Collator getInstance(String string) {
        Locale locale;
        if (string.equals(CODEPOINT) || string.equals(CODEPOINT_SHORT)) {
            return CODEPOINT_COLLATOR;
        }
        if (!string.startsWith("/")) {
            return null;
        }
        int n = string.indexOf(45);
        Locale locale2 = locale = n < 0 ? new Locale(string.substring(1)) : new Locale(string.substring(1, n), string.substring(n + 1));
        if (!Collations.localeExists(locale)) {
            return null;
        }
        return Collator.getInstance(locale);
    }

    private static boolean localeExists(Locale locale) {
        int n = LOCALES.length;
        while (--n >= 0) {
            if (!LOCALES[n].equals(locale)) continue;
            return true;
        }
        return false;
    }

    public static Collator getInstanceWithStrength(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(35);
        String string2 = n < 0 ? string : string.substring(0, n);
        Collator collator = Collations.getInstance(string2);
        if (collator == null) {
            return null;
        }
        if (n > 0) {
            String string3 = string.substring(n + 1);
            if (string3.equalsIgnoreCase("primary")) {
                collator.setStrength(0);
            } else if (string3.equalsIgnoreCase("secondary")) {
                collator.setStrength(1);
            } else if (string3.equalsIgnoreCase("tertiary")) {
                collator.setStrength(2);
            } else if (string3.length() > 0) {
                return null;
            }
        }
        return collator;
    }

    public static int compare(String string, String string2, Collator collator) {
        return collator == null || collator == CODEPOINT_COLLATOR ? string.compareTo(string2) : collator.compare(string, string2);
    }

    private static int[] preCollate(String string, RuleBasedCollator ruleBasedCollator) {
        int n;
        int[] nArray = new int[string.length()];
        int n2 = 0;
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
        while ((n = collationElementIterator.next()) != -1) {
            if (n == 0) continue;
            if (n2 >= nArray.length) {
                int[] nArray2 = nArray;
                nArray = new int[nArray2.length * 2];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
            }
            nArray[n2++] = n;
        }
        if (n2 == nArray.length) {
            return nArray;
        }
        int[] nArray3 = new int[n2];
        System.arraycopy(nArray, 0, nArray3, 0, n2);
        return nArray3;
    }

    static boolean tailMatch(CollationElementIterator collationElementIterator, int[] nArray) {
        int n = 1;
        while (n < nArray.length) {
            int n2 = collationElementIterator.next();
            if (n2 == 0) continue;
            if (n2 == -1 || n2 != nArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int indexOf(String string, String string2, Collator collator) {
        int n;
        if (collator == null || collator == CODEPOINT_COLLATOR) {
            return string.indexOf(string2);
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)collator;
        int[] nArray = Collations.preCollate(string2, ruleBasedCollator);
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
        while ((n = collationElementIterator.next()) != -1) {
            if (n == 0 || n != nArray[0]) continue;
            int n2 = collationElementIterator.getOffset();
            if (Collations.tailMatch(collationElementIterator, nArray)) {
                collationElementIterator.setOffset(n2);
                collationElementIterator.previous();
                return collationElementIterator.getOffset();
            }
            collationElementIterator.setOffset(n2);
        }
        return -1;
    }

    public static boolean endsWith(String string, String string2, Collator collator) {
        int n;
        if (collator == null || collator == CODEPOINT_COLLATOR) {
            return string.endsWith(string2);
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)collator;
        int[] nArray = Collations.preCollate(string2, ruleBasedCollator);
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
        while ((n = collationElementIterator.next()) != -1) {
            if (n == 0 || n != nArray[0]) continue;
            int n2 = collationElementIterator.getOffset();
            if (Collations.tailMatch(collationElementIterator, nArray)) {
                return collationElementIterator.next() < 0;
            }
            collationElementIterator.setOffset(n2);
        }
        return false;
    }
}

