/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import com.qizx.util.StringParser;
import java.io.Serializable;
import java.util.Calendar;
import java.util.TimeZone;

public class DateTimeParser
extends StringParser
implements Serializable {
    static Calendar workCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    int year;
    byte month;
    byte day;
    byte hour;
    byte minute;
    double second;
    byte tzSign;
    byte tzHour;
    byte tzMinute;

    public void reset() {
        this.year = 0;
        this.minute = 0;
        this.hour = 0;
        this.day = 0;
        this.month = 0;
        this.second = 0.0;
        this.tzSign = this.tzHour = this.tzMinute;
    }

    public boolean parseDate() {
        if (!this.parseDec(4)) {
            return false;
        }
        this.year = this.latestInt;
        if (!this.pick('-') || !this.parseDec(2)) {
            return false;
        }
        this.month = (byte)this.latestInt;
        if (!this.pick('-') || !this.parseDec(2)) {
            return false;
        }
        this.day = (byte)this.latestInt;
        return true;
    }

    public boolean parseTime() {
        if (!this.parseDec(2)) {
            return false;
        }
        this.hour = (byte)this.latestInt;
        if (!this.pick(':') || !this.parseDec(2)) {
            return false;
        }
        this.minute = (byte)this.latestInt;
        if (!this.pick(':') || !this.parseDec(2)) {
            return false;
        }
        this.second = this.latestInt;
        return true;
    }

    public boolean parseTimezone() {
        this.tzSign = 0;
        if (this.pick('Z')) {
            return true;
        }
        if (this.pick('-')) {
            this.tzSign = (byte)-1;
        } else if (this.pick('+')) {
            this.tzSign = 1;
        } else {
            return false;
        }
        if (!this.parseDec(2)) {
            return false;
        }
        this.tzHour = (byte)this.latestInt;
        if (!this.pick(':') || !this.parseDec(2)) {
            return false;
        }
        this.tzMinute = (byte)this.latestInt;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMillisecondsFromEpoch() {
        Calendar calendar = workCal;
        synchronized (calendar) {
            workCal.clear();
            workCal.set(1, this.year);
            workCal.set(2, this.month - 1);
            workCal.set(5, this.day);
            workCal.set(11, this.hour);
            workCal.set(12, this.minute);
            int n = (int)this.second;
            workCal.set(13, n);
            workCal.set(14, 0);
            if (this.tzSign != 0) {
                workCal.add(11, this.tzSign > 0 ? -this.tzHour : this.tzHour);
                workCal.add(12, this.tzSign > 0 ? -this.tzMinute : this.tzMinute);
            } else {
                workCal.set(15, 0);
            }
            long l = workCal.getTimeInMillis() + (long)((int)(1000.0 * (this.second - (double)n)));
            return l;
        }
    }
}

