/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.util.basic.Check;
import com.qizx.xdm.IQName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class NamespaceContext
implements Serializable {
    private static HashMap internedStrings = new HashMap();
    public static final String EMPTY = NamespaceContext.unique("");
    public static final String XML = NamespaceContext.unique("http://www.w3.org/XML/1998/namespace");
    public static final String XLINK = NamespaceContext.unique("http://www.w3.org/1999/xlink");
    public static final String XSLT = NamespaceContext.unique("http://www.w3.org/1999/XSL/Transform");
    public static final String XSL = NamespaceContext.unique("http://www.w3.org/1999/XSL/Format");
    public static final String XSD = NamespaceContext.unique("http://www.w3.org/2001/XMLSchema");
    public static final String XSI = NamespaceContext.unique("http://www.w3.org/2001/XMLSchema-instance");
    public static final String FN = NamespaceContext.unique("http://www.w3.org/2005/xpath-functions");
    public static final String XDT = NamespaceContext.unique("http://www.w3.org/2005/xpath-datatypes");
    public static final String OP = NamespaceContext.unique("http://www.w3.org/2005/xquery-operators");
    public static final String ERR = NamespaceContext.unique("http://www.w3.org/2005/xqt-errors");
    public static final String LOCAL_NS = NamespaceContext.unique("http://www.w3.org/2005/xquery-local-functions");
    public static final String OUTPUT_NS = NamespaceContext.unique("http://www.w3.org/2009/xquery-serialization");
    private int size = 0;
    private String[] prefixes = new String[8];
    private String[] namespaces = new String[this.prefixes.length];
    private int markPtr;
    private int[] marks = new int[16];
    private int currentMark;

    public void clear() {
        this.size = 0;
        this.markPtr = 0;
        this.currentMark = 0;
    }

    public NamespaceContext copy() {
        NamespaceContext namespaceContext = new NamespaceContext();
        namespaceContext.size = this.size;
        namespaceContext.prefixes = (String[])this.prefixes.clone();
        namespaceContext.namespaces = (String[])this.namespaces.clone();
        namespaceContext.markPtr = this.markPtr;
        namespaceContext.currentMark = this.currentMark;
        namespaceContext.marks = (int[])this.marks.clone();
        return namespaceContext;
    }

    public void newLevel() {
        if (this.markPtr >= this.marks.length) {
            int[] nArray = this.marks;
            this.marks = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, this.marks, 0, nArray.length);
        }
        this.marks[this.markPtr++] = this.currentMark;
        this.currentMark = this.size;
    }

    public void popLevel() {
        this.size = this.currentMark;
        if (this.markPtr > 0) {
            this.currentMark = this.marks[--this.markPtr];
        } else {
            System.err.println("NamespaceContext.popLevel : OOPS");
        }
    }

    public void addMapping(String string, String string2) {
        int n;
        Check.nonNull(string, "prefix");
        Check.nonNull(string2, "namespaceURI");
        string = NamespaceContext.unique(string);
        string2 = NamespaceContext.unique(string2);
        if (string2 == EMPTY) {
            string2 = null;
        }
        int n2 = this.currentMark;
        int n3 = this.size - 1;
        if (this.size > this.currentMark && this.prefixes[this.currentMark] == null) {
            ++n2;
        }
        int n4 = n2;
        while (n2 <= n3) {
            n4 = (n2 + n3) / 2;
            n = string.compareTo(this.prefixes[n4]);
            if (n < 0) {
                n3 = n4 - 1;
                continue;
            }
            if (n > 0) {
                n2 = n4 + 1;
                continue;
            }
            this.namespaces[n4] = string2;
            return;
        }
        this.enlarge();
        n = this.size - n2;
        if (n > 0) {
            System.arraycopy(this.prefixes, n2, this.prefixes, n2 + 1, n);
            System.arraycopy(this.namespaces, n2, this.namespaces, n2 + 1, n);
        }
        this.prefixes[n2] = string;
        this.namespaces[n2] = string2;
        ++this.size;
    }

    private void enlarge() {
        if (this.size >= this.prefixes.length) {
            String[] stringArray = this.prefixes;
            this.prefixes = new String[2 * stringArray.length];
            System.arraycopy(stringArray, 0, this.prefixes, 0, stringArray.length);
            String[] stringArray2 = this.namespaces;
            this.namespaces = new String[this.prefixes.length];
            System.arraycopy(stringArray2, 0, this.namespaces, 0, stringArray2.length);
        }
    }

    public TreeMap getMappings(boolean bl) {
        String string;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        int n = this.size;
        while (--n >= 0 && (string = this.prefixes[n]) != null) {
            if (this.namespaces[n] == null || treeMap.containsKey(string)) continue;
            treeMap.put(string, bl ? "" : this.namespaces[n]);
        }
        return treeMap;
    }

    public String[] getPrefixes() {
        TreeMap treeMap = this.getMappings(false);
        String[] stringArray = new String[treeMap.size()];
        int n = 0;
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public void hideAllNamespaces() {
        TreeMap treeMap = this.getMappings(true);
        for (String string : treeMap.keySet()) {
            this.addMapping(string, "");
        }
    }

    public int size() {
        return this.size;
    }

    public int mark() {
        return this.currentMark;
    }

    public String getPrefix(String string) {
        String string2 = NamespaceContext.unique(string);
        for (int i = 0; i < this.size; ++i) {
            String string3 = this.prefixes[i];
            if (string3 == null) {
                return null;
            }
            if (this.namespaces[i] != string2) continue;
            return this.prefixes[i];
        }
        return null;
    }

    public String getPrefix(int n) {
        return this.prefixes[n];
    }

    public String getNamespaceURI(String string) {
        String string2;
        int n = this.size;
        while (--n >= 0 && (string2 = this.prefixes[n]) != null) {
            if (!string.equals(string2)) continue;
            return this.namespaces[n];
        }
        return null;
    }

    public String getNamespaceURI(int n) {
        return this.namespaces[n];
    }

    public int getLocalSize() {
        int n = this.size - this.currentMark;
        if (n > 0 && this.prefixes[this.currentMark] == null) {
            return n - 1;
        }
        return n;
    }

    public String getLocalPrefix(int n) {
        if (this.prefixes[this.currentMark] == null) {
            ++n;
        }
        return this.prefixes[this.currentMark + n];
    }

    public String getLocalNamespaceURI(int n) {
        if (this.prefixes[this.currentMark] == null) {
            ++n;
        }
        return this.namespaces[this.currentMark + n];
    }

    public boolean isPrefixLocal(String string) {
        String string2;
        int n = this.size;
        while (--n >= this.currentMark && (string2 = this.prefixes[n]) != null) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public IQName expandName(String string) throws DataModelException {
        String string2 = IQName.extractPrefix(string);
        String string3 = this.getNamespaceURI(string2);
        if (string3 == null && "".equals(string2)) {
            string3 = "";
        }
        return string3 == null ? null : IQName.get(string3, IQName.extractLocalName(string));
    }

    public String prefixedName(QName qName) {
        String string = qName.getNamespaceURI();
        if (string.length() == 0) {
            return qName.getLocalPart();
        }
        String string2 = this.getPrefix(string);
        return string2 != null ? string2 + ":" + qName.getLocalPart() : qName.toString();
    }

    public static synchronized String unique(String string) {
        String string2 = (String)internedStrings.get(string);
        if (string2 != null) {
            return string2;
        }
        internedStrings.put(string, string);
        return string;
    }
}

