/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import com.qizx.api.QName;
import com.qizx.xdm.IQName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class QNameTable {
    protected ArrayList names_ = new ArrayList(32);
    protected HashMap nameMap_ = new HashMap();
    protected Key probe = new Key(null, null);

    public int enter(String string, String string2) {
        this.probe.uri = string;
        this.probe.localName = string2;
        Key key = (Key)this.nameMap_.get(this.probe);
        if (key != null) {
            return key.code;
        }
        return this.addName(string, string2);
    }

    public int enter(QName qName) {
        return this.enter(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public int find(String string, String string2) {
        this.probe.uri = string;
        this.probe.localName = string2;
        Key key = (Key)this.nameMap_.get(this.probe);
        return key != null ? key.code : -1;
    }

    public int find(QName qName) {
        return this.find(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public int addName(String string, String string2) {
        Key key = new Key(string, string2);
        key.code = this.names_.size();
        this.names_.add(IQName.get(string, string2));
        this.nameMap_.put(key, key);
        return key.code;
    }

    public IQName getName(int n) {
        if (n < 0 || n >= this.names_.size()) {
            return null;
        }
        return (IQName)this.names_.get(n);
    }

    public int size() {
        return this.names_.size();
    }

    public void clear() {
        this.names_.clear();
        this.nameMap_ = new HashMap();
    }

    public String[] getNamespaces() {
        Vector<String> vector = new Vector<String>();
        int n = this.names_.size();
        while (--n >= 0) {
            String string = this.getName(n).getNamespaceURI();
            int n2 = vector.size();
            while (--n2 >= 0 && string != vector.elementAt(n2)) {
            }
            if (n2 >= 0) continue;
            vector.addElement(string);
        }
        return vector.toArray(new String[vector.size()]);
    }

    static class Key {
        String uri;
        String localName;
        int code;

        Key(String string, String string2) {
            this.uri = string;
            this.localName = string2;
        }

        public int hashCode() {
            return this.uri.hashCode() ^ this.localName.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            return this.uri.equals(key.uri) && this.localName.equals(key.localName);
        }
    }
}

