/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.basic;

import com.qizx.util.StringPattern;
import java.io.File;
import java.util.ArrayList;

public class FileCollector {
    private File root;
    private boolean descent;
    private ArrayList files = new ArrayList();
    private long byteSize;
    private StringPattern filter;

    public FileCollector(String string, boolean bl, StringPattern stringPattern) {
        this(new File(string), bl, stringPattern);
    }

    public FileCollector(File file, boolean bl, StringPattern stringPattern) {
        this.root = file;
        this.descent = bl;
        this.filter = stringPattern;
    }

    public File getRoot() {
        return this.root;
    }

    public boolean hasDirRoot() {
        return this.root.isDirectory();
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public int getSize() {
        return this.files.size();
    }

    public void collect() {
        if (this.root.isDirectory()) {
            this.descent(this.root);
        } else if (this.root.isFile()) {
            this.addFile(this.root);
        }
    }

    private void addFile(File file) {
        this.files.add(file);
        this.byteSize += file.length();
    }

    private void descent(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                if (!this.descent) continue;
                this.descent(file2);
                continue;
            }
            if (this.filter != null && !this.filter.matches(file2.getName())) continue;
            this.addFile(file2);
        }
    }

    public File getFile(int n) {
        return (File)this.files.get(n);
    }

    public StringPattern getFilter() {
        return this.filter;
    }

    public void setFilter(StringPattern stringPattern) {
        this.filter = stringPattern;
    }
}

