/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.basic;

import com.qizx.util.LikePattern;
import com.qizx.util.ProgressHandler;
import com.qizx.util.basic.PathUtil;
import com.qizx.util.basic.Util;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

public final class FileUtil {
    private static String syncProp = System.getProperty("use.file.sync");
    public static boolean useSync = "true".equalsIgnoreCase(syncProp);
    private static String platformDefaultEncoding = new OutputStreamWriter(System.out).getEncoding();

    public static File urlToFile(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            return null;
        }
        String string = uRL.getPath();
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return new File(string);
    }

    public static File urlToFile(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL == null ? null : FileUtil.urlToFile(uRL);
    }

    public static String urlToFileName(URL uRL) {
        File file = FileUtil.urlToFile(uRL);
        return file == null ? null : file.getPath();
    }

    public static String urlToFileName(String string) {
        File file = FileUtil.urlToFile(string);
        return file == null ? null : file.getPath();
    }

    public static URL fileToURL(File file) {
        URL uRL;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        try {
            String string = file.getPath().replace('\\', '/');
            uRL = new URL("file", "", string);
        }
        catch (IOException iOException) {
            uRL = null;
        }
        return uRL;
    }

    public static URL dirToURL(File file) {
        URL uRL;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        try {
            String string = file.getPath();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            uRL = new URL("file", "", string.replace('\\', '/'));
        }
        catch (IOException iOException) {
            uRL = null;
        }
        return uRL;
    }

    public static String fileToSystemId(File file) throws IOException {
        file = file.getCanonicalFile();
        String string = file.getAbsolutePath();
        if (File.separatorChar == '\\' && (string = string.replace('\\', '/')).length() > 2 && string.charAt(1) == ':') {
            return "file:///" + string.substring(0, 2) + Util.escapeURI(string.substring(2));
        }
        return "file://" + Util.escapeURI(string);
    }

    public static String urlToSystemId(URL uRL) throws IOException {
        return Util.escapeURI(uRL.getPath());
    }

    public static URL fileToURL(String string) {
        return FileUtil.fileToURL(new File(string));
    }

    public static String resolve(String string, String string2) {
        if (string == null) {
            return string2;
        }
        try {
            URI uRI = new URI(string);
            return uRI.resolve(string2).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return string2;
        }
    }

    public static URI uriConvert(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URL uriToURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL("file", "", string);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    public static URL toURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String fileToURLName(File file) {
        URL uRL = FileUtil.fileToURL(file);
        return uRL == null ? null : uRL.toExternalForm();
    }

    public static String fileToURLName(String string) {
        URL uRL = FileUtil.fileToURL(string);
        return uRL == null ? null : uRL.toExternalForm();
    }

    public static File resolve(File file, String string) throws URISyntaxException {
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            return file2;
        }
        return new File(file, string);
    }

    public static String fileDirName(String string) {
        String string2;
        char c = File.separatorChar;
        int n = string.lastIndexOf(c);
        if (n < 0 && c == '\\') {
            c = '/';
            n = string.lastIndexOf(c);
        }
        if (n < 0) {
            string2 = ".";
        } else if (n == 0) {
            string2 = File.separator;
        } else {
            string2 = string.substring(0, n);
            if (c != File.separatorChar) {
                string2 = string2.replace(c, File.separatorChar);
            }
        }
        return string2;
    }

    public static String fileBaseName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        if (n < 0) {
            return string;
        }
        if (n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String fileExtension(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 <= n || n2 == string.length() - 1) {
            return "";
        }
        return string.substring(n2 + 1);
    }

    public static String trimFileExtension(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static boolean fileHasExtension(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        if (n2 > n) {
            return false;
        }
        int n3 = n2;
        while (--n3 >= 0) {
            if (Character.toLowerCase(string2.charAt(n3)) == Character.toLowerCase(string.charAt(n - n2 + n3))) continue;
            return false;
        }
        return true;
    }

    public static String relativize(File file, File file2) {
        if (file2 == null) {
            return file.getAbsolutePath();
        }
        String string = PathUtil.relativize(FileUtil.fileToURL(file).getPath(), FileUtil.fileToURL(file2).getPath());
        if (File.separatorChar != '/') {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    public static File[] expandPathPattern(File file) {
        Object[] objectArray;
        LikePattern likePattern = new LikePattern(file.getName());
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(".");
        }
        if (file2 == null || (objectArray = file2.list()) == null) {
            return new File[0];
        }
        int n = 0;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!likePattern.matches(objectArray[i])) continue;
            objectArray[n++] = objectArray[i];
        }
        Arrays.sort(objectArray, 0, n);
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(file2, (String)objectArray[i]);
        }
        return fileArray;
    }

    public static boolean removeFile(String string) {
        return FileUtil.removeFile(string, false);
    }

    public static boolean removeFile(String string, boolean bl) {
        return FileUtil.removeFile(new File(string), bl);
    }

    public static boolean removeFile(File file, boolean bl) {
        if (file.isDirectory() && bl) {
            FileUtil.emptyDirectory(file);
        }
        return file.delete();
    }

    public static boolean isEmptyDirectory(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        return stringArray == null || stringArray.length == 0;
    }

    public static long directorySize(File file) {
        File[] fileArray = file.listFiles();
        long l = 0L;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    l += FileUtil.directorySize(file2);
                    continue;
                }
                l += file2.length();
            }
        }
        return l + file.length();
    }

    public static boolean emptyDirectory(String string) {
        return FileUtil.emptyDirectory(new File(string));
    }

    public static boolean emptyDir(String string) {
        return FileUtil.emptyDirectory(new File(string));
    }

    public static boolean emptyDirectory(File file) {
        String[] stringArray = file.list();
        boolean bl = true;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    if (FileUtil.removeFile(file2, true)) continue;
                    bl = false;
                    continue;
                }
                if (file2.delete()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static void copyFile(String string, String string2) throws IOException {
        FileUtil.copyFile(new File(string), new File(string2), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2, ProgressHandler progressHandler) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileUtil.copy(fileInputStream, fileOutputStream, progressHandler);
        }
        finally {
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, ProgressHandler progressHandler) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        long l2 = 0x400000L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            if (progressHandler == null || (l += (long)n) < l2) continue;
            progressHandler.progressDone(l);
            l2 += 0x400000L;
        }
        outputStream.flush();
    }

    public static void copyDirectory(String string, String string2) throws IOException {
        File file = FileUtil.nameToFile(string);
        File file2 = FileUtil.nameToFile(string2);
        FileUtil.ensureDirExists(file2);
        FileUtil.copyDirectory(file, file2);
    }

    private static File nameToFile(String string) throws IOException {
        File file = null;
        if (string.startsWith("file:")) {
            try {
                file = new File(new URI(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file == null) {
            file = new File(string).getCanonicalFile();
        }
        return file;
    }

    public static void ensureDirExists(String string) throws IOException {
        FileUtil.ensureDirExists(new File(string));
    }

    public static void ensureDirExists(File file) throws IOException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("'" + file + "' exists but is not a directory");
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null) {
                FileUtil.ensureDirExists(file2);
            }
            if (!file.mkdir()) {
                throw new IOException("cannot create directory '" + file + "'");
            }
        }
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file3 = new File(file, string);
            File file4 = new File(file2, string);
            if (file3.isDirectory()) {
                if (!file4.mkdir()) {
                    throw new IOException("cannot create directory '" + file4 + "'");
                }
                FileUtil.copyDirectory(file3, file4);
                continue;
            }
            FileUtil.copyFile(file3, file4, null);
        }
    }

    public static String loadString(String string) throws IOException {
        return FileUtil.loadString(new File(string));
    }

    public static String loadString(File file) throws IOException {
        return FileUtil.loadString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string2 = null;
        try {
            string2 = FileUtil.loadString(fileInputStream, string);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return string2;
    }

    public static String loadString(URL uRL) throws IOException {
        return FileUtil.loadString(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(URL uRL, boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(bl);
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        String string = null;
        String string2 = uRLConnection.getContentType();
        if (string2 != null) {
            string = FileUtil.contentTypeToCharsetName(string2);
        }
        InputStream inputStream = uRLConnection.getInputStream();
        String string3 = null;
        try {
            string3 = FileUtil.loadString(inputStream, string);
        }
        finally {
            inputStream.close();
        }
        return string3;
    }

    public static String contentTypeToCharsetName(String string) {
        int n;
        string = string.toLowerCase();
        String string2 = null;
        int n2 = string.indexOf("charset=");
        if (n2 >= 0 && n2 + 8 < string.length() - 1 && (n = (string2 = string.substring(n2 + 8).trim()).length()) >= 2 && string2.charAt(0) == '\"') {
            string2 = string2.substring(1, n - 1);
        }
        return string2;
    }

    public static String loadString(InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        return FileUtil.loadString(inputStreamReader);
    }

    public static String loadString(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static void saveString(String string, String string2) throws IOException {
        FileUtil.saveString(string, new File(string2));
    }

    public static void saveString(String string, File file) throws IOException {
        FileUtil.saveString(string, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveString(String string, File file, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            FileUtil.saveString(string, fileOutputStream, string2);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    private static void saveString(String string, OutputStream outputStream, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = string2 == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string2);
        outputStreamWriter.write(string, 0, string.length());
        outputStreamWriter.flush();
    }

    public static byte[] loadBytes(String string) throws IOException {
        return FileUtil.loadBytes(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = null;
        try {
            byArray = FileUtil.loadBytes(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return byArray;
    }

    public static byte[] loadBytes(URL uRL) throws IOException {
        return FileUtil.loadBytes(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(URL uRL, boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(bl);
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = null;
        try {
            byArray = FileUtil.loadBytes(inputStream);
        }
        finally {
            inputStream.close();
        }
        return byArray;
    }

    public static byte[] loadBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isGzipped(String string) throws IOException {
        return FileUtil.isGzipped(new File(string));
    }

    public static boolean isGzipped(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = ((InputStream)fileInputStream).read();
        int n2 = ((InputStream)fileInputStream).read();
        ((InputStream)fileInputStream).close();
        return n == 31 && n2 == 139;
    }

    public static String loadGzippedString(String string) throws IOException {
        return FileUtil.loadGzippedString(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGzippedString(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = null;
        try {
            string = FileUtil.loadGzippedString(fileInputStream, null);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return string;
    }

    public static String loadGzippedString(URL uRL) throws IOException {
        return FileUtil.loadGzippedString(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGzippedString(URL uRL, boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(bl);
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        String string = null;
        try {
            string = FileUtil.loadGzippedString(inputStream, null);
        }
        finally {
            inputStream.close();
        }
        return string;
    }

    public static Properties loadProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Properties properties = FileUtil.loadProperties(fileInputStream);
            return properties;
        }
        finally {
            fileInputStream.close();
        }
    }

    private static String loadGzippedString(InputStream inputStream, String string) throws IOException {
        int n;
        if (string == null) {
            string = FileUtil.defaultEncoding();
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new GZIPInputStream(inputStream), string);
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static String defaultEncoding() {
        return platformDefaultEncoding;
    }

    public static void consoleWrite(String string) {
        System.out.println(string);
        System.out.flush();
    }

    public static String consoleRead(String string) {
        try {
            System.out.print(string);
            System.out.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            return bufferedReader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

