/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.basic;

public class HTable {
    static final double LOAD_FACTOR = 1.0;
    protected Key[] hash;
    protected int count = 0;
    protected int maxCount;

    public HTable(int n) {
        this.hash = new Key[n];
        this.maxCount = (int)(1.0 * (double)this.hash.length);
    }

    public HTable() {
        this(3);
    }

    public int getSize() {
        return this.count;
    }

    public Key[] getHash() {
        return this.hash;
    }

    public int hash(Key key) {
        return HTable.hashFunction(key.hashCode()) % this.hash.length;
    }

    public static int hashFunction(int n) {
        return n & Integer.MAX_VALUE;
    }

    public Key get(Key key) {
        int n = this.hash(key);
        Key key2 = this.hash[n];
        while (key2 != null) {
            if (key2.equals(key)) {
                return key2;
            }
            key2 = key2.next;
        }
        return null;
    }

    public Key put(Key key) {
        int n = this.hash(key);
        Key key2 = this.hash[n];
        while (key2 != null) {
            if (key2.equals(key)) {
                return key2;
            }
            key2 = key2.next;
        }
        if (++this.count > this.maxCount) {
            this.resize();
            n = this.hash(key);
        }
        key2 = key.duplicate();
        key2.next = this.hash[n];
        this.hash[n] = key2;
        return key2;
    }

    public boolean hasPut(Key key) {
        int n = this.hash(key);
        Key key2 = this.hash[n];
        while (key2 != null) {
            if (key2.equals(key)) {
                return false;
            }
            key2 = key2.next;
        }
        if (++this.count > this.maxCount) {
            this.resize();
            n = this.hash(key);
        }
        key2 = key.duplicate();
        key2.next = this.hash[n];
        this.hash[n] = key2;
        return true;
    }

    public Key add(Key key) {
        int n = this.hash(key);
        Key key2 = key.duplicate();
        key2.next = this.hash[n];
        this.hash[n] = key2;
        if (++this.count > this.maxCount) {
            this.resize();
        }
        return key2;
    }

    public void directPut(Key key) {
        if (++this.count > this.maxCount) {
            this.resize();
        }
        int n = this.hash(key);
        key.next = this.hash[n];
        this.hash[n] = key;
    }

    public Key[] getKeys(Key[] keyArray) {
        int n = 0;
        int n2 = this.hash.length;
        while (--n2 >= 0) {
            Key key = this.hash[n2];
            while (key != null) {
                keyArray[n++] = key;
                key = key.next;
            }
        }
        return keyArray;
    }

    public void clear() {
        int n = this.hash.length;
        while (--n >= 0) {
            this.hash[n] = null;
        }
        this.count = 0;
    }

    void resize() {
        int n;
        Key[] keyArray = this.hash;
        int n2 = 0;
        for (n = 0; n < this.hash.length; ++n) {
            if (this.hash[n] != null) continue;
            ++n2;
        }
        this.hash = new Key[keyArray.length * 2 + 1];
        n = keyArray.length;
        while (--n >= 0) {
            Key key = keyArray[n];
            while (key != null) {
                Key key2 = key;
                key = key.next;
                int n3 = this.hash(key2);
                key2.next = this.hash[n3];
                this.hash[n3] = key2;
            }
        }
        this.maxCount = (int)(1.0 * (double)this.hash.length);
    }

    public static abstract class Key {
        public Key next;

        public abstract Key duplicate();
    }
}

