/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.io;

import com.qizx.util.io.ByteInput;
import java.io.IOException;
import java.io.Serializable;

public abstract class ByteInputBase
implements ByteInput,
Serializable {
    protected int maxBufferSize;
    protected byte[] data;
    protected int bufSize;
    protected int ptr;
    protected char[] strBuffer = new char[128];
    protected int blocksRead;

    public ByteInputBase() {
        this(4096);
    }

    public ByteInputBase(int n) {
        this.maxBufferSize = n;
        this.data = new byte[this.maxBufferSize];
        this.reset();
    }

    public ByteInputBase(byte[] byArray, int n) {
        this.data = byArray;
        this.bufSize = n;
        this.ptr = 0;
    }

    public void reset() {
        this.ptr = 0;
        this.bufSize = 0;
        this.blocksRead = 0;
    }

    public void close() throws IOException {
    }

    protected abstract int readBuffer() throws IOException;

    public long tell() {
        return (this.blocksRead - 1) * this.data.length + this.ptr;
    }

    public int getByte() throws IOException {
        if (this.ptr >= this.bufSize) {
            int n = this.readBuffer();
            if (n <= 0) {
                return -1;
            }
            ++this.blocksRead;
            this.bufSize = n;
            this.ptr = 1;
            return this.data[0] & 0xFF;
        }
        return this.data[this.ptr++] & 0xFF;
    }

    public int getBytes(byte[] byArray) throws IOException {
        return this.getBytes(byArray, 0, byArray.length);
    }

    public int getBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (this.ptr >= this.bufSize) {
                n4 = this.readBuffer();
                ++this.blocksRead;
                if (n4 <= 0) {
                    return n3;
                }
                this.bufSize = n4;
                this.ptr = 0;
            }
            n4 = Math.min(this.bufSize - this.ptr, n2 - n3);
            System.arraycopy(this.data, this.ptr, byArray, n, n4);
            this.ptr += n4;
            n3 += n4;
            n += n4;
        }
        return n3;
    }

    public int getInt() throws IOException {
        int n = this.getByte() & 0xFF;
        int n2 = this.getByte() & 0xFF;
        int n3 = this.getByte() & 0xFF;
        int n4 = this.getByte() & 0xFF;
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public int getVint() throws IOException {
        if (this.ptr <= this.bufSize - 5) {
            return (int)this.decode();
        }
        return (int)this.slowGetVlong();
    }

    public long getLong() throws IOException {
        long l = this.getByte() & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l = l << 8 | (long)(this.getByte() & 0xFF);
        }
        return l;
    }

    public long getVlong() throws IOException {
        if (this.ptr <= this.bufSize - 9) {
            return this.decode();
        }
        return this.slowGetVlong();
    }

    public double getDouble() throws IOException {
        long l = this.getByte();
        for (int i = 0; i < 7; ++i) {
            l = l << 8 | (long)this.getByte();
        }
        return Double.longBitsToDouble(l);
    }

    public void getChars(char[] cArray, int n, int n2, boolean bl) throws IOException {
        if (n2 < 0 || n + n2 > cArray.length) {
            n2 = cArray.length - n;
        }
        if (bl) {
            if (this.ptr + 2 * n2 < this.bufSize) {
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.ptr + 2 * i;
                    byte by = this.data[n3];
                    int n4 = this.data[n3 + 1] & 0xFF;
                    cArray[n + i] = (char)((by << 8) + n4);
                }
                this.ptr += 2 * n2;
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n5 = this.getByte();
                    int n6 = (n5 << 8) + (this.getByte() & 0xFF);
                    cArray[n + i] = (char)n6;
                }
            }
        } else if (this.ptr + n2 < this.bufSize) {
            for (int i = 0; i < n2; ++i) {
                cArray[n + i] = (char)(this.data[this.ptr + i] & 0xFF);
            }
            this.ptr += n2;
        } else {
            for (int i = 0; i < n2; ++i) {
                cArray[n + i] = (char)(this.getByte() & 0xFF);
            }
        }
    }

    public String getString() throws IOException {
        boolean bl;
        int n = this.getVint();
        boolean bl2 = bl = (n & 1) != 0;
        if ((n >>= 1) > this.strBuffer.length) {
            this.strBuffer = new char[n + n / 4];
        }
        this.getChars(this.strBuffer, 0, n, bl);
        return new String(this.strBuffer, 0, n);
    }

    public char[] getChars() throws IOException {
        int n = this.getVint();
        boolean bl = (n & 1) != 0;
        char[] cArray = new char[n >>= 1];
        this.getChars(cArray, 0, n, bl);
        return cArray;
    }

    public void getChars(char[] cArray, int n) throws IOException {
        this.getChars(cArray, 0, n, true);
    }

    private long slowGetVlong() throws IOException {
        int n = this.getByte();
        if (n < 128) {
            return n;
        }
        switch (n & 0x7F) {
            default: {
                return (n & 0x3F) << 8 | this.getByte();
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                int n2 = this.getByte();
                int n3 = this.getByte();
                return (n & 0x1F) << 16 | n2 << 8 | n3;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return this.slowGetBytes(n & 0xF, 3);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return this.slowGetBytes(n & 7, 4);
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return this.slowGetBytes(n & 3, 5);
            }
            case 124: {
                return this.slowGetBytes(0L, 6);
            }
            case 125: {
                return this.slowGetBytes(0L, 7);
            }
            case 126: {
                return this.slowGetBytes(0L, 8);
            }
            case 127: 
        }
        throw new RuntimeException("bad header for Vlong");
    }

    private long slowGetBytes(long l, int n) throws IOException {
        int n2 = (n - 1) * 8;
        l <<= n2 + 8;
        int n3 = 0;
        while (n3 < n) {
            l |= (long)this.getByte() << n2;
            ++n3;
            n2 -= 8;
        }
        return l;
    }

    public long decode() {
        byte by = this.data[this.ptr];
        if (by >= 0) {
            ++this.ptr;
            return by;
        }
        switch (by & 0x7F) {
            default: {
                this.ptr += 2;
                return (by & 0x3F) << 8 | this.data[this.ptr - 1] & 0xFF;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.ptr += 3;
                return (by & 0x1F) << 16 | (this.data[this.ptr - 2] & 0xFF) << 8 | this.data[this.ptr - 1] & 0xFF;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this.ptr += 4;
                int n = (by & 0xF) << 24 | (this.data[this.ptr - 3] & 0xFF) << 16 | (this.data[this.ptr - 2] & 0xFF) << 8 | this.data[this.ptr - 1] & 0xFF;
                return (long)n & 0xFFFFFFFFL;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return this.decodeBytes(by & 7, 4);
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return this.decodeBytes(by & 3, 5);
            }
            case 124: {
                return this.decodeBytes(0L, 6);
            }
            case 125: {
                return this.decodeBytes(0L, 7);
            }
            case 126: {
                return this.decodeBytes(0L, 8);
            }
            case 127: 
        }
        throw new RuntimeException("bad header for Vlong");
    }

    private long decodeBytes(long l, int n) {
        int n2 = (n - 1) * 8;
        l <<= n2 + 8;
        int n3 = 1;
        while (n3 <= n) {
            l |= (long)(this.data[this.ptr + n3] & 0xFF) << n2;
            ++n3;
            n2 -= 8;
        }
        this.ptr += n + 1;
        return l;
    }

    public int read(byte[] byArray) throws IOException {
        return this.getBytes(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.getBytes(byArray, n, n2);
        return n3;
    }

    public int read() throws IOException {
        return this.getByte();
    }

    public void inspect() {
        System.err.println(this.getClass() + " ptr=" + this.ptr + " bufSize=" + this.bufSize);
    }
}

