/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.io;

import com.qizx.util.io.ByteOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public abstract class ByteOutputBase
implements ByteOutput,
Serializable {
    protected int bufferSize;
    protected byte[] data;
    protected int bufPtr;
    protected int curFlushMark = -1;
    protected boolean trace = false;

    protected ByteOutputBase() {
        this(8192);
    }

    protected ByteOutputBase(int n) {
        this.bufferSize = n;
        this.data = new byte[this.bufferSize];
    }

    protected ByteOutputBase(byte[] byArray) {
        this.bufferSize = byArray.length;
        this.data = byArray;
    }

    protected abstract void writeBuffer(byte[] var1, int var2) throws IOException;

    public void reset() {
        this.bufPtr = 0;
        this.curFlushMark = -1;
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (this.bufPtr > 0) {
            this.flushBuffer();
        }
    }

    public void flushMark() throws IOException {
        this.curFlushMark = this.bufPtr;
    }

    protected void flushBuffer() throws IOException {
        if (this.trace) {
            System.err.println("FlushMark " + this.curFlushMark + " " + this.bufPtr);
        }
        int n = this.curFlushMark > 0 ? this.curFlushMark : this.bufPtr;
        this.writeBuffer(this.data, n);
        if (this.curFlushMark < 0) {
            this.bufPtr = 0;
        } else if (this.curFlushMark == 0) {
            byte[] byArray = this.data;
            this.bufferSize *= 2;
            this.data = new byte[this.bufferSize];
            System.arraycopy(byArray, 0, this.data, 0, this.bufPtr);
        } else {
            this.bufPtr -= n;
            System.arraycopy(this.data, n, this.data, 0, this.bufPtr);
            this.curFlushMark = 0;
        }
    }

    public void putByte(int n) throws IOException {
        this.putByte((byte)n);
    }

    public void putByte(byte by) throws IOException {
        if (this.bufPtr >= this.bufferSize) {
            this.flushBuffer();
        }
        this.data[this.bufPtr++] = by;
    }

    public void putBytes(byte[] byArray, int n) throws IOException {
        this.putBytes(byArray, 0, n);
    }

    public void putBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.trace) {
            System.err.println(" put bytes " + n2);
        }
        while (n2 > 0) {
            int n3 = Math.min(this.bufferSize - this.bufPtr, n2);
            System.arraycopy(byArray, n, this.data, this.bufPtr, n3);
            this.bufPtr += n3;
            if (this.bufPtr >= this.bufferSize) {
                this.flushBuffer();
            }
            n2 -= n3;
            n += n3;
        }
    }

    public void padding(int n, int n2) throws IOException {
        while (n > 0) {
            int n3 = Math.min(this.bufferSize - this.bufPtr, n);
            Arrays.fill(this.data, this.bufPtr, this.bufferSize, (byte)n2);
            n -= n3;
            this.bufPtr += n3;
            if (this.bufPtr < this.bufferSize) continue;
            this.flushBuffer();
        }
    }

    public void putInt(int n) throws IOException {
        this.putByte((byte)(n >> 24));
        this.putByte((byte)(n >> 16));
        this.putByte((byte)(n >> 8));
        this.putByte((byte)n);
    }

    public void putVint(int n) throws IOException {
        if (this.trace) {
            System.err.println(" put int " + n);
        }
        if (this.bufPtr <= this.bufferSize - 5) {
            this.bufPtr = ByteOutputBase.encodeInt(n, this.data, this.bufPtr);
        } else {
            this.slowPutVlong(n);
        }
    }

    public void putLong(long l) throws IOException {
        this.putByte((byte)(l >> 56));
        this.putByte((byte)(l >> 48));
        this.putByte((byte)(l >> 40));
        this.putByte((byte)(l >> 32));
        this.putByte((byte)(l >> 24));
        this.putByte((byte)(l >> 16));
        this.putByte((byte)(l >> 8));
        this.putByte((byte)l);
    }

    public void putVlong(long l) throws IOException {
        if (this.trace) {
            System.err.println(" put long " + l);
        }
        if (this.bufPtr <= this.bufferSize - 9) {
            this.bufPtr = ByteOutputBase.encodeLong(l, this.data, this.bufPtr);
        } else {
            this.slowPutVlong(l);
        }
    }

    public void putDouble(double d) throws IOException {
        if (this.trace) {
            System.err.println(" put double " + d);
        }
        long l = Double.doubleToRawLongBits(d);
        if (this.bufPtr <= this.bufferSize - 8) {
            this.data[this.bufPtr + 0] = (byte)(l >> 56);
            this.data[this.bufPtr + 1] = (byte)(l >> 48);
            this.data[this.bufPtr + 2] = (byte)(l >> 40);
            this.data[this.bufPtr + 3] = (byte)(l >> 32);
            this.data[this.bufPtr + 4] = (byte)(l >> 24);
            this.data[this.bufPtr + 5] = (byte)(l >> 16);
            this.data[this.bufPtr + 6] = (byte)(l >> 8);
            this.data[this.bufPtr + 7] = (byte)l;
            this.bufPtr += 8;
        } else {
            this.slowPutBytes(l, 8);
        }
    }

    public void putString(String string) throws IOException {
        if (string == null) {
            string = "";
        }
        if (this.trace) {
            System.err.println(" put chars " + string);
        }
        int n = string.length();
        boolean bl = ByteOutputBase.isWideString(string);
        this.putVint((n << 1) + (bl ? 1 : 0));
        if (bl) {
            if (this.bufPtr + 2 * n <= this.bufferSize) {
                for (int i = 0; i < n; ++i) {
                    int n2 = this.bufPtr + 2 * i;
                    char c = string.charAt(i);
                    this.data[n2] = (byte)(c >> 8);
                    this.data[n2 + 1] = (byte)c;
                }
                this.bufPtr += 2 * n;
            } else {
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    this.putByte((byte)(c >> 8));
                    this.putByte((byte)c);
                }
            }
        } else if (this.bufPtr + n <= this.bufferSize) {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                this.data[this.bufPtr + i] = (byte)c;
            }
            this.bufPtr += n;
        } else {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                this.putByte((byte)c);
            }
        }
    }

    public void putChars(char[] cArray, int n, int n2) throws IOException {
        boolean bl;
        if (n < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.trace) {
            System.err.println(" put chars " + new String(cArray));
        }
        this.putVint((n2 << 1) + ((bl = ByteOutputBase.isWideString(cArray, n, n2)) ? 1 : 0));
        if (bl) {
            if (this.bufPtr + 2 * n2 <= this.bufferSize) {
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.bufPtr + 2 * i;
                    char c = cArray[n + i];
                    this.data[n3] = (byte)(c >> 8);
                    this.data[n3 + 1] = (byte)c;
                }
                this.bufPtr += 2 * n2;
            } else {
                for (int i = 0; i < n2; ++i) {
                    char c = cArray[n + i];
                    this.putByte((byte)(c >> 8));
                    this.putByte((byte)c);
                }
            }
        } else if (this.bufPtr + n2 <= this.bufferSize) {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                this.data[this.bufPtr + i] = (byte)c;
            }
            this.bufPtr += n2;
        } else {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                this.putByte((byte)c);
            }
        }
    }

    public void putChars(char[] cArray) throws IOException {
        this.putChars(cArray, 0, cArray.length);
    }

    public static int bytesForVint(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative code: " + n);
        }
        if (n < 128) {
            return 1;
        }
        if (n < 16384) {
            return 2;
        }
        if (n < 0x200000) {
            return 3;
        }
        if (n < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public static int bytesForVlong(long l) {
        if (l < 0x10000000L) {
            return ByteOutputBase.bytesForVint((int)l);
        }
        if (l < 0x800000000L) {
            return 5;
        }
        if (l < 0x40000000000L) {
            return 6;
        }
        return 7;
    }

    public static int bytesForSignedVlong(long l) {
        return ByteOutputBase.bytesForVlong(Math.abs(l) << 1);
    }

    public static int bytesForString(String string) {
        int n = string.length();
        return ByteOutputBase.bytesForVint(n << 1) + (ByteOutputBase.isWideString(string) ? 2 * n : n);
    }

    public static boolean isWideString(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (cArray[n + i] < '\u0100') continue;
            return true;
        }
        return false;
    }

    public static boolean isWideString(String string) {
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) < '\u0100') continue;
            return true;
        }
        return false;
    }

    private void slowPutVlong(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("negative code " + l);
        }
        int n = 0;
        if (l < 128L) {
            this.putByte((int)l);
        } else if (l < 16384L) {
            this.putByte((int)(l >> 8 | 0x80L));
            n = 1;
        } else if (l < 0x200000L) {
            this.putByte((int)(l >> 16 | 0xC0L));
            n = 2;
        } else if (l < 0x10000000L) {
            this.putByte((int)(l >> 24 | 0xE0L));
            n = 3;
        } else if (l < 0x800000000L) {
            this.putByte((int)(l >> 32 | 0xF0L));
            n = 4;
        } else if (l < 0x40000000000L) {
            this.putByte((int)(l >> 40 | 0xF8L));
            n = 5;
        } else if (l < 0x1000000000000L) {
            this.putByte(252);
            n = 6;
        } else if (l < 0x100000000000000L) {
            this.putByte(253);
            n = 7;
        } else {
            this.putByte(254);
            n = 8;
        }
        this.slowPutBytes(l, n);
    }

    private void slowPutBytes(long l, int n) throws IOException {
        int n2 = (n - 1) * 8;
        int n3 = 0;
        while (n3 < n) {
            this.putByte((int)(l >> n2));
            ++n3;
            n2 -= 8;
        }
    }

    public static int encodeInt(int n, byte[] byArray, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("negative code " + n);
        }
        if (n < 128) {
            byArray[n2] = (byte)n;
            return n2 + 1;
        }
        if (n < 16384) {
            byArray[n2] = (byte)(n >> 8 | 0x80);
            byArray[n2 + 1] = (byte)n;
            return n2 + 2;
        }
        if (n < 0x200000) {
            byArray[n2] = (byte)(n >> 16 | 0xC0);
            byArray[n2 + 1] = (byte)(n >> 8);
            byArray[n2 + 2] = (byte)n;
            return n2 + 3;
        }
        if (n < 0x10000000) {
            byArray[n2] = (byte)(n >> 24 | 0xE0);
            return ByteOutputBase.encodeBytes(n, 4, byArray, n2);
        }
        byArray[n2] = -16;
        return ByteOutputBase.encodeBytes(n, 5, byArray, n2);
    }

    public static int encodeLong(long l, byte[] byArray, int n) {
        if (l < 0L) {
            throw new IllegalArgumentException("negative code " + l);
        }
        if (l < 0x10000000L) {
            return ByteOutputBase.encodeInt((int)l, byArray, n);
        }
        if (l < 0x800000000L) {
            byArray[n] = (byte)(l >> 32 | 0xF0L);
            return ByteOutputBase.encodeBytes(l, 5, byArray, n);
        }
        if (l < 0x40000000000L) {
            byArray[n] = (byte)(l >> 40 | 0xF8L);
            return ByteOutputBase.encodeBytes(l, 6, byArray, n);
        }
        if (l < 0x1000000000000L) {
            byArray[n] = -4;
            return ByteOutputBase.encodeBytes(l, 7, byArray, n);
        }
        if (l < 0x100000000000000L) {
            byArray[n] = -3;
            return ByteOutputBase.encodeBytes(l, 8, byArray, n);
        }
        byArray[n] = -2;
        return ByteOutputBase.encodeBytes(l, 9, byArray, n);
    }

    private static final int encodeBytes(long l, int n, byte[] byArray, int n2) {
        int n3 = (n - 2) * 8;
        int n4 = 1;
        while (n4 < n) {
            byArray[n2 + n4] = (byte)(l >> n3);
            ++n4;
            n3 -= 8;
        }
        return n2 + n;
    }

    public int getPointer() {
        return this.bufPtr;
    }
}

