/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.logging;

import com.qizx.util.logging.LogFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class DailyRollingFileHandler
extends StreamHandler {
    private static long PERIOD = 86400000L;
    private SimpleDateFormat datePattern = new SimpleDateFormat("-yyyy-MM-dd");
    protected String pathPattern;
    protected long currentDay;

    public DailyRollingFileHandler(String string) {
        this.pathPattern = string;
        this.setFormatter(new LogFormatter());
    }

    public void publish(LogRecord logRecord) {
        long l = logRecord.getMillis();
        long l2 = this.getDay(l);
        if (l2 != this.currentDay) {
            try {
                this.startFile(l);
            }
            catch (Exception exception) {
                System.err.println("*** Logger: " + exception);
            }
            this.currentDay = l2;
        }
        super.publish(logRecord);
        this.flush();
    }

    private void startFile(long l) throws SecurityException, FileNotFoundException {
        File file = new File(this.pathPattern);
        if (file.exists()) {
            long l2 = file.lastModified();
            int n = this.getDay(l2);
            if (this.getDay(l) != n) {
                this.rollTo(n);
            }
        }
        this.setOutputStream(new FileOutputStream(file, true));
    }

    private void rollTo(int n) {
        File file = new File(this.pathPattern);
        File file2 = new File(this.fileName((long)n * PERIOD));
        file.renameTo(file2);
    }

    private String fileName(long l) {
        return this.pathPattern + this.datePattern.format(new Date(l));
    }

    private int getDay(long l) {
        return (int)(l / PERIOD);
    }
}

