/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.util.basic.FileUtil;
import com.qizx.xdm.DocumentParser;
import com.qizx.xdm.FONIDataModel;
import java.io.File;
import java.util.ArrayList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentPool
extends DocumentParser {
    private static final int MIN_CACHE_SIZE = 131072;
    private static final String CACHE_SIZE_PROP = "com.qizx.docpool.maxsize";
    private long cacheSize = 0xC00000L;
    protected ArrayList<FONIDataModel> cache = new ArrayList();
    private ArrayList timeCache = new ArrayList();

    public DocumentPool() {
        this.initSize();
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public synchronized void setCacheSize(long l) {
        this.cacheSize = Math.max(l, 131072L);
    }

    private void initSize() {
        String string = System.getProperty(CACHE_SIZE_PROP);
        if (string != null) {
            try {
                this.setCacheSize(Integer.parseInt(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void clearCache() {
        this.cache = new ArrayList();
        this.timeCache = new ArrayList();
    }

    public Node findDocumentNode(String string) throws DataModelException {
        FONIDataModel fONIDataModel = this.findDocument(string);
        return fONIDataModel.getDocumentNode();
    }

    public FONIDataModel findDocument(String string) throws DataModelException {
        try {
            FONIDataModel fONIDataModel = this.getCachedDocument(string);
            if (fONIDataModel != null) {
                return fONIDataModel;
            }
            fONIDataModel = new FONIDataModel(this.parseDocument(new InputSource(string)));
            this.cacheDocument(fONIDataModel, this.getFileDate(string));
            return fONIDataModel;
        }
        catch (SAXException sAXException) {
            throw new DataModelException("XML parsing error in " + string + ": " + sAXException.getMessage(), sAXException.getException());
        }
        catch (Exception exception) {
            throw new DataModelException("Document access error in " + string + ": " + exception.getMessage(), exception);
        }
    }

    protected synchronized FONIDataModel getCachedDocument(String string) {
        for (int i = 0; i < this.cache.size(); ++i) {
            FONIDataModel fONIDataModel = this.cache.get(i);
            try {
                String string2 = fONIDataModel.getDom().getBaseURI();
                if (!string.equals(string2)) continue;
                this.cache.remove(i);
                Long l = (Long)this.timeCache.remove(i);
                Long l2 = this.getFileDate(string2);
                if (l2 != null && l != null && l2 > l) {
                    return null;
                }
                this.cache.add(0, fONIDataModel);
                this.timeCache.add(0, l);
                return fONIDataModel;
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
        }
        return null;
    }

    private Long getFileDate(String string) {
        if (!string.startsWith("file:")) {
            return null;
        }
        File file = FileUtil.urlToFile(string);
        if (file == null) {
            return null;
        }
        return new Long(file.lastModified());
    }

    protected synchronized void cacheDocument(FONIDataModel fONIDataModel, Long l) throws DataModelException {
        int n = this.cache.indexOf(fONIDataModel);
        if (n > 0) {
            this.cache.remove(n);
            this.timeCache.remove(n);
        }
        this.cache.add(0, fONIDataModel);
        this.timeCache.add(0, l);
        int n2 = fONIDataModel.getDom().estimateMemorySize();
        int n3 = this.cache.size();
        for (int i = 1; i < n3; ++i) {
            FONIDataModel fONIDataModel2 = this.cache.get(i);
            int n4 = fONIDataModel2.getDom().estimateMemorySize();
            if ((long)(n2 += n4) <= this.cacheSize) continue;
            while (i < this.cache.size()) {
                this.cache.remove(i);
                ++i;
            }
            this.cache.trimToSize();
            break;
        }
    }
}

