/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.XQName;
import java.io.Serializable;
import java.util.HashMap;

public final class IQName
implements QName,
Serializable {
    public static final IQName XML_LANG;
    public static final IQName XML_SPACE;
    public static final IQName XML_BASE;
    public static final IQName XML_ID;
    public static final IQName XSI_TYPE;
    public static final IQName XSI_NIL;
    public static final IQName XSI_SCHEMA_LOCATION;
    public static final IQName XSI_NO_NAMESPACE_SCHEMA_LOCATION;
    private static final QName LEX_ERR;
    public static final String NULL_NS = "";
    private static HashMap names;
    private static IQName probe;
    private String namespace;
    private String localName;

    public static synchronized IQName get(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("null namespace");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null localName");
        }
        IQName.probe.namespace = string;
        IQName.probe.localName = string2;
        IQName iQName = (IQName)names.get(probe);
        if (iQName == null) {
            iQName = new IQName(string, string2);
            names.put(iQName, iQName);
        }
        return iQName;
    }

    public static synchronized IQName get(String string) {
        return IQName.get(NULL_NS, string);
    }

    public static IQName get(QName qName) {
        if (qName == null) {
            return null;
        }
        if (qName instanceof IQName) {
            return (IQName)qName;
        }
        if (qName instanceof XQName) {
            return ((XQName)qName).getIQName();
        }
        return IQName.get(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            return this.namespace.equals(qName.getNamespaceURI()) && this.localName.equals(qName.getLocalPart());
        }
        return false;
    }

    public int hashCode() {
        return this.namespace.hashCode() ^ this.localName.hashCode();
    }

    private IQName(String string, String string2) {
        this.namespace = NamespaceContext.unique(string);
        this.localName = NamespaceContext.unique(string2);
    }

    Object readResolve() {
        return IQName.get(this.namespace, this.localName);
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public boolean hasNoNamespace() {
        return this.namespace.length() == 0;
    }

    public String getLocalPart() {
        return this.localName;
    }

    public String toString() {
        if (this.namespace == NamespaceContext.EMPTY) {
            return this.localName;
        }
        return '{' + this.namespace + '}' + this.localName;
    }

    public int compareTo(IQName iQName) {
        if (this.namespace == iQName.namespace) {
            return this.localName.compareTo(iQName.localName);
        }
        return this.namespace.compareTo(iQName.namespace);
    }

    public String getPrefix() {
        return null;
    }

    public static String extractPrefix(String string) throws DataModelException {
        String string2;
        int n = string.indexOf(58);
        if (n == 0) {
            throw new DataModelException(LEX_ERR, "illegal QName syntax " + string);
        }
        String string3 = string2 = n < 0 ? NULL_NS : string.substring(0, n);
        if (string2.length() > 0 && !XMLUtil.isNCName(string2)) {
            throw new DataModelException(LEX_ERR, "illegal prefix " + string2);
        }
        return string2;
    }

    public static String extractLocalName(String string) throws DataModelException {
        int n = string.indexOf(58);
        if (n == 0) {
            throw new DataModelException(LEX_ERR, "invalid QName syntax " + string);
        }
        String string2 = string.substring(n + 1);
        if (!XMLUtil.isNCName(string2)) {
            throw new DataModelException(LEX_ERR, "invalid local name " + string2);
        }
        return string2;
    }

    static {
        names = new HashMap();
        probe = new IQName(NULL_NS, NULL_NS);
        XML_ID = IQName.get(NamespaceContext.XML, "id");
        XML_LANG = IQName.get(NamespaceContext.XML, "lang");
        XML_SPACE = IQName.get(NamespaceContext.XML, "space");
        XML_BASE = IQName.get(NamespaceContext.XML, "base");
        XSI_TYPE = IQName.get(NamespaceContext.XSI, "type");
        XSI_NIL = IQName.get(NamespaceContext.XSI, "nil");
        XSI_SCHEMA_LOCATION = IQName.get(NamespaceContext.XSI, "schemaLocation");
        XSI_NO_NAMESPACE_SCHEMA_LOCATION = IQName.get(NamespaceContext.XSI, "noNamespaceSchemaLocation");
        LEX_ERR = IQName.get(NamespaceContext.ERR, "FOCA0002");
    }
}

