/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.QName;
import com.qizx.util.QNameTable;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.DataConversion;
import com.qizx.xdm.FONIDocument;
import com.qizx.xdm.IDocument;
import com.qizx.xdm.IQName;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IXDocument
extends IDocument
implements FONIDocument {
    private QNameTable elementNames = new QNameTable();
    private QNameTable otherNames = new QNameTable();
    private ArrayList<String> prefixMapping;
    private ArrayList<ArrayList<String>> namespaceStack = new ArrayList();
    private int xml_id;
    private int[][] blocks;
    private int blockCnt;
    private int docSize;
    private int curNode;
    private int prevNode = 0;
    private int charCnt;
    private int charChunks;
    private int textChunks;
    private char[] charBuffer = new char[2048];
    private int charPtr;
    private boolean textIsWhite;
    private char[][] charBlocks;
    private int lastCharBlock;
    private int charBlockPtr;
    private byte[][] char1Blocks;
    private int lastChar1Block;
    private int char1BlockPtr;
    private ArrayList<String> bigStrings = new ArrayList();
    private boolean exported;
    private boolean trace = false;
    private boolean stats = true;
    private HashMap<String, int[]> idTable;
    private HashMap<String, int[]> idrefTable;
    private FONIDocument.Owner owner;

    public static void main(String[] stringArray) {
        int[] nArray = new int[0x400000];
        int[][] nArrayArray = new int[2048][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = new int[2048];
        }
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 1000;
        while (--n2 >= 0) {
            int n3 = 0x400000;
            while (--n3 >= 0) {
                n += nArray[n3];
            }
        }
        System.err.println("time " + (System.currentTimeMillis() - l));
    }

    public IXDocument() {
        this.blocks = new int[8][];
        this.blocks[0] = new int[512];
        this.blockCnt = 1;
        this.charBlocks = new char[8][];
        this.charBlocks[0] = new char[4096];
        this.lastCharBlock = 0;
        this.charBlockPtr = 1;
        this.char1Blocks = new byte[8][];
        this.char1Blocks[0] = new byte[4096];
        this.lastChar1Block = 0;
        this.char1BlockPtr = 1;
        this.docSize = 3;
        this.openNode(1);
        this.curNode = 3;
        this.xml_id = this.otherNames.enter(IQName.XML_ID);
    }

    public String[] getDTDInfo() {
        if (this.dtdName == null && this.dtdSystemid == null && this.dtdPublicId == null) {
            return null;
        }
        return new String[]{this.dtdName, this.dtdSystemid, this.dtdPublicId};
    }

    public int getRootNode() {
        return 3;
    }

    public int getKind(int n) {
        return this.dataAt(n) & 7;
    }

    public IQName getName(int n) {
        switch (this.getKind(n)) {
            case 2: {
                return this.elementNames.getName(this.getNameId(n));
            }
            case 5: {
                return this.otherNames.getName(this.getNameId(n));
            }
        }
        return null;
    }

    public int getNameId(int n) {
        return this.intDataAt(n) >> 4 & 0xFFF;
    }

    public IQName pnGetName(int n) {
        return this.otherNames.getName(this.pnGetNameId(n));
    }

    public int pnGetNameId(int n) {
        return this.intDataAt(n) >> 4 & 0xFFF;
    }

    public int getParent(int n) {
        return this.dataAt(n + 1);
    }

    public int getNextSibling(int n) {
        return this.dataAt(n + 2);
    }

    public int getNodeNext(int n) {
        int n2 = this.getFirstChild(n);
        return n2 != 0 ? n2 : this.getNodeAfter(n);
    }

    public int getNodeAfter(int n) {
        int n2;
        while ((n2 = this.getNextSibling(n)) == 0) {
            int n3 = this.getParent(n);
            if (n3 == 0) {
                return 0;
            }
            n = n3;
        }
        return n2;
    }

    public int getNodeSpan(int n) {
        int n2 = this.getNodeAfter(n);
        if (n2 == 0) {
            n2 = this.docSize;
        }
        return n2 - n;
    }

    public int getFirstChild(int n) {
        int n2 = this.intDataAt(n);
        int n3 = n2 & 7;
        if (n3 != 2 && n3 != 1 || (n2 & 8) == 0) {
            return 0;
        }
        int n4 = n + 3 + 2 * (this.hAttrCount(n2) + this.hNamespaceCount(n2));
        return n4;
    }

    public String getStringValue(int n) {
        switch (this.getKind(n)) {
            case 1: 
            case 2: {
                StringBuffer stringBuffer = new StringBuffer(this.getNodeSpan(n));
                int n2 = this.getFirstChild(n);
                while (n2 != 0) {
                    this.recStringValue(n2, stringBuffer);
                    n2 = this.getNextSibling(n2);
                }
                return stringBuffer.toString();
            }
            case 3: 
            case 4: {
                return this.decodeString(this.intDataAt(n + 1));
            }
        }
        return this.decodeString(this.intDataAt(n + 3));
    }

    void recStringValue(int n, StringBuffer stringBuffer) {
        switch (this.getKind(n)) {
            case 1: 
            case 2: {
                int n2 = this.getFirstChild(n);
                while (n2 != 0) {
                    this.recStringValue(n2, stringBuffer);
                    n2 = this.getNextSibling(n2);
                }
                break;
            }
            case 7: {
                this.decodeString(this.intDataAt(n + 3), stringBuffer);
            }
        }
    }

    public int getAttrCount(int n) {
        return this.hAttrCount(this.intDataAt(n));
    }

    public int getAttribute(int n, int n2) {
        int n3 = n + 3 + 2 * this.getNamespaceCount(n);
        int n4 = this.getAttrCount(n);
        if (n2 < 0 && n4 > 0) {
            return n3;
        }
        while (n4 > 0) {
            if (this.getNameId(n3) == n2) {
                return n3;
            }
            --n4;
            n3 += 2;
        }
        return 0;
    }

    public int pnGetNext(int n) {
        if (n == 0) {
            return 0;
        }
        return (this.dataAt(n) & 8) != 0 ? 0 : n + 2;
    }

    public String pnGetStringValue(int n) {
        return this.decodeString(this.intDataAt(n + 1));
    }

    public char[] getCharValue(int n, int n2) {
        switch (this.getKind(n)) {
            case 1: 
            case 2: {
                throw new RuntimeException("not allowed on non-atoms");
            }
            case 3: 
            case 4: {
                return this.decodeChars(this.intDataAt(n + 1), n2);
            }
        }
        return this.decodeChars(this.intDataAt(n + 3), n2);
    }

    public char[] pnGetCharValue(int n, int n2) {
        return this.decodeChars(this.intDataAt(n + 1), n2);
    }

    public int getDefinedNSCount(int n) {
        return this.getNamespaceCount(n);
    }

    public int getFirstNSNode(int n) {
        if (n == 0 || this.getNamespaceCount(n) == 0) {
            return 0;
        }
        return n + 3;
    }

    public Object getValue(int n) {
        return null;
    }

    public long getIntegerValue(int n) {
        return -1L;
    }

    public int getElementNameCount() {
        return this.elementNames.size();
    }

    public IQName getElementName(int n) {
        return this.elementNames.getName(n);
    }

    public int internElementName(QName qName) {
        return this.elementNames.find(qName);
    }

    public int getOtherNameCount() {
        return this.otherNames.size();
    }

    public IQName getOtherName(int n) {
        return this.otherNames.getName(n);
    }

    public int internOtherName(QName qName) {
        return this.otherNames.find(qName);
    }

    public void close() throws IOException, SAXException {
    }

    public void endDocument() throws SAXException {
        if (this.stats) {
            this.estimateMemorySize();
            System.err.println("doc size " + this.docSize + " chars " + this.charCnt + " chunks " + this.charChunks + "/" + this.textChunks);
            for (int i = 0; i < this.char1BlockPtr && i < 20; ++i) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream("bloke" + i);
                    fileOutputStream.write(this.char1Blocks[i]);
                    fileOutputStream.close();
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("OOPS " + iOException);
                }
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        int n2;
        int n3;
        this.endText();
        int n4 = this.openNode(2);
        if (string2 == null || string2.length() == 0) {
            string = "";
            string2 = string3;
        }
        int n5 = this.elementNames.enter(string, string2);
        int n6 = attributes == null ? 0 : attributes.getLength();
        int n7 = 0;
        int n8 = n4 + 3;
        if (this.prefixMapping != null) {
            n7 = this.prefixMapping.size();
            for (n3 = 0; n3 < n7; n3 += 2) {
                n2 = this.otherNames.enter("", this.prefixMapping.get(n3));
                n = n3 == n7 - 2 ? 8 : 0;
                this.setData(n8++, 4 + (n2 << 4) + n);
                this.setData(n8++, this.storeString(this.prefixMapping.get(n3 + 1)));
            }
            this.namespaceStack.add(this.prefixMapping);
            this.prefixMapping = null;
        }
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = this.otherNames.enter(attributes.getURI(n3), attributes.getLocalName(n3));
            n = n3 == n6 - 1 ? 8 : 0;
            this.setData(n8++, 3 + (n2 << 4) + n);
            String string4 = attributes.getValue(n3);
            this.setData(n8++, this.storeString(string4));
            String string5 = attributes.getType(n3);
            if (n2 == this.xml_id) {
                this.addId(string4, n4);
                continue;
            }
            if (string5.length() < 2 || string5.charAt(0) != 'I' || string5.charAt(1) != 'D') continue;
            if (string5.length() == 2) {
                this.addId(string4, n4);
                continue;
            }
            this.addIdrefs(string4, n4, n3);
        }
        this.docSize = n8;
        this.setData(n4, 2 + (n5 << 4) + (n6 << 16) + (n7 / 2 << 25));
        if (this.trace) {
            System.err.println("elem " + n4 + " nameId=" + n5 + " attrCnt=" + n6 + " nsCnt=" + n7);
        }
    }

    private void addIdrefs(String string, int n, int n2) {
        String[] stringArray = XMLUtil.splitList(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addIdref(stringArray[i], n, n2);
        }
    }

    private void addIdref(String string, int n, int n2) {
        int[] nArray;
        if (this.idrefTable == null) {
            this.idrefTable = new HashMap();
        }
        if ((nArray = this.idrefTable.get(string)) == null) {
            this.idrefTable.put(string, new int[]{n, n2});
        } else {
            int n3 = nArray.length;
            int[] nArray2 = new int[n3 + 2];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            nArray2[n3] = n;
            nArray2[n3 + 1] = n2;
            this.idrefTable.put(string, nArray2);
        }
    }

    private void addId(String string, int n) {
        int[] nArray;
        if (this.idTable == null) {
            this.idTable = new HashMap();
        }
        if ((nArray = this.idTable.get(string)) == null) {
            this.idTable.put(string, new int[]{n});
        }
    }

    public int[] getIdMatchingNodes(String string, boolean bl) {
        HashMap<String, int[]> hashMap = bl ? this.idrefTable : this.idTable;
        return hashMap.get(string);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.endText();
        this.closeNode();
    }

    public void characters(char[] cArray, int n, int n2) {
        int n3 = this.charPtr + n2;
        if (n3 > this.charBuffer.length) {
            char[] cArray2 = this.charBuffer;
            this.charBuffer = new char[n3 + 1000];
            System.arraycopy(cArray2, 0, this.charBuffer, 0, this.charPtr);
        }
        if (!this.whitespaceStripped) {
            System.arraycopy(cArray, n, this.charBuffer, this.charPtr, n2);
        } else {
            int n4 = n2;
            while (--n4 >= 0) {
                char c = cArray[n + n4];
                if (c > ' ' || !Character.isWhitespace(c)) {
                    this.textIsWhite = false;
                }
                this.charBuffer[this.charPtr + n4] = c;
            }
        }
        this.charPtr = n3;
        ++this.charChunks;
        this.charCnt += n2;
    }

    public void characters(String string) {
        this.characters(string.toCharArray(), 0, string.length());
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.endText();
        int n = this.openNode(5);
        int n2 = this.otherNames.enter("", string);
        this.setData(n, this.dataAt(n) + (n2 << 4));
        this.setData(this.docSize++, this.storeString(string2));
        this.closeNode();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.prefixMapping == null) {
            this.prefixMapping = new ArrayList();
        }
        this.prefixMapping.add(string);
        this.prefixMapping.add(string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) {
        if (!this.takeComment) {
            return;
        }
        this.endText();
        this.openNode(6);
        this.setData(this.docSize++, this.storeString(new String(cArray, n, n2)));
        this.closeNode();
    }

    public int getCurrentNode() {
        return this.curNode;
    }

    private int openNode(int n) {
        int n2 = this.docSize;
        if (this.trace) {
            System.err.println("open node " + n2 + " impl=" + n);
        }
        this.docSize += 3;
        if (this.prevNode != 0) {
            this.setData(this.prevNode + 2, n2);
        }
        this.setData(n2, n);
        this.setData(n2 + 1, this.curNode);
        this.setData(n2 + 2, 0);
        this.curNode = n2;
        this.prevNode = 0;
        return this.curNode;
    }

    private void closeNode() {
        this.prevNode = this.curNode;
        this.curNode = this.getParent(this.curNode);
        if (this.curNode != 0) {
            this.setFlag(this.curNode, 8);
        }
    }

    private void endText() {
        if (!(this.charPtr <= 0 || this.whitespaceStripped && this.textIsWhite)) {
            ++this.textChunks;
            this.openNode(7);
            this.setData(this.docSize++, this.storeString());
            this.closeNode();
        }
        this.charPtr = 0;
        this.textIsWhite = true;
    }

    private void setFlag(int n, int n2) {
        this.setData(n, this.dataAt(n) | n2);
    }

    private void checkDump(int n, int n2, int n3) {
        int n4;
        System.out.print(n);
        for (n4 = 0; n4 < n3; ++n4) {
            System.out.print("  ");
        }
        ++n3;
        switch (this.getKind(n)) {
            case 1: 
            case 2: {
                System.out.println("ELEMENT " + this.getName(n));
                n4 = this.getFirstNSNode(n);
                while (n4 != 0) {
                    this.checkDump(n4, n, n3);
                    n4 = this.pnGetNext(n4);
                }
                int n5 = this.getAttribute(n, -1);
                while (n5 != 0) {
                    this.checkDump(n5, n, n3);
                    n5 = this.pnGetNext(n5);
                }
                int n6 = this.getFirstChild(n);
                while (n6 != 0) {
                    this.checkDump(n6, n, n3);
                    n6 = this.getNextSibling(n6);
                }
                break;
            }
            case 3: {
                System.out.println("  ATTR " + this.pnGetName(n) + " |" + this.pnGetStringValue(n) + "|");
                break;
            }
            case 4: {
                System.out.println("  NS " + this.pnGetName(n) + " |" + this.pnGetStringValue(n) + "|");
                break;
            }
            case 7: {
                System.out.println("TEXT |" + this.getStringValue(n) + "|");
                break;
            }
            case 6: {
                System.out.println("COMMENT |" + this.getStringValue(n) + "|");
                break;
            }
            case 5: {
                System.out.println("PI |" + this.getStringValue(n) + "|");
                break;
            }
            default: {
                System.err.println("*** bad node id=" + n + " kind=" + this.getKind(n));
            }
        }
    }

    public boolean isExported() {
        boolean bl = this.exported;
        this.exported = true;
        return bl;
    }

    public int estimateMemorySize() {
        int n = this.blockCnt * 512 * 4;
        int n2 = this.lastCharBlock * 4096 * 2;
        int n3 = this.lastChar1Block * 4096;
        int n4 = this.bigStrings.size() * 4096;
        if (this.stats) {
            System.err.println("sizes nodes=" + n + " chars=" + n2 + " chars1=" + n3 + " bigst=" + n4);
        }
        return n + n2 + n4;
    }

    public int virtualSize() {
        return this.estimateMemorySize();
    }

    private final int dataAt(int n) {
        return this.blocks[n >> 9][n & 0x1FF];
    }

    private final int intDataAt(int n) {
        return this.dataAt(n);
    }

    private void setData(int n, int n2) {
        int n3 = n >> 9;
        int n4 = n & 0x1FF;
        if (n3 >= this.blockCnt) {
            if (this.blockCnt >= this.blocks.length) {
                int[][] nArray = this.blocks;
                this.blocks = new int[nArray.length + 64][];
                System.arraycopy(nArray, 0, this.blocks, 0, nArray.length);
            }
            this.blocks[this.blockCnt++] = new int[512];
        }
        this.blocks[n3][n4] = n2;
    }

    private int getNamespaceCount(int n) {
        return this.hNamespaceCount(this.dataAt(n));
    }

    private final int hNamespaceCount(int n) {
        return n >> 25;
    }

    private final int hAttrCount(int n) {
        return n >> 16 & 0x1FF;
    }

    private int storeString(String string) {
        int n = string.length();
        if (n > this.charBuffer.length) {
            return this.storeBigString(string);
        }
        string.getChars(0, n, this.charBuffer, 0);
        this.charPtr = n;
        int n2 = this.storeString();
        this.charPtr = 0;
        return n2;
    }

    private int storeString() {
        int n;
        if (this.charPtr > 2048) {
            return this.storeBigString(new String(this.charBuffer, 0, this.charPtr));
        }
        boolean bl = false;
        int n2 = this.charBuffer[0] >>> 8;
        for (n = 0; n < this.charPtr; ++n) {
            if (this.charBuffer[n] >>> 8 == n2) continue;
            bl = true;
            break;
        }
        if (bl) {
            System.err.println("wide char block size " + this.charPtr);
            n = this.charPtr + 1;
            if (this.charBlockPtr + n > 4096) {
                if (++this.lastCharBlock >= this.charBlocks.length) {
                    char[][] cArray = this.charBlocks;
                    this.charBlocks = new char[cArray.length + 100][];
                    System.arraycopy(cArray, 0, this.charBlocks, 0, cArray.length);
                }
                this.charBlocks[this.lastCharBlock] = new char[4096];
                this.charBlockPtr = 0;
            }
            int n3 = this.lastCharBlock * 4096 + this.charBlockPtr;
            char[] cArray = this.charBlocks[this.lastCharBlock];
            cArray[this.charBlockPtr] = (char)this.charPtr;
            System.arraycopy(this.charBuffer, 0, cArray, this.charBlockPtr + 1, this.charPtr);
            this.charBlockPtr += n;
            return n3 << 1;
        }
        n = this.charPtr + 2;
        if (this.char1BlockPtr + n > 4096) {
            if (++this.lastChar1Block >= this.char1Blocks.length) {
                byte[][] byArray = this.char1Blocks;
                this.char1Blocks = new byte[byArray.length + 100][];
                System.arraycopy(byArray, 0, this.char1Blocks, 0, byArray.length);
            }
            this.char1Blocks[this.lastChar1Block] = new byte[4096];
            this.char1BlockPtr = 0;
        }
        int n4 = this.lastChar1Block * 4096 + this.char1BlockPtr;
        byte[] byArray = this.char1Blocks[this.lastChar1Block];
        byArray[this.char1BlockPtr] = (byte)this.charPtr;
        byArray[this.char1BlockPtr + 1] = (byte)n2;
        for (int i = 0; i < this.charPtr; ++i) {
            byArray[this.char1BlockPtr + 2 + i] = (byte)this.charBuffer[i];
        }
        this.char1BlockPtr += n;
        return n4 << 1;
    }

    private int storeBigString(String string) {
        int n = this.bigStrings.size();
        this.bigStrings.add(string);
        return (n << 1) + 1;
    }

    private String decodeString(int n) {
        if ((n & 1) != 0) {
            return this.bigStrings.get(n >> 1);
        }
        char[] cArray = this.charBlocks[(n >>= 1) >> 12];
        int n2 = n & 0xFFF;
        return new String(cArray, n2 + 1, (int)cArray[n2]);
    }

    private void decodeString(int n, StringBuffer stringBuffer) {
        if ((n & 1) != 0) {
            stringBuffer.append(this.bigStrings.get(n >> 1));
        } else {
            char[] cArray = this.charBlocks[(n >>= 1) >> 12];
            int n2 = n & 0xFFF;
            stringBuffer.append(cArray, n2 + 1, (int)cArray[n2]);
        }
    }

    private char[] decodeChars(int n, int n2) {
        if ((n & 1) != 0) {
            String string = this.bigStrings.get(n >> 1);
            char[] cArray = new char[string.length() + n2];
            string.getChars(0, string.length(), cArray, n2);
            return cArray;
        }
        char[] cArray = this.charBlocks[(n >>= 1) >> 12];
        int n3 = n & 0xFFF;
        char c = cArray[n3];
        char[] cArray2 = new char[c + n2];
        System.arraycopy(cArray, n3 + 1, cArray2, n2, c);
        return cArray2;
    }

    public FONIDocument.Owner getOwner() {
        return this.owner;
    }

    public void setOwner(FONIDocument.Owner owner) {
        this.owner = owner;
    }

    public DataConversion getDataConversion() {
        return null;
    }
}

