/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.XMLPushStream;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Check;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.AttributeList;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xdm.FONIDocument;
import com.qizx.xdm.IQName;

public abstract class XMLPushStreamBase
extends AttributeList
implements XMLPushStream {
    protected static final String VOLUME_LIMIT = "volume limit reached";
    protected static final int NSCOPY_SIMPLY = 0;
    protected String baseURI;
    protected String dtdName = null;
    protected String dtdPublicId = null;
    protected String dtdSystemId = null;
    protected String dtdInternalSubset;
    protected IQName elementName;
    protected NamespaceContext contextualMappings;
    protected NamespaceContext localNS;
    protected boolean elementStarted;
    protected boolean spaceNeeded;
    protected boolean docStarted;
    protected boolean startDocumentDone;
    protected boolean endDocumentDone;
    protected boolean trace = false;
    protected long maxVolume = -1L;
    protected long volume = 0L;
    private boolean noLocalPutNS;

    public void putDTD(String string, String string2, String string3, String string4) throws DataModelException {
        if (string != null) {
            this.dtdName = string;
        }
        if (string2 != null) {
            this.dtdPublicId = string2;
        }
        if (string3 != null) {
            this.dtdSystemId = string3;
        }
        if (string4 != null) {
            this.dtdInternalSubset = string4;
        }
    }

    public boolean putDocumentStart() throws DataModelException {
        if (this.attrNames == null) {
            this.reset();
        }
        this.spaceNeeded = false;
        if (this.startDocumentDone || this.elementStarted) {
            return false;
        }
        this.startDocumentDone = true;
        return true;
    }

    public void putDocumentEnd() throws DataModelException {
        if (this.endDocumentDone) {
            return;
        }
        this.endDocumentDone = true;
        this.spaceNeeded = false;
        this.flush();
    }

    public void putElementStart(QName qName) throws DataModelException {
        if (!this.startDocumentDone) {
            this.putDocumentStart();
            this.startDocumentDone = true;
        }
        if (this.trace) {
            System.err.println("--- start elem " + qName);
        }
        this.docStarted = true;
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
        this.attrCnt = 0;
        if (qName == null) {
            System.err.println("XMLPushStreamBase.putElementStart : OOPS");
        }
        this.elementName = IQName.get(qName);
        this.elementStarted = true;
        this.spaceNeeded = false;
        this.nsContext.newLevel();
        if (this.localNS != null) {
            this.localNS.clear();
            if (qName.getPrefix() != null) {
                this.localNS.addMapping(qName.getPrefix(), qName.getNamespaceURI());
            }
        }
    }

    public void putElementEnd(QName qName) throws DataModelException {
        if (this.trace) {
            System.err.println("--- end elem " + qName);
        }
        this.nsContext.popLevel();
        this.spaceNeeded = false;
    }

    public boolean putNamespace(String string, String string2) throws DataModelException {
        Check.nonNull(string, "prefix");
        Check.nonNull(string2, "namespaceURI");
        if (this.trace) {
            System.err.println("--- namespace " + string + " = " + string2);
        }
        boolean bl = false;
        if (!this.noLocalPutNS) {
            String string3 = this.nsContext.getNamespaceURI(string);
            if (string3 == null) {
                if (string.length() != 0 || string2.length() != 0) {
                    bl = true;
                }
            } else if (!string2.equals(this.nsContext.getNamespaceURI(string))) {
                bl = true;
            }
            if (bl) {
                this.nsContext.addMapping(string, string2);
            }
        }
        if (this.localNS != null) {
            this.checkNSClash(string, string2);
        }
        if (!this.elementStarted) {
            this.putText("xmlns:" + string + " = " + string2);
        }
        return bl;
    }

    public void noSpace() {
        this.spaceNeeded = false;
    }

    public void putChars(char[] cArray, int n, int n2) throws DataModelException {
        this.putText(new String(cArray, n, n2));
    }

    public void putAtomText(String string) throws DataModelException {
        if (this.spaceNeeded) {
            this.putText(" ");
        }
        this.putText(string);
        this.spaceNeeded = true;
    }

    public void putLongAtom(long l) throws DataModelException {
        throw new DataModelException("unimplemented operation");
    }

    public void putAtom(Object object) throws DataModelException {
        throw new DataModelException("unimplemented operation");
    }

    public void putAttribute(QName qName, String string, String string2) throws DataModelException {
        Check.nonNull(qName, "name");
        Check.nonNull(string, "value");
        if (this.trace) {
            System.err.println("--- attribute " + qName + " = " + string);
        }
        if (qName == IQName.XML_ID) {
            string = XMLUtil.collapseWhiteSpace(string);
        }
        if (!this.elementStarted) {
            this.putText(qName + " = " + string);
            return;
        }
        if (this.localNS != null && qName.getPrefix() != null) {
            this.checkNSClash(qName.getPrefix(), qName.getNamespaceURI());
        }
        if (!this.addAttribute(qName, string, string2)) {
            throw new DataModelException("Duplicate attribute " + qName);
        }
    }

    public void putProcessingInstruction(String string, String string2) throws DataModelException {
        this.checkPIValue(string2);
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
    }

    public void putComment(String string) throws DataModelException {
        this.checkCommentValue(string);
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
    }

    protected abstract void flushElementStart(boolean var1) throws DataModelException;

    public void setCheckNS(boolean bl) {
        this.localNS = bl ? new NamespaceContext() : null;
    }

    private void checkNSClash(String string, String string2) throws DataModelException {
        String string3 = this.localNS.getNamespaceURI(string);
        if (string3 == null) {
            this.localNS.addMapping(string, string2);
        } else if (!string3.equals(string2)) {
            throw new DataModelException("XUDY0024", "incompatible NS prefix " + string);
        }
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setMaxVolume(int n) {
        this.maxVolume = n;
    }

    public boolean maxVolumeReached() {
        return this.volume >= this.maxVolume;
    }

    public void reset() {
        this.docStarted = false;
        this.elementStarted = false;
        this.endDocumentDone = false;
        this.startDocumentDone = false;
        this.spaceNeeded = false;
        this.attrCnt = 0;
        this.nsContext = new NamespaceContext();
        this.attrNames = new IQName[8];
        this.attrValues = new String[this.attrNames.length];
        this.attrTypes = new String[this.attrNames.length];
    }

    public boolean isAtRoot() {
        return !this.startDocumentDone;
    }

    public void flush() throws DataModelException {
        if (!this.endDocumentDone) {
            this.putDocumentEnd();
        }
    }

    public void abort() throws DataModelException {
    }

    public void defineContextMappings(NamespaceContext namespaceContext) {
        this.contextualMappings = namespaceContext;
    }

    protected void completeNameMappings() throws DataModelException {
        this.checkNameMapping(this.elementName, true);
        for (int i = 0; i < this.attrCnt; ++i) {
            this.checkNameMapping(this.attrNames[i], false);
        }
    }

    protected void checkNameMapping(IQName iQName, boolean bl) throws DataModelException {
        String string = iQName.getNamespaceURI();
        String string2 = this.nsContext.getPrefix(string);
        if (string2 != null || string == NamespaceContext.EMPTY || string == NamespaceContext.XML) {
            return;
        }
        if (this.contextualMappings != null) {
            string2 = this.contextualMappings.getPrefix(string);
        }
        if (string2 == null) {
            string2 = "";
            if (!bl || this.nsContext.getNamespaceURI(string2) != null) {
                int n = 1;
                while (this.nsContext.getNamespaceURI(string2 = "ns" + n) != null) {
                    ++n;
                }
            }
        }
        this.nsContext.addMapping(string2, string);
        this.putNamespace(string2, string);
    }

    public String getNSPrefix(String string) {
        return this.nsContext.getPrefix(string);
    }

    public String getNSURI(String string) {
        String string2 = this.nsContext.getNamespaceURI(string);
        return string2;
    }

    protected void checkPIValue(String string) throws DataModelException {
        if (XMLUtil.normalizePI(string) == null) {
            throw new DataModelException("invalid PI contents");
        }
    }

    protected void checkCommentValue(String string) throws DataModelException {
        if (!XMLUtil.checkComment(string)) {
            throw new DataModelException("invalid comment");
        }
    }

    public void putNodeCopy(Node node, int n) throws DataModelException {
        if (node instanceof FONIDataModel.FONINode && !(node instanceof FONIDataModel.ANode)) {
            FONIDataModel.FONINode fONINode = (FONIDataModel.FONINode)node;
            this.putNodeCopy(fONINode.getNodeId(), fONINode.getDom(), n);
        } else if (node != null) {
            this.recCopyNode(n, node);
        }
    }

    public void putNamespaces(Node node, int n) throws DataModelException {
        BasicNode basicNode = (BasicNode)node;
        switch (n) {
            default: {
                basicNode.addNamespacesTo(this.nsContext);
                break;
            }
            case 1: {
                basicNode.addInScopeNamespacesTo(this.nsContext);
                break;
            }
            case 2: {
                basicNode.addUsedNamespacesTo(this.nsContext);
                break;
            }
            case 3: {
                this.nsContext.hideAllNamespaces();
                basicNode.addInScopeNamespacesTo(this.nsContext);
                break;
            }
            case 4: {
                this.nsContext.hideAllNamespaces();
                basicNode.addUsedNamespacesTo(this.nsContext);
            }
        }
        this.noLocalPutNS = true;
        int n2 = this.nsContext.getLocalSize();
        for (int i = 0; i < n2; ++i) {
            String string = this.nsContext.getLocalNamespaceURI(i);
            if (string == null) {
                string = "";
            }
            this.putNamespace(this.nsContext.getLocalPrefix(i), string);
        }
        this.noLocalPutNS = false;
    }

    private void recCopyNode(int n, Node node) throws DataModelException {
        switch (node.getNodeNature()) {
            case 1: {
                boolean bl = this.putDocumentStart();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.recCopyNode(n, node2);
                }
                if (!bl) break;
                this.putDocumentEnd();
                break;
            }
            case 2: {
                this.putElementStart(node.getNodeName());
                this.putNamespaces(node, n);
                Node[] nodeArray = node.getAttributes();
                if (nodeArray != null) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        this.putAttribute(nodeArray[i].getNodeName(), nodeArray[i].getStringValue(), null);
                    }
                }
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    this.recCopyNode(0, node3);
                }
                this.putElementEnd(node.getNodeName());
                break;
            }
            case 7: {
                this.putText(node.getStringValue());
                break;
            }
            case 5: {
                this.putProcessingInstruction(node.getNodeName().toString(), node.getStringValue());
                break;
            }
            case 6: {
                this.putComment(node.getStringValue());
                break;
            }
            case 3: {
                this.putAttribute(node.getNodeName(), node.getStringValue(), null);
                break;
            }
            case 4: {
                this.putNamespace(node.getNodeName().getLocalPart(), node.getStringValue());
                break;
            }
            default: {
                throw new DataModelException("illegal node kind " + node.getNodeNature() + " " + node);
            }
        }
    }

    public void putNodeCopy(int n, FONIDocument fONIDocument, int n2) throws DataModelException {
        switch (fONIDocument.getKind(n)) {
            case 1: {
                boolean bl = this.putDocumentStart();
                int n3 = fONIDocument.getFirstChild(n);
                while (n3 != 0) {
                    this.putNodeCopy(n3, fONIDocument, n2);
                    n3 = fONIDocument.getNextSibling(n3);
                }
                if (!bl) break;
                this.putDocumentEnd();
                break;
            }
            case 2: {
                int n4;
                IQName iQName = fONIDocument.getName(n);
                this.putElementStart(iQName);
                switch (n2) {
                    default: {
                        FONIDataModel.addNsTo(fONIDocument, n, this.nsContext);
                        break;
                    }
                    case 1: {
                        FONIDataModel.addInscopeNsTo(fONIDocument, n, this.nsContext);
                        break;
                    }
                    case 3: {
                        this.nsContext.hideAllNamespaces();
                        FONIDataModel.addInscopeNsTo(fONIDocument, n, this.nsContext);
                        break;
                    }
                    case 2: {
                        FONIDataModel.addUsedNsTo(fONIDocument, n, this.nsContext);
                        break;
                    }
                    case 4: {
                        this.nsContext.hideAllNamespaces();
                        FONIDataModel.addUsedNsTo(fONIDocument, n, this.nsContext);
                    }
                }
                this.noLocalPutNS = true;
                int n5 = this.nsContext.getLocalSize();
                for (n4 = 0; n4 < n5; ++n4) {
                    String string = this.nsContext.getLocalNamespaceURI(n4);
                    if (string == null) {
                        string = "";
                    }
                    this.putNamespace(this.nsContext.getLocalPrefix(n4), string);
                }
                this.noLocalPutNS = false;
                n4 = fONIDocument.getAttribute(n, -1);
                while (n4 != 0) {
                    this.putAttribute(fONIDocument.pnGetName(n4), fONIDocument.pnGetStringValue(n4), null);
                    n4 = fONIDocument.pnGetNext(n4);
                }
                int n6 = fONIDocument.getFirstChild(n);
                while (n6 != 0) {
                    int n7 = fONIDocument.getNextSibling(n6);
                    this.putNodeCopy(n6, fONIDocument, 0);
                    n6 = n7;
                }
                this.putElementEnd(iQName);
                break;
            }
            case 7: {
                this.putText(fONIDocument.getStringValue(n));
                break;
            }
            case 5: {
                this.putProcessingInstruction(fONIDocument.getName(n).getLocalPart(), fONIDocument.getStringValue(n));
                break;
            }
            case 6: {
                this.putComment(fONIDocument.getStringValue(n));
                break;
            }
            case 3: {
                this.putAttribute(fONIDocument.pnGetName(n), fONIDocument.pnGetStringValue(n), null);
                break;
            }
            case 4: {
                this.putNamespace(fONIDocument.pnGetName(n).getLocalPart(), fONIDocument.pnGetStringValue(n));
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.putAtom(fONIDocument.getValue(n));
                break;
            }
            default: {
                throw new DataModelException("illegal node kind " + fONIDocument.getKind(n));
            }
        }
    }

    public void putNodeText(BasicNode basicNode, int n) throws DataModelException {
        if (basicNode instanceof FONIDataModel.FONINode && !(basicNode instanceof FONIDataModel.ANode)) {
            FONIDataModel.FONINode fONINode = (FONIDataModel.FONINode)basicNode;
            this.recPutNodeText(fONINode.getNodeId(), fONINode.getDom(), n);
        } else {
            this.recPutNodeText(basicNode, n);
        }
    }

    private void recPutNodeText(Node node, int n) throws DataModelException {
        if (--n < 0) {
            return;
        }
        switch (node.getNodeNature()) {
            case 1: 
            case 2: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.recPutNodeText(node2, n);
                }
                break;
            }
            case 7: {
                this.putText(node.getStringValue());
            }
        }
    }

    private void recPutNodeText(int n, FONIDocument fONIDocument, int n2) throws DataModelException {
        if (--n2 < 0) {
            return;
        }
        switch (fONIDocument.getKind(n)) {
            case 1: 
            case 2: {
                int n3 = fONIDocument.getFirstChild(n);
                while (n3 != 0) {
                    int n4 = fONIDocument.getNextSibling(n3);
                    this.recPutNodeText(n3, fONIDocument, n2);
                    n3 = n4;
                }
                break;
            }
            case 7: {
                this.putText(fONIDocument.getStringValue(n));
            }
        }
    }
}

