/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.EvaluationException;
import com.qizx.api.Message;
import com.qizx.api.QName;
import com.qizx.queries.FullText;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Check;
import com.qizx.xdm.IQName;
import com.qizx.xquery.BasicStaticContext;
import com.qizx.xquery.DynamicContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.MainQuery;
import com.qizx.xquery.MessageReceiver;
import com.qizx.xquery.ModuleManager;
import com.qizx.xquery.ResultSequence;
import com.qizx.xquery.SequenceType;
import com.qizx.xquery.XMLExprDisplay;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.fn.UserFunction;
import com.qizx.xquery.impl.ErrorValue;
import com.qizx.xquery.op.DecimalLiteral;
import com.qizx.xquery.op.DoubleLiteral;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.GlobalVariable;
import com.qizx.xquery.op.IntegerLiteral;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.ModuleImport;
import com.qizx.xquery.op.Pragma;
import com.qizx.xquery.op.UpdatingExpr;
import com.qizx.xquery.op.VarReference;
import java.util.ArrayList;
import java.util.HashMap;

public class ModuleContext
extends BasicStaticContext {
    public static final int TY_PRESERVE = 0;
    public static final int SP_PRESERVE = 1;
    public static final int NS_XML11 = 2;
    public static final int NS_COPY = 0;
    public static final int NS_PRES_INHERIT = 1;
    public static final int NS_NOPRES_INHERIT = 2;
    public static final int NS_PRES_NOINHERIT = 3;
    public static final int NS_NOPRES_NOINHERIT = 4;
    protected boolean checked = false;
    protected boolean checking;
    public boolean trace = false;
    protected String physicalURI;
    protected String moduleNS;
    protected String source;
    protected ArrayList importedModules = new ArrayList();
    protected HashMap functionMap = new HashMap();
    protected HashMap importedFunctions = new HashMap();
    protected HashMap importedGlobals = new HashMap();
    private GlobalVariable curInitVar;
    protected FullText.MatchOptions defaultFTOptions;
    protected ArrayList declarations = new ArrayList();
    protected Pragma[] pragmas;
    protected LocalVariable locals;
    protected LocalVariable lastLocal;
    protected int maxLocalSize = 0;
    private int localCnt;
    private int localIntCnt;
    private int localDoubleCnt;
    private int localStringCnt;
    private int localItemCnt;
    protected LocalVars upLevels;
    private Expression[] exprStack = new Expression[40];
    private int exprDepth = 0;
    private DotType dotTypeStack;
    private int genId;
    private String latestErrorCode;
    private MessageReceiver messageTarget;
    private EvalContext cstEvalContext;

    public ModuleContext(BasicStaticContext basicStaticContext) {
        this.defaultFTOptions = new FullText.MatchOptions();
        if (basicStaticContext != null) {
            this.copy(basicStaticContext);
        }
        if (basicStaticContext instanceof ModuleContext) {
            this.importedModules.add(basicStaticContext);
        }
    }

    public void dump(XMLExprDisplay xMLExprDisplay) {
        xMLExprDisplay.header("Module");
        for (int i = 0; i < this.declarations.size(); ++i) {
            xMLExprDisplay.child((Expression)this.declarations.get(i));
        }
        xMLExprDisplay.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void staticCheck(ModuleManager moduleManager) {
        if (this.checked) {
            return;
        }
        this.resetLocals();
        ModuleManager moduleManager2 = moduleManager;
        synchronized (moduleManager2) {
            this.checking = true;
            for (int i = 0; i < this.declarations.size(); ++i) {
                Expression expression;
                Object e = this.declarations.get(i);
                if (e instanceof GlobalVariable) {
                    GlobalVariable globalVariable;
                    expression = (GlobalVariable)e;
                    this.checkImportedGlobal((GlobalVariable)expression, ((GlobalVariable)expression).offset);
                    Expression expression2 = ((GlobalVariable)expression).init;
                    if (expression2 != null) {
                        ((GlobalVariable)expression).init = expression2 = expression2.staticCheck(this, 0);
                        this.allocateLocalAddress(null);
                        if (((GlobalVariable)expression).declaredType == null) {
                            expression.setType(expression2.getType());
                        } else {
                            if (!((GlobalVariable)expression).declaredType.accepts(expression2.getType())) {
                                this.error("XPTY0004", expression2.offset, "incompatible value type " + expression2.getType().toString(this) + " for initial value of variable $" + this.prefixedName(((GlobalVariable)expression).name) + ", " + ((GlobalVariable)expression).declaredType.toString(this) + " required");
                            }
                            expression.setType(((GlobalVariable)expression).declaredType);
                        }
                    } else if (expression.getType() == null) {
                        expression.setType(XQType.ANY);
                    }
                    if (expression2 != null && expression2.isUpdating()) {
                        this.error("XUST0001", expression2, "variable initialization must not be an updating expression");
                    }
                    if ((globalVariable = (GlobalVariable)this.globalMap.get(((GlobalVariable)expression).name)) != null) {
                        this.error("XQST0049", ((GlobalVariable)expression).offset, "global variable " + this.prefixedName(((GlobalVariable)expression).name) + " already defined");
                        continue;
                    }
                    this.globalMap.put(((GlobalVariable)expression).name, expression);
                    continue;
                }
                if (e instanceof UserFunction.Signature) {
                    expression = (UserFunction.Signature)e;
                    ((UserFunction.Signature)expression).staticCheck(this, 0);
                    this.checkImportedFunction((UserFunction.Signature)expression, ((UserFunction.Signature)expression).offset);
                    continue;
                }
                if (!(e instanceof ModuleImport)) continue;
                this.checkModuleImport(moduleManager, (ModuleImport)e);
            }
            this.checking = false;
            this.checked = true;
        }
    }

    private void checkModuleImport(ModuleManager moduleManager, ModuleImport moduleImport) {
        ModuleContext moduleContext = moduleImport.imported;
        if (moduleContext.checking) {
            this.error("XQST0073", moduleImport.offset, "circular import of module " + moduleContext.getPhysicalURI());
            return;
        }
        moduleContext.staticCheck(moduleManager);
        this.importedModules.add(moduleContext);
        for (int i = 0; i < moduleContext.declarations.size(); ++i) {
            Expression expression;
            Object e = moduleContext.declarations.get(i);
            if (e instanceof GlobalVariable) {
                expression = (GlobalVariable)e;
                if (!this.checkImportedGlobal((GlobalVariable)expression, moduleImport.offset)) continue;
                this.importedGlobals.put(expression.name, expression);
                continue;
            }
            if (!(e instanceof UserFunction.Signature) || !this.checkImportedFunction((UserFunction.Signature)(expression = (UserFunction.Signature)e), moduleImport.offset)) continue;
            this.importedFunctions.put(expression, expression);
        }
    }

    private boolean checkImportedGlobal(GlobalVariable globalVariable, int n) {
        GlobalVariable globalVariable2 = this.importedGlobal(globalVariable.name);
        if (globalVariable2 == null) {
            return true;
        }
        this.error("XQST0049", n, "global variable " + this.prefixedName(globalVariable.name) + " already defined in module " + globalVariable2.module.getPhysicalURI());
        return false;
    }

    boolean checkImportedFunction(UserFunction.Signature signature, int n) {
        UserFunction.Signature signature2 = this.importedFunction(signature);
        if (signature2 == null) {
            return true;
        }
        this.error("XQST0034", signature.offset, "function " + this.prefixedName(signature.qname) + " already defined in module " + signature2.module.getPhysicalURI());
        return false;
    }

    void initGlobals(EvalContext evalContext, HashMap hashMap) throws EvaluationException {
        Object object;
        Object object2;
        if (this.predefined != null) {
            this.predefined.initGlobals(evalContext, hashMap);
        }
        int n = this.declarations.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.declarations.get(i) instanceof ModuleImport)) continue;
            object2 = (ModuleImport)this.declarations.get(i);
            object = ((ModuleImport)object2).imported;
            if (hashMap.get(object) != null) continue;
            hashMap.put(object, object);
            ((ModuleContext)object).initGlobals(evalContext, hashMap);
            hashMap.remove(object);
        }
        for (GlobalVariable globalVariable : this.globalMap.values()) {
            object2 = (XQValue)hashMap.get(globalVariable.name);
            if (object2 == null) continue;
            object2 = object2.bornAgain();
            if (globalVariable.declaredType != null) {
                object2 = object2.checkTypeExpand(globalVariable.declaredType, evalContext, false, true);
            }
            evalContext.setGlobal(globalVariable, (XQValue)object2);
        }
        n = this.declarations.size();
        for (int i = 0; i < n; ++i) {
            Object object3;
            Object object4;
            if (!(this.declarations.get(i) instanceof GlobalVariable)) continue;
            object2 = (GlobalVariable)this.declarations.get(i);
            object = ((GlobalVariable)object2).declaredType;
            this.curInitVar = object2;
            if (((GlobalVariable)object2).init != null) {
                object4 = ((GlobalVariable)object2).init.eval(null, evalContext);
                try {
                    object4 = object4.checkTypeExpand((XQType)object, evalContext, false, true);
                    if (object4 instanceof ErrorValue) {
                        evalContext.error("XPTY0004", ((GlobalVariable)object2).init, ((ErrorValue)object4).getReason());
                    }
                }
                catch (XQTypeException xQTypeException) {
                    evalContext.error((Expression)object2, xQTypeException);
                }
                evalContext.setGlobal((GlobalVariable)object2, (XQValue)object4);
                this.curInitVar = null;
            }
            object4 = ((GlobalVariable)object2).name;
            Object v = hashMap.get(object4);
            XQValue xQValue = null;
            if (v instanceof ResultSequence) {
                object3 = (ResultSequence)v;
                xQValue = ((ResultSequence)object3).getValues();
            } else {
                xQValue = (XQValue)v;
            }
            if (xQValue == null && object4.getNamespaceURI() == NamespaceContext.LOCAL_NS) {
                object3 = IQName.get(object4.getLocalPart());
                xQValue = (XQValue)hashMap.get(object3);
            }
            if (xQValue == null) continue;
            xQValue = xQValue.bornAgain();
            if (object != null) {
                try {
                    xQValue = xQValue.checkTypeExpand((XQType)object, evalContext, true, true);
                    if (xQValue instanceof ErrorValue) {
                        evalContext.error("XPTY0004", (Expression)object2, ((ErrorValue)xQValue).getReason());
                    }
                }
                catch (XQTypeException xQTypeException) {
                    evalContext.error((Expression)object2, xQTypeException);
                }
            }
            evalContext.setGlobal((GlobalVariable)object2, xQValue);
        }
    }

    public EvalContext getConstantEvalContext() {
        if (this.cstEvalContext == null) {
            MainQuery mainQuery = this instanceof MainQuery ? (MainQuery)this : null;
            this.cstEvalContext = new EvalContext(new DynamicContext(mainQuery, null));
        }
        return this.cstEvalContext;
    }

    public Expression evalConstantExpr(Expression expression) {
        EvalContext evalContext = this.getConstantEvalContext();
        try {
            XQValue xQValue = expression.eval(null, evalContext);
            if (xQValue.next()) {
                switch (xQValue.getItemType().quickCode()) {
                    case 4: {
                        return new DoubleLiteral(xQValue.getDouble());
                    }
                    case 2: {
                        return new DecimalLiteral(xQValue.getDecimal());
                    }
                    case 1: {
                        return new IntegerLiteral(xQValue.getInteger());
                    }
                }
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        return expression;
    }

    public int getLocalSize() {
        return this.maxLocalSize;
    }

    public void setSource(String string, String string2) {
        Check.nonNull(string, "source");
        this.source = string;
        this.physicalURI = string2;
    }

    public String getSource() {
        return this.source;
    }

    public void error(String string, Expression expression, String string2) {
        ModuleContext moduleContext = expression.module;
        if (moduleContext == null) {
            moduleContext = this;
        }
        moduleContext.error(string, expression.offset, string2);
    }

    public void error(String string, int n, String string2) {
        this.error(ModuleContext.xqueryErrorCode(string), n, string2);
    }

    public void error(QName qName, Expression expression, String string) {
        ModuleContext moduleContext = expression.module;
        if (moduleContext == null) {
            moduleContext = this;
        }
        moduleContext.error(qName, expression.offset, string);
    }

    public void error(QName qName, int n, String string) {
        this.passMessage(1, qName, n, string);
    }

    public void warning(Expression expression, String string) {
        ModuleContext moduleContext = expression.module;
        if (moduleContext == null) {
            moduleContext = this;
        }
        moduleContext.warning("", expression.offset, string);
    }

    public void warning(int n, String string) {
        this.warning("", n, string);
    }

    public void warning(String string, int n, String string2) {
        this.passMessage(2, ModuleContext.xqueryErrorCode(string), n, string2);
    }

    public void info(String string) {
        this.passMessage(3, null, 0, string);
    }

    private void passMessage(int n, QName qName, int n2, String string) {
        if (this.messageTarget == null) {
            return;
        }
        int n3 = 1;
        int n4 = this.source.indexOf(10);
        int n5 = 0;
        while (n4 >= 0 && n4 < n2) {
            n5 = n4 + 1;
            n4 = this.source.indexOf(10, n4 + 1);
            ++n3;
        }
        String string2 = this.source.substring(n5, n4 < 0 ? this.source.length() : n4);
        this.messageTarget.receive(new Message(n, qName, string, this.getPhysicalURI(), n2, n3, n2 - n5, string2));
    }

    public Expression simpleStaticCheck(Expression expression, int n) {
        Object object;
        if (expression == null) {
            return null;
        }
        if (this.exprDepth >= this.exprStack.length) {
            object = this.exprStack;
            this.exprStack = new Expression[((Expression[])object).length * 2];
            System.arraycopy(object, 0, this.exprStack, 0, ((Expression[])object).length);
        }
        this.exprStack[this.exprDepth++] = expression;
        if (expression.module == null) {
            expression.module = this;
        }
        object = expression.staticCheck(this, n);
        --this.exprDepth;
        return object;
    }

    public Expression staticCheck(Expression expression, int n) {
        Expression expression2 = this.simpleStaticCheck(expression, n);
        if (UpdatingExpr.isUpdating(expression2)) {
            this.error("XUST0001", expression2, "updating expression is not allowed here");
        }
        return expression2;
    }

    public Expression getEnclosing(int n) {
        if (n < 0 || n > this.exprDepth - 1) {
            return null;
        }
        return this.exprStack[this.exprDepth - 1 - n];
    }

    public boolean check(Prototype prototype, int n, Expression expression) {
        return true;
    }

    public Expression resolve(QName qName, Prototype[] prototypeArray, Expression[] expressionArray, Expression expression) {
        int n;
        boolean bl = false;
        Prototype prototype = null;
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < prototypeArray.length; ++n2) {
            if (qName != prototypeArray[n2].qname || !prototypeArray[n2].checkArgCount(expressionArray)) continue;
            ++n3;
            prototype = prototypeArray[n2];
        }
        if (n3 > 1) {
            prototype = null;
            int n4 = Prototype.NO_MATCH;
            for (n2 = 0; n2 < prototypeArray.length; ++n2) {
                n = prototypeArray[n2].matchingDistance(expressionArray);
                if (n >= n4) continue;
                n4 = n;
                prototype = prototypeArray[n2];
            }
        }
        if (prototype == null) {
            bl = true;
            String string = Prototype.displayName(qName, this.getInScopeNS()) + " cannot be applied to (";
            for (n = 0; n < expressionArray.length; ++n) {
                if (n > 0) {
                    string = string + ',';
                }
                string = string + ' ';
                string = string + expressionArray[n].getType().toString(this);
            }
            string = string + " )";
            expression.module.error("XPST0017", expression.offset, string);
            this.info("known signature(s):");
            for (n = 0; n < prototypeArray.length; ++n) {
                if (prototypeArray[n].hidden || qName != prototypeArray[n].qname) continue;
                this.info(prototypeArray[n].toString(this.getInScopeNS()));
            }
            prototype = prototypeArray[0];
        }
        Function.Call call = prototype.instanciate(expressionArray);
        call.setType(prototype.returnType);
        call.module = expression.module;
        call.offset = expression.offset;
        if (!bl) {
            call.compilationHook();
        }
        return call;
    }

    public void staticTyping(Expression expression, SequenceType[] sequenceTypeArray, String string, String string2) {
        if (!this.strictTyping) {
            return;
        }
        boolean bl = false;
        int n = sequenceTypeArray.length;
        while (--n >= 0) {
            if (!sequenceTypeArray[n].acceptsStatic(expression.getType())) continue;
            bl = true;
        }
        if (!bl) {
            if (string2 == null) {
                string2 = "expression";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < sequenceTypeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append(sequenceTypeArray[i].toString(this));
            }
            expression.module.error(string, expression.offset, "static type error for " + string2 + ": expecting " + stringBuffer + " not " + expression.getType());
        }
    }

    public void staticTypingExclude(Expression expression, SequenceType[] sequenceTypeArray, String string, String string2) {
        if (!this.strictTyping) {
            return;
        }
        boolean bl = true;
        int n = sequenceTypeArray.length;
        while (--n >= 0) {
            if (!sequenceTypeArray[n].acceptsStatic(expression.getType())) continue;
            bl = false;
        }
        if (!bl) {
            if (string2 == null) {
                string2 = "expression";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < sequenceTypeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append(sequenceTypeArray[i].toString(this));
            }
            expression.module.error(string, expression.offset, "static type error for " + string2 + ": must not match " + stringBuffer);
        }
    }

    public void addDefaultNamespace(boolean bl, String string) {
        if (bl) {
            this.setDefaultFunctionNamespace(string);
        } else {
            this.setDefaultElementNamespace(string);
            this.declarePrefix("", string);
        }
    }

    public boolean addNamespaceDecl(int n, String string, String string2) {
        NamespaceContext namespaceContext = this.getInScopeNS();
        if (namespaceContext.isPrefixLocal(string)) {
            this.error("XQST0033", n, "namespace prefix '" + string + "' is already declared");
        }
        this.declarePrefix(string, string2);
        return true;
    }

    public String getPhysicalURI() {
        return this.physicalURI;
    }

    public void setNamespaceURI(String string) {
        this.moduleNS = NamespaceContext.unique(string);
    }

    public String getNamespaceURI() {
        return this.moduleNS;
    }

    public int getCopyNSMode() {
        if (this.preserveNamespaces) {
            return this.inheritNamespaces ? 1 : 3;
        }
        return this.inheritNamespaces ? 2 : 4;
    }

    public void storePragmas(Pragma[] pragmaArray) {
        this.pragmas = pragmaArray;
    }

    public Pragma[] getPragmas() {
        return this.pragmas;
    }

    public void setDefaultFtOptions(FullText.MatchOptions matchOptions) {
        this.defaultFTOptions = matchOptions;
    }

    public FullText.MatchOptions getDefaultFTOptions() {
        return this.defaultFTOptions;
    }

    public void addDeclaration(Object object) {
        this.declarations.add(object);
    }

    private ModuleContext importedModule(int n) {
        return (ModuleContext)this.importedModules.get(n);
    }

    public boolean alreadyImportedModule(String string) {
        for (int i = 0; i < this.declarations.size(); ++i) {
            ModuleContext moduleContext;
            Object e = this.declarations.get(i);
            if (!(e instanceof ModuleContext) || !string.equals((moduleContext = (ModuleContext)e).getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    public XQItemType lookForType(QName qName) {
        return XQType.findItemType(qName);
    }

    public Function simpleFunctionLookup(QName qName) {
        Function function = (Function)this.functionMap.get(qName);
        return function;
    }

    public Function localFunctionLookup(QName qName) {
        return this.simpleFunctionLookup(qName);
    }

    public void declareFunction(Function function) {
        Prototype[] prototypeArray = function.getProtos();
        for (int i = 0; i < prototypeArray.length; ++i) {
            this.functionMap.put(prototypeArray[i].qname, function);
        }
    }

    public Function functionLookup(QName qName) {
        Function function = this.localFunctionLookup(qName);
        if (function != null) {
            return function;
        }
        int n = this.importedModules.size();
        while (--n >= 0) {
            function = this.importedModule(n).localFunctionLookup(qName);
            if (function == null) continue;
            return function;
        }
        return this.predefined == null ? null : this.predefined.functionLookup(qName);
    }

    public Prototype functionLookup(QName qName, int n) {
        Function function = this.functionLookup(qName);
        if (function == null) {
            return null;
        }
        for (Prototype prototype : function.getProtos()) {
            if (prototype.qname != qName || !prototype.accepts(n)) continue;
            return prototype;
        }
        return null;
    }

    public UserFunction.Signature importedFunction(UserFunction.Signature signature) {
        return (UserFunction.Signature)this.importedFunctions.get(signature);
    }

    public void declareFunction(QName qName, Function function) {
        this.functionMap.put(qName, function);
    }

    public GlobalVariable lookforGlobalVariable(QName qName) {
        GlobalVariable globalVariable = this.localGlobalVarLookup(qName);
        if (globalVariable != null) {
            return globalVariable;
        }
        globalVariable = this.importedGlobal(qName);
        if (globalVariable != null) {
            return globalVariable;
        }
        return this.predefined == null ? null : this.predefined.lookforGlobalVariable(qName);
    }

    public GlobalVariable importedGlobal(QName qName) {
        return (GlobalVariable)this.importedGlobals.get(qName);
    }

    public GlobalVariable defineGlobal(QName qName, SequenceType sequenceType) {
        GlobalVariable globalVariable = this.declareGlobal(qName, sequenceType);
        this.addDeclaration(globalVariable);
        return globalVariable;
    }

    public void resetLocals() {
        this.maxLocalSize = 0;
        this.localItemCnt = 0;
        this.localStringCnt = 0;
        this.localDoubleCnt = 0;
        this.localIntCnt = 0;
        this.localCnt = 0;
        this.locals = this.lastLocal = new LocalVariable(null, null, null);
    }

    public void popLocalVariables(LocalVariable localVariable) {
        this.lastLocal = localVariable;
    }

    public LocalVariable defineLocalVariable(QName qName, XQType xQType, Expression expression) {
        LocalVariable localVariable = this.newLocal(qName, xQType, expression);
        this.lastLocal.addAfter(localVariable);
        this.lastLocal = localVariable;
        return localVariable;
    }

    public LocalVariable newLocal(QName qName, XQType xQType, Expression expression) {
        int n = ++this.genId;
        if (qName == null) {
            qName = IQName.get("_" + n);
        }
        LocalVariable localVariable = new LocalVariable(qName, xQType, expression);
        localVariable.id = n;
        return localVariable;
    }

    public LocalVariable firstLocalVariable() {
        return this.locals.succ;
    }

    public LocalVariable latestLocalVariable() {
        return this.lastLocal;
    }

    public void pushLocalsLevel() {
        LocalVars localVars = new LocalVars();
        localVars.locals = this.locals;
        localVars.lastLocal = this.lastLocal;
        localVars.up = this.upLevels;
        localVars.maxLocalSize = this.maxLocalSize;
        this.upLevels = localVars;
        this.resetLocals();
    }

    public void popLocalsLevel() {
        if (this.upLevels == null) {
            throw new IllegalStateException("no closure");
        }
        this.locals = this.upLevels.locals;
        this.lastLocal = this.upLevels.lastLocal;
        this.maxLocalSize = this.upLevels.maxLocalSize;
        this.upLevels = this.upLevels.up;
    }

    public LocalVariable lookforLocalVariable(QName qName) {
        LocalVariable localVariable = this.lastLocal;
        while (localVariable != null) {
            if (localVariable.name == qName) {
                return localVariable;
            }
            localVariable = localVariable.pred;
        }
        return null;
    }

    public VarReference.Local lookforClosureVariable(QName qName) {
        LocalVariable localVariable = this.lookforLocalVariable(qName);
        if (localVariable != null) {
            return new VarReference.Local(localVariable);
        }
        int n = 1;
        LocalVars localVars = this.upLevels;
        while (localVars != null) {
            LocalVariable localVariable2 = localVars.lastLocal;
            while (localVariable2 != null) {
                if (localVariable2.name == qName) {
                    VarReference.Local local = new VarReference.Local(localVariable2);
                    local.upLevel = n;
                    return local;
                }
                localVariable2 = localVariable2.pred;
            }
            ++n;
            localVars = localVars.up;
        }
        return null;
    }

    public void dumpLocals(String string) {
        System.err.println(string);
        this.recDump(this.locals, 0);
    }

    private void recDump(LocalVariable localVariable, int n) {
        LocalVariable localVariable2 = localVariable;
        while (localVariable2 != null) {
            for (int i = 0; i < n; ++i) {
                System.err.print("   ");
            }
            System.err.println(n + "  local $" + localVariable2.name + " pos " + localVariable2.offset + " addr " + localVariable2.address);
            this.recDump(localVariable2.succ, n + 1);
            localVariable2 = localVariable2.replacing;
        }
    }

    public int allocateLocalAddress(LocalVariable localVariable) {
        if (localVariable == null) {
            localVariable = this.locals;
        }
        int n = -1;
        XQType xQType = localVariable.getType();
        if (localVariable.name != null) {
            if (localVariable.address < 0 || xQType.getOccurrence() != 1) {
                n = 20;
                localVariable.address = 20 + this.localCnt++;
                this.maxLocalSize = Math.max(localVariable.address, this.maxLocalSize);
            } else if (XQType.INTEGER.equals(xQType)) {
                n = 0;
                localVariable.address = 0 + this.localIntCnt++;
                if (this.localIntCnt > 4) {
                    this.error("BUG", (Expression)localVariable, "BUG: too many 'integer registers: " + this.localIntCnt);
                }
                if (this.trace) {
                    System.err.println("var " + localVariable.name + " -> " + localVariable.address + " / " + this.localIntCnt);
                }
            } else if (xQType == XQType.STRING) {
                n = 8;
                localVariable.address = 8 + this.localStringCnt++;
                if (this.localStringCnt > 4) {
                    this.error("BUG", (Expression)localVariable, "BUG: too many 'string registers");
                }
            } else if (xQType == XQType.DOUBLE) {
                n = 4;
                localVariable.address = 4 + this.localDoubleCnt++;
                if (this.localDoubleCnt > 4) {
                    this.error("BUG", (Expression)localVariable, "BUG: too many 'double registers");
                }
            } else {
                n = 12;
                localVariable.address = 12 + this.localItemCnt++;
                if (this.localItemCnt > 8) {
                    this.error("BUG", (Expression)localVariable, "BUG: too many item registers");
                }
            }
        }
        LocalVariable localVariable2 = localVariable.succ;
        while (localVariable2 != null) {
            this.allocateLocalAddress(localVariable2);
            localVariable2 = localVariable2.replacing;
        }
        switch (n) {
            case 0: {
                --this.localIntCnt;
                break;
            }
            case 8: {
                --this.localStringCnt;
                break;
            }
            case 4: {
                --this.localDoubleCnt;
                break;
            }
            case 12: {
                --this.localItemCnt;
                break;
            }
            case 20: {
                --this.localCnt;
            }
        }
        return this.maxLocalSize;
    }

    public void pushDotType(XQType xQType) {
        this.dotTypeStack = new DotType(xQType.itemType(), this.dotTypeStack);
    }

    public void popDotType() {
        this.dotTypeStack = this.dotTypeStack.up;
    }

    public XQItemType getDotType() {
        return this.dotTypeStack == null ? null : this.dotTypeStack.type;
    }

    public boolean sObs() {
        return this.getStrictCompliance();
    }

    public static QName xqueryErrorCode(String string) {
        return IQName.get(NamespaceContext.ERR, string);
    }

    void setMessageTarget(MessageReceiver messageReceiver) {
        this.messageTarget = messageReceiver;
    }

    MessageReceiver getMessageTarget() {
        return this.messageTarget;
    }

    public void storeOption(IQName iQName, String string) {
        if (this.optionMap == null) {
            this.optionMap = new HashMap();
        }
        this.optionMap.put(iQName, string);
    }

    protected GlobalVariable getCurInitVar() {
        return this.curInitVar;
    }

    private static class DotType {
        DotType up;
        XQItemType type;

        DotType(XQItemType xQItemType, DotType dotType) {
            this.type = xQItemType;
            this.up = dotType;
        }
    }

    private static class LocalVars {
        LocalVars up;
        LocalVariable locals;
        LocalVariable lastLocal;
        int maxLocalSize = 0;

        private LocalVars() {
        }
    }
}

