/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Util;
import com.qizx.xdm.IQName;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQType;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.JavaFunction;
import com.qizx.xquery.fn.MathFun;
import com.qizx.xquery.fn._Boolean;
import com.qizx.xquery.fn._Empty;
import com.qizx.xquery.fn._String;

public class PredefinedModule
extends ModuleContext {
    private static final String funPackage;
    private FunctionPlugger[] pluggers = new FunctionPlugger[0];
    private JavaFunction.Plugger javaPlugger;

    public PredefinedModule() {
        super(null);
        this.registerFunctionPlugger(new BasicFunctionPlugger(NamespaceContext.FN, funPackage + ".%C"));
        this.registerFunctionPlugger(new BasicFunctionPlugger(NamespaceContext.XSD, funPackage + ".XS_%n"));
        this.javaPlugger = new JavaFunction.Plugger();
        this.registerFunctionPlugger(this.javaPlugger);
        try {
            this.declareFunction(new _Boolean());
            this.declareFunction(new _String());
            this.declareFunction(new _Empty());
            this.declareFunction(new MathFun());
            this.defineGlobal(IQName.get("arguments"), XQType.STRING.star);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.importedModules.clear();
        this.predefined = null;
    }

    public void registerFunctionPlugger(FunctionPlugger functionPlugger) {
        FunctionPlugger[] functionPluggerArray = this.pluggers;
        this.pluggers = new FunctionPlugger[functionPluggerArray.length + 1];
        System.arraycopy(functionPluggerArray, 0, this.pluggers, 0, functionPluggerArray.length);
        this.pluggers[functionPluggerArray.length] = functionPlugger;
    }

    public void authorizeJavaClass(String string) {
        this.javaPlugger.authorizeClass(string);
    }

    public Function localFunctionLookup(QName qName) throws SecurityException {
        Function function = (Function)this.functionMap.get(qName);
        if (function != null) {
            return function;
        }
        for (int i = 0; i < this.pluggers.length; ++i) {
            function = this.pluggers[i].plug(qName, this);
            if (function == null) continue;
            this.declareFunction(function);
            return function;
        }
        return (Function)this.functionMap.get(qName);
    }

    static {
        String string = Function.class.getName();
        funPackage = string.substring(0, string.lastIndexOf(46));
    }

    public static class BasicFunctionPlugger
    implements FunctionPlugger {
        String ns;
        String pattern;

        public BasicFunctionPlugger(String string, String string2) {
            this.ns = NamespaceContext.unique(string);
            this.pattern = string2;
        }

        public Function plug(QName qName, PredefinedModule predefinedModule) {
            if (qName.getNamespaceURI() != this.ns) {
                return null;
            }
            String string = qName.getLocalPart();
            StringBuffer stringBuffer = new StringBuffer(this.pattern.length() + string.length());
            int n = this.pattern.length();
            for (int i = 0; i < n; ++i) {
                char c = this.pattern.charAt(i);
                if (c != '%') {
                    stringBuffer.append(c);
                    continue;
                }
                if ((c = this.pattern.charAt(++i)) == 'n') {
                    stringBuffer.append(string);
                    continue;
                }
                if (c != 'C' && c != 'c') continue;
                stringBuffer.append(Util.camelCase(string, c == 'C'));
            }
            try {
                Class<?> clazz = Class.forName(stringBuffer.toString());
                return (Function)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {
                System.err.println("*** error instantiating function " + qName);
                exception.printStackTrace();
            }
            return null;
        }
    }

    public static interface FunctionPlugger {
        public Function plug(QName var1, PredefinedModule var2) throws SecurityException;
    }
}

