/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.CompilationException;
import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Indexing;
import com.qizx.api.Item;
import com.qizx.api.ItemFactory;
import com.qizx.api.ItemSequence;
import com.qizx.api.ItemType;
import com.qizx.api.Message;
import com.qizx.api.ModuleResolver;
import com.qizx.api.QName;
import com.qizx.api.SequenceType;
import com.qizx.api.XMLPullStream;
import com.qizx.api.XQueryContext;
import com.qizx.api.XQuerySession;
import com.qizx.api.XQuerySessionManager;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.util.fulltext.DefaultFullTextFactory;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xquery.BasicStaticContext;
import com.qizx.xquery.DynamicContext;
import com.qizx.xquery.ExpressionImpl;
import com.qizx.xquery.ItemFactoryImpl;
import com.qizx.xquery.MainQuery;
import com.qizx.xquery.MessageReceiver;
import com.qizx.xquery.ModuleManager;
import com.qizx.xquery.PredefinedModule;
import com.qizx.xquery.ext.ExtensionFunction;
import com.qizx.xquery.ext.SqlConnection;
import com.qizx.xquery.impl.NewParser;
import com.qizx.xquery.op.Expression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.InputSource;

public class XQuerySessionImpl
implements XQuerySession,
MessageReceiver {
    private XQuerySessionManager manager;
    private BasicStaticContext xqContext;
    private ItemFactory itemMaker;
    private int errorCount;
    private ArrayList messages = new ArrayList();
    private QName firstErrorCode;
    private QName latestErrorCode;
    private ModuleResolver moduleResolver;
    private HashMap properties;
    protected FullTextFactory fulltextProvider;

    public XQuerySessionImpl(XQuerySessionManager xQuerySessionManager) {
        this.manager = xQuerySessionManager;
        this.xqContext = new BasicStaticContext();
        this.itemMaker = new ItemFactoryImpl();
        this.fulltextProvider = new DefaultFullTextFactory();
        XQuerySessionImpl.plugBuiltins(this.xqContext);
    }

    public static PredefinedModule plugBuiltins(BasicStaticContext basicStaticContext) {
        PredefinedModule predefinedModule = basicStaticContext.getPredefinedModule();
        String string = ExtensionFunction.EXTENSION_NS;
        basicStaticContext.declarePrefix("x", string);
        basicStaticContext.declarePrefix("qizx", string);
        predefinedModule.registerFunctionPlugger(new PredefinedModule.BasicFunctionPlugger(string, "com.qizx.xquery.ext.Xfn%C"));
        basicStaticContext.declarePrefix("ft", ExtensionFunction.FULLTEXT_EXT_NS);
        predefinedModule.registerFunctionPlugger(new PredefinedModule.BasicFunctionPlugger(ExtensionFunction.FULLTEXT_EXT_NS, "com.qizx.xquery.ext.FT_%C"));
        basicStaticContext.declarePrefix("sql", SqlConnection.NS);
        predefinedModule.registerFunctionPlugger(new PredefinedModule.BasicFunctionPlugger(SqlConnection.NS, "com.qizx.xquery.ext.Sql%C"));
        basicStaticContext.declarePrefix("xlib", "com.qizx.functions.xlib");
        return predefinedModule;
    }

    public XQueryContext getContext() {
        return this.xqContext;
    }

    public BasicStaticContext getBasicContext() {
        return this.xqContext;
    }

    public ModuleManager getModuleManager() {
        return this.manager.getModuleManager();
    }

    public Expression staticCheck(Expression expression, MainQuery mainQuery) throws CompilationException {
        this.errorCount = 0;
        this.messages.clear();
        Expression expression2 = mainQuery.simpleStaticCheck(expression, 0);
        if (this.errorCount > 0) {
            this.compilError();
        }
        return expression2;
    }

    public com.qizx.api.Expression compileExpression(String string) throws CompilationException {
        return this.compile(string, this.xqContext);
    }

    ExpressionImpl compile(String string, BasicStaticContext basicStaticContext) throws CompilationException {
        MainQuery mainQuery = new MainQuery(basicStaticContext);
        mainQuery.setMessageTarget(this);
        this.latestErrorCode = null;
        this.firstErrorCode = null;
        this.errorCount = 0;
        this.messages.clear();
        ModuleManager moduleManager = this.manager.getModuleManager();
        NewParser newParser = new NewParser(moduleManager);
        if (this.moduleResolver != null) {
            newParser.setModuleResolver(this.moduleResolver);
        }
        mainQuery.setFulltextProvider(this.fulltextProvider);
        try {
            newParser.parseQuery(mainQuery, string, null);
        }
        catch (CompilationException compilationException) {
            Message[] messageArray = new Message[this.messages.size()];
            compilationException.setMessages(this.messages.toArray(messageArray));
            throw compilationException;
        }
        if (this.errorCount == 0) {
            mainQuery.staticCheck(moduleManager);
        }
        if (this.errorCount > 0) {
            this.compilError();
        }
        ExpressionImpl expressionImpl = new ExpressionImpl(new DynamicContext(mainQuery, this), mainQuery);
        return expressionImpl;
    }

    private void compilError() throws CompilationException {
        CompilationException compilationException = new CompilationException(this.errorCount + " error(s) in static analysis");
        if (this.firstErrorCode != null) {
            compilationException.setErrorCode(this.firstErrorCode);
        }
        Message[] messageArray = new Message[this.messages.size()];
        compilationException.setMessages(this.messages.toArray(messageArray));
        throw compilationException;
    }

    public void receive(Message message) {
        this.messages.add(message);
        if (message.getType() == 1) {
            ++this.errorCount;
            if (message.getErrorCode() != null) {
                if (this.firstErrorCode == null) {
                    this.firstErrorCode = message.getErrorCode();
                }
                this.latestErrorCode = message.getErrorCode();
            }
        }
    }

    public ItemSequence copySequence(ItemSequence itemSequence) throws EvaluationException {
        return this.itemMaker.copySequence(itemSequence);
    }

    public Item createItem(boolean bl) {
        return this.itemMaker.createItem(bl);
    }

    public Item createItem(double d) {
        return this.itemMaker.createItem(d);
    }

    public Item createItem(float f) {
        return this.itemMaker.createItem(f);
    }

    public Item createItem(InputSource inputSource) throws EvaluationException, IOException {
        return this.itemMaker.createItem(inputSource);
    }

    public Item createItem(long l, ItemType itemType) throws EvaluationException {
        return this.itemMaker.createItem(l, itemType);
    }

    public Item createItem(Object object, ItemType itemType) throws EvaluationException {
        return this.itemMaker.createItem(object, itemType);
    }

    public Item createItem(XMLPullStream xMLPullStream) throws EvaluationException {
        return this.itemMaker.createItem(xMLPullStream);
    }

    public ItemSequence createSequence(Object object, SequenceType sequenceType) throws EvaluationException {
        return this.itemMaker.createSequence(object, sequenceType);
    }

    public QName getQName(String string, String string2, String string3) {
        return this.itemMaker.getQName(string, string2, string3);
    }

    public QName getQName(String string, String string2) {
        return this.itemMaker.getQName(string, string2);
    }

    public QName getQName(String string) {
        return this.itemMaker.getQName(string);
    }

    public ItemType getType(String string) {
        return this.itemMaker.getType(string);
    }

    public ItemType getNodeType(int n, QName qName) {
        return this.itemMaker.getNodeType(n, qName);
    }

    public BasicNode getDocument(String string) throws DataModelException {
        FONIDataModel fONIDataModel = this.manager.getDocumentCache().findDocument(string);
        return fONIDataModel == null ? null : fONIDataModel.getDocumentNode();
    }

    public ModuleResolver getModuleResolver() {
        return this.moduleResolver;
    }

    public void setModuleResolver(ModuleResolver moduleResolver) {
        this.moduleResolver = moduleResolver;
    }

    public void enableJavaBinding(String string) {
        this.xqContext.getPredefinedModule().authorizeJavaClass(string);
    }

    public Indexing.WordSieve getWordSieve() {
        return null;
    }

    public void setWordSieve(Indexing.WordSieve wordSieve) {
    }

    public FullTextFactory getFullTextFactory() {
        return this.fulltextProvider;
    }

    public void setFullTextFactory(FullTextFactory fullTextFactory) {
        this.fulltextProvider = fullTextFactory;
    }

    public Object getProperty(String string) {
        return this.properties == null ? null : this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }
}

