/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QizxException;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.dt.SingleBoolean;

public abstract class BooleanValue
extends BaseValue {
    public static SingleBoolean TRUE = new SingleBoolean(true);
    public static SingleBoolean FALSE = new SingleBoolean(false);

    public BooleanValue() {
        this.itemType = XQType.BOOLEAN;
    }

    public abstract boolean getValue();

    public XQItem getItem() {
        return this.getValue() ? TRUE : FALSE;
    }

    public double getDouble() throws EvaluationException {
        return Conversion.toDouble(this.getBoolean());
    }

    public float getFloat() throws EvaluationException {
        return Conversion.toFloat(this.getBoolean());
    }

    public long getInteger() throws EvaluationException {
        return Conversion.toInteger(this.getBoolean());
    }

    public String getString() throws EvaluationException {
        return Conversion.toString(this.getBoolean());
    }

    public Object getObject() throws QizxException {
        return this.getValue();
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        switch (xQItemType.quickCode()) {
            case 5: {
                if ((n & 2) != 0) {
                    return 2;
                }
            }
            case 13: {
                boolean bl = xQItem.getBoolean();
                return this.getBoolean() == bl ? 0 : (bl ? -1 : 1);
            }
        }
        return 2;
    }

    public boolean equals(Object object) {
        if (object instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)object;
            return this.getValue() == booleanValue.getValue();
        }
        return false;
    }

    public int hashCode() {
        return this.getValue() ? 1 : 0;
    }
}

