/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.MomentType;
import com.qizx.xquery.dt.SingleMoment;
import java.util.Calendar;
import java.util.Date;

public class DateType
extends MomentType {
    public String getShortName() {
        return "date";
    }

    public int quickCode() {
        return 9;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        DateTimeBase dateTimeBase = null;
        try {
            switch (xQItemType.quickCode()) {
                case 5: 
                case 6: {
                    return SingleMoment.date(xQItem.getDate());
                }
                case 8: 
                case 9: {
                    return SingleMoment.date(new com.qizx.api.util.time.Date(xQItem.getMoment()));
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (evalContext.sObs()) break;
                    double d = xQItem.getDouble();
                    return SingleMoment.date(new com.qizx.api.util.time.Date((long)(d * 1000.0)));
                }
            }
            this.invalidCast(xQItemType);
        }
        catch (DateTimeException dateTimeException) {
            this.castException(dateTimeException);
        }
        return new SingleMoment(dateTimeBase, XQType.DATE);
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        if (object instanceof Calendar) {
            object = ((Calendar)object).getTime();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new SingleMoment(DateTimeBase.fromDate(date, 0), this);
        }
        try {
            return new SingleMoment(com.qizx.api.util.time.Date.parseDate(object.toString()), this);
        }
        catch (DateTimeException dateTimeException) {
            return this.invalidObject(object);
        }
    }
}

