/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.Duration;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import java.math.BigDecimal;

public abstract class DurationValue
extends BaseValue {
    public abstract Duration getValue();

    public XQItem getItem() {
        return this;
    }

    public double getDouble() throws EvaluationException {
        Duration duration = this.getValue();
        switch (this.getItemType().quickCode()) {
            case 10: {
                return duration.getTotalMonths();
            }
            case 11: {
                return duration.getTotalSeconds();
            }
        }
        return super.getDouble();
    }

    public BigDecimal getDecimal() throws EvaluationException {
        long l = (long)(this.getDouble() * 1000.0);
        return BigDecimal.valueOf(l, 3);
    }

    public float getFloat() throws EvaluationException {
        return (float)this.getDouble();
    }

    public long getInteger() throws EvaluationException {
        return (long)this.getDouble();
    }

    public String getString() throws XQTypeException {
        return this.getValue().toString();
    }

    public Duration getDuration() {
        return this.getValue();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DurationValue)) {
            return false;
        }
        return this.getValue().equals(((DurationValue)object).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        XQItemType xQItemType = this.getItemType();
        XQItemType xQItemType2 = xQItem.getItemType();
        if ((n & 1) != 0 && (xQItemType != xQItemType2 || xQItemType == XQType.DURATION)) {
            return 2;
        }
        Duration duration = this.getValue();
        Duration duration2 = xQItem.getDuration();
        return duration.compareTo(duration2);
    }
}

