/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.util.Binary;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.BinaryType;
import com.qizx.xquery.dt.BinaryValue;
import com.qizx.xquery.dt.SingleBinary;
import com.qizx.xquery.dt.StringType;

public class HexBinaryType
extends BinaryType {
    public String getShortName() {
        return "hexBinary";
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        Binary binary = null;
        try {
            if (xQItemType instanceof StringType) {
                binary = Binary.parseHexBinary(xQItem.getString().trim());
            } else if (xQItemType instanceof BinaryType) {
                binary = ((BinaryValue)xQItem).getValue();
            } else {
                this.invalidCast(xQItemType);
            }
        }
        catch (Binary.Exception exception) {
            this.castException(exception);
        }
        return new SingleBinary(binary, XQType.HEX_BINARY);
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        if (object instanceof byte[]) {
            return new SingleBinary(new Binary((byte[])object), XQType.HEX_BINARY);
        }
        if (object instanceof String) {
            return new SingleBinary(Binary.parseHexBinary((String)object), XQType.HEX_BINARY);
        }
        return super.convertFromObject(object);
    }
}

