/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTime;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Time;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.AtomicType;
import com.qizx.xquery.dt.DateType;
import com.qizx.xquery.dt.MomentValue;
import com.qizx.xquery.dt.SingleMoment;
import com.qizx.xquery.dt.TimeType;
import com.qizx.xquery.op.Expression;
import java.util.Calendar;
import java.util.Date;

public class MomentType
extends AtomicType {
    public String getShortName() {
        return "moment";
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        if (object instanceof Calendar) {
            object = ((Calendar)object).getTime();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new SingleMoment(DateTimeBase.fromDate(date, 0), this);
        }
        if (object instanceof DateTimeBase) {
            DateTimeBase dateTimeBase = (DateTimeBase)object;
            return new SingleMoment(dateTimeBase, this);
        }
        try {
            String string = object.toString();
            if (this instanceof DateType) {
                return new SingleMoment(com.qizx.api.util.time.Date.parseDate(string), this);
            }
            if (this instanceof TimeType) {
                return new SingleMoment(Time.parseTime(string), this);
            }
            return new SingleMoment(DateTime.parseDateTime(string), this);
        }
        catch (DateTimeException dateTimeException) {
            return this.invalidObject(object);
        }
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQItem xQItem = expression.evalAsItem(focus, evalContext);
        DateTimeBase dateTimeBase = ((MomentValue)xQItem).getValue();
        return new com.qizx.api.util.time.Date((long)(1000.0 * dateTimeBase.getSecondsFromEpoch()));
    }
}

