/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.AtomicType;
import com.qizx.xquery.dt.SingleQName;

public class QNameType
extends AtomicType {
    public String getShortName() {
        return "QName";
    }

    public int quickCode() {
        return 15;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws XQTypeException {
        QName qName = null;
        String string = null;
        String string2 = null;
        try {
            XQItemType xQItemType = xQItem.getItemType();
            switch (xQItemType.quickCode()) {
                case 6: {
                    string = xQItem.getString().trim();
                    qName = evalContext.getInScopeNS().expandName(string);
                    string2 = IQName.extractPrefix(string);
                    if ("".equals(string2)) {
                        string2 = null;
                    }
                    break;
                }
                case 15: {
                    QName qName2;
                    qName = qName2 = xQItem.getQName();
                    string2 = qName2.getPrefix();
                    break;
                }
                default: {
                    this.invalidCast(this);
                    break;
                }
            }
        }
        catch (DataModelException dataModelException) {
            throw new XQTypeException("cannot cast to xs:QName: " + dataModelException.getMessage());
        }
        catch (EvaluationException evaluationException) {
            this.castException(evaluationException);
        }
        if (qName == null) {
            throw new XQTypeException("cannot cast " + string + " to xs:QName : unknown prefix " + string2);
        }
        return new SingleQName(string2 == null ? qName : XQName.get(qName, string2));
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        if (object instanceof QName) {
            return new SingleQName((QName)object);
        }
        if (object == null) {
            return XQValue.empty;
        }
        String string = object.toString();
        if (!XMLUtil.isNCName(string)) {
            this.invalidCast(this);
        }
        return new SingleQName(IQName.get(string));
    }
}

