/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.DurationValue;

public class SingleDuration
extends DurationValue {
    private Duration value;
    private boolean started = false;

    public SingleDuration(Duration duration) {
        this(duration, XQType.DURATION);
    }

    public static SingleDuration newYM(Duration duration) throws DateTimeException {
        if (duration == null || !duration.isYearMonth()) {
            throw new DateTimeException("invalid yearMonthDuration value");
        }
        return new SingleDuration(duration, XQType.YEAR_MONTH_DURATION);
    }

    public static SingleDuration newDT(Duration duration) throws DateTimeException {
        if (duration == null || !duration.isDayTime()) {
            throw new DateTimeException("invalid dayTimeDuration value");
        }
        return new SingleDuration(duration, XQType.DAY_TIME_DURATION);
    }

    public SingleDuration(Duration duration, XQItemType xQItemType) {
        this.value = duration;
        this.itemType = xQItemType;
    }

    public boolean next() {
        return this.started ? false : (this.started = true);
    }

    public XQValue bornAgain() {
        return new SingleDuration(this.value, this.itemType);
    }

    public Duration getValue() {
        return this.value;
    }
}

