/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Time;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.MomentType;
import com.qizx.xquery.dt.SingleMoment;

public class TimeType
extends MomentType {
    public String getShortName() {
        return "time";
    }

    public int quickCode() {
        return 7;
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        DateTimeBase dateTimeBase = null;
        try {
            switch (xQItemType.quickCode()) {
                case 5: 
                case 6: {
                    return SingleMoment.time(Time.parseTime(xQItem.getString().trim()));
                }
                case 7: 
                case 8: {
                    return SingleMoment.time(new Time(xQItem.getMoment()));
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (evalContext.sObs()) break;
                    double d = xQItem.getDouble();
                    return SingleMoment.time(new Time((long)(d * 1000.0), Integer.MAX_VALUE));
                }
            }
            this.invalidCast(xQItemType);
        }
        catch (DateTimeException dateTimeException) {
            this.castException(dateTimeException);
        }
        return new SingleMoment(dateTimeBase, XQType.TIME);
    }
}

