/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.IQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.DurationType;
import com.qizx.xquery.dt.SingleDuration;

public class YearMonthDurationType
extends DurationType {
    public QName getName() {
        return IQName.get(NamespaceContext.XSD, this.getShortName());
    }

    public int quickCode() {
        return 10;
    }

    public String toString() {
        return "xs:yearMonthDuration";
    }

    public String getShortName() {
        return "yearMonthDuration";
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws EvaluationException {
        XQItemType xQItemType = xQItem.getItemType();
        try {
            switch (xQItemType.quickCode()) {
                case 5: 
                case 6: {
                    return SingleDuration.newYM(Duration.parseDuration(xQItem.getString().trim()));
                }
                case 10: {
                    return SingleDuration.newYM(xQItem.getDuration().copy());
                }
                case 11: 
                case 12: {
                    int n = xQItem.getDuration().getTotalMonths();
                    return SingleDuration.newYM(Duration.newYearMonth(n));
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (evalContext == null || evalContext.sObs()) break;
                    return SingleDuration.newYM(Duration.newYearMonth((int)xQItem.getDouble()));
                }
            }
            this.invalidCast(xQItemType);
        }
        catch (DateTimeException dateTimeException) {
            this.castException(dateTimeException);
        }
        return null;
    }
}

