/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.ext;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.util.time.DateTimeBase;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CorePushBuilder;
import com.qizx.xdm.IQName;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.PredefinedModule;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.DecimalValue;
import com.qizx.xquery.dt.DoubleValue;
import com.qizx.xquery.dt.FloatValue;
import com.qizx.xquery.dt.MomentValue;
import com.qizx.xquery.dt.SingleWrappedObject;
import com.qizx.xquery.dt.StringValue;
import com.qizx.xquery.dt.WrappedObjectType;
import com.qizx.xquery.ext.SqlExecQuery;
import com.qizx.xquery.ext.SqlExecUpdate;
import com.qizx.xquery.ext.SqlRawExec;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SqlConnection {
    public static String NS = "java:com.qizx.xquery.ext.SqlConnection";
    public static XQItemType TYPE_CONNECTION = new WrappedObjectType(Connection.class);
    public static XQItemType TYPE_RESULTSET = new WrappedObjectType(ResultSet.class);
    public static XQItemType TYPE_PSTATEMENT = new WrappedObjectType(PreparedStatement.class);

    public static void plugHook(PredefinedModule predefinedModule) throws EvaluationException {
        if (predefinedModule.simpleFunctionLookup(IQName.get(NS, "execute")) != null) {
            return;
        }
        predefinedModule.declareFunction(new SqlExecQuery());
        predefinedModule.declareFunction(new SqlExecUpdate());
        predefinedModule.declareFunction(new SqlRawExec());
    }

    public static void registerDriver(String string) throws Exception {
        Class.forName(string).newInstance();
    }

    public static Connection getConnection(String string, String string2, String string3) throws SQLException {
        Connection connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    public static void close(Connection connection) throws SQLException {
        connection.close();
    }

    public static PreparedStatement prepare(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    static class Stat {
        PreparedStatement stat;
        ParameterMetaData meta;

        Stat(PreparedStatement preparedStatement) {
            this.stat = preparedStatement;
        }

        void setArg(int n, XQItem xQItem) throws EvaluationException, SQLException {
            if (xQItem == null) {
                if (this.meta == null) {
                    this.meta = this.stat.getParameterMetaData();
                }
                this.stat.setNull(n, this.meta.getParameterType(n));
                return;
            }
            ItemType itemType = xQItem.getType();
            if (xQItem instanceof StringValue) {
                this.stat.setString(n, xQItem.getString());
            } else if (itemType.isSubTypeOf(XQType.INTEGER)) {
                long l = xQItem.getInteger();
                this.stat.setLong(n, l);
            } else if (itemType.isSubTypeOf(XQType.NUMERIC)) {
                if (itemType == XQType.DOUBLE) {
                    this.stat.setDouble(n, ((DoubleValue)xQItem).getDouble());
                } else if (itemType == XQType.DECIMAL) {
                    this.stat.setBigDecimal(n, ((DecimalValue)xQItem).getValue());
                } else if (itemType == XQType.FLOAT) {
                    this.stat.setFloat(n, ((FloatValue)xQItem).getFloat());
                } else {
                    System.err.println("OOPS NUMERIC: " + xQItem);
                }
            } else if (xQItem instanceof MomentValue) {
                DateTimeBase dateTimeBase = ((MomentValue)xQItem).getValue();
                this.stat.setDate(n, new Date(dateTimeBase.getMillisecondsFromEpoch()));
            }
        }
    }

    public static class Result
    extends RawResult {
        CorePushBuilder builder = new CorePushBuilder(null);
        BasicNode currentNode;

        Result(ResultSet resultSet) {
            super(resultSet);
        }

        public boolean next() throws EvaluationException {
            try {
                int n;
                if (!this.rset.next()) {
                    return false;
                }
                if (this.meta == null) {
                    this.meta = this.rset.getMetaData();
                    n = this.meta.getColumnCount();
                    this.colNames = new QName[n];
                    for (int i = 1; i <= n; ++i) {
                        this.colNames[i - 1] = IQName.get(this.meta.getColumnLabel(i));
                    }
                }
                this.builder.reset();
                this.builder.putElementStart(ROW);
                for (n = 0; n < this.colNames.length; ++n) {
                    this.builder.putElementStart(this.colNames[n]);
                    String string = this.rset.getString(n + 1);
                    if (string != null) {
                        this.builder.putAtomText(string);
                    }
                    this.builder.putElementEnd(this.colNames[n]);
                }
                this.builder.putElementEnd(ROW);
                this.currentNode = this.builder.harvest();
                return true;
            }
            catch (SQLException sQLException) {
                throw new EvaluationException("error in row construction", sQLException);
            }
            catch (DataModelException dataModelException) {
                return false;
            }
        }

        public ItemType getType() {
            return XQType.NODE;
        }

        public XQItem getItem() {
            return (XQItem)((Object)this.getNode());
        }

        public boolean isNode() {
            return true;
        }

        public Node getNode() {
            return this.currentNode;
        }

        public XQValue bornAgain() {
            try {
                this.rset.beforeFirst();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return new Result(this.rset);
        }
    }

    public static class RawResult
    extends BaseValue {
        static QName ROW = IQName.get("row");
        ResultSet rset;
        ResultSetMetaData meta = null;
        QName[] colNames;

        RawResult(ResultSet resultSet) {
            this.rset = resultSet;
        }

        public boolean next() throws EvaluationException {
            try {
                return this.rset.next();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }

        public XQItem getItem() {
            return new SingleWrappedObject(this.rset);
        }

        public String getString() {
            return this.rset.toString();
        }

        public XQValue bornAgain() {
            try {
                this.rset.beforeFirst();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return new RawResult(this.rset);
        }
    }
}

