/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Util;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.PredefinedModule;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.JavaMapping;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;

public class JavaFunction
extends Function {
    public static boolean trace = false;
    private static Class[] hookProto = new Class[]{PredefinedModule.class};
    protected Signature[] prototypes;

    static Signature convertMethod(QName qName, Method method, QName qName2) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?>[] classArray = method.getParameterTypes();
        Signature signature = new Signature(qName, null, method, null);
        signature.isStatic = Modifier.isStatic(method.getModifiers());
        if (!Modifier.isStatic(method.getModifiers())) {
            signature.arg("this", JavaFunction.convertClass(method.getDeclaringClass()));
        }
        int n = 0;
        if (classArray.length > 0 && classArray[0] == EvalContext.class) {
            ++n;
            signature.ctxArg = true;
        }
        while (n < classArray.length) {
            XQType xQType = JavaFunction.convertClass(classArray[n]);
            if (xQType != XQType.ITEM.star) {
                signature.arg("p" + (n + 1), xQType);
            } else {
                signature.vararg = true;
            }
            ++n;
        }
        signature.returnType = JavaFunction.convertClass(method.getReturnType());
        return signature;
    }

    static Signature convertConstructor(QName qName, Constructor constructor) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return null;
        }
        Class<?>[] classArray = constructor.getParameterTypes();
        Signature signature = new Signature(qName, null, null, constructor);
        for (int i = 0; i < classArray.length; ++i) {
            signature.arg("p" + (i + 1), JavaFunction.convertClass(classArray[i]));
        }
        signature.returnType = JavaFunction.convertClass(constructor.getDeclaringClass());
        return signature;
    }

    public static synchronized XQType convertClass(Class clazz) {
        return JavaMapping.getSequenceType(clazz);
    }

    public static XQValue convertObject(Object object) throws XQTypeException {
        if (object == null) {
            return XQValue.empty;
        }
        return JavaFunction.convertClass(object.getClass()).convertFromObject(object);
    }

    public JavaFunction(Signature[] signatureArray, int n) {
        this.prototypes = new Signature[n];
        System.arraycopy(signatureArray, 0, this.prototypes, 0, n);
    }

    public Prototype[] getProtos() {
        return this.prototypes;
    }

    public static class Call
    extends Function.Call {
        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header(this);
            exprDisplay.property("prototype", this.prototype.toString());
            exprDisplay.children("actual arguments", this.args);
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            Signature signature = (Signature)this.prototype;
            NamespaceContext namespaceContext = evalContext.getStaticContext().getInScopeNS();
            if (signature.method != null) {
                Object object;
                int n;
                Object object2 = null;
                int n2 = signature.argCnt;
                int n3 = 0;
                if (!signature.isStatic) {
                    object2 = signature.argTypes[0].convertToObject(this.args[0], focus, evalContext);
                    --n2;
                    n3 = 1;
                } else if (signature.ctxArg) {
                    ++n2;
                }
                Object[] objectArray = new Object[signature.vararg ? n2 + 1 : n2];
                if (!signature.ctxArg) {
                    for (n = 0; n < n2; ++n) {
                        objectArray[n] = this.convertArgument(focus, evalContext, signature, n + n3);
                    }
                } else {
                    objectArray[0] = evalContext;
                    for (n = 1; n < n2; ++n) {
                        objectArray[n] = this.convertArgument(focus, evalContext, signature, n - 1);
                    }
                }
                if (signature.vararg) {
                    n = this.args.length - n2 + 1 - n3;
                    object = new XQItem[n];
                    for (int i = 0; i < n; ++i) {
                        object[i] = this.args[n2 - 1 + i].evalAsOptItem(focus, evalContext);
                    }
                    objectArray[n2] = object;
                }
                try {
                    if (trace) {
                        System.err.println("calling Java method: " + signature.method + "\n for " + signature);
                    }
                    Object object3 = signature.method.invoke(object2, objectArray);
                    return signature.returnType.convertFromObject(object3);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = invocationTargetException.getCause();
                    if (!(object instanceof Exception)) {
                        object = new RuntimeException((Throwable)object);
                    }
                    if (object instanceof EvaluationException) {
                        EvaluationException evaluationException = (EvaluationException)object;
                        evalContext.error(evaluationException.getErrorCode(), (Expression)this, ((Throwable)object).getMessage());
                    }
                    evalContext.error("FXJA0001", (Expression)this, new EvaluationException(((Throwable)object).getMessage(), (Exception)object));
                }
                catch (Exception exception) {
                    evalContext.error("FXJA0002", (Expression)this, new EvaluationException("invocation of extension function " + signature.toString(namespaceContext) + "\n throws " + exception, exception));
                }
            } else {
                Object[] objectArray = new Object[signature.argCnt];
                for (int i = 0; i < signature.argCnt; ++i) {
                    objectArray[i] = this.convertArgument(focus, evalContext, signature, i);
                }
                try {
                    if (trace) {
                        System.err.println("calling Java constructor: " + signature.constructor + "\n for " + signature);
                    }
                    Object t = signature.constructor.newInstance(objectArray);
                    return signature.returnType.convertFromObject(t);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    evalContext.error(Function.ERR_ARGTYPE, (Expression)this, "invocation of extension constructor: " + exception);
                }
            }
            return XQValue.empty;
        }

        private Object convertArgument(Focus focus, EvalContext evalContext, Signature signature, int n) throws EvaluationException {
            return signature.argTypes[n].convertToObject(this.args[n], focus, evalContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Signature
    extends Prototype {
        Method method;
        Constructor constructor;
        boolean isStatic;
        boolean ctxArg;

        public Signature(QName qName, XQType xQType, Method method, Constructor<Object> constructor) {
            super(qName, xQType, Call.class);
            this.method = method;
            this.constructor = constructor;
        }

        @Override
        public Function.Call instanciate(Expression[] expressionArray) {
            Call call = (Call)super.instanciate(expressionArray);
            return call;
        }

        @Override
        public String toString() {
            return "JavaFunction " + this.method;
        }
    }

    public static class Plugger
    implements PredefinedModule.FunctionPlugger {
        HashSet<String> allowedClasses = new HashSet();

        public void authorizeClass(String string) {
            if (string == null) {
                this.allowedClasses = null;
            } else {
                if (this.allowedClasses == null) {
                    this.allowedClasses = new HashSet();
                }
                this.allowedClasses.add(string);
            }
        }

        public Function plug(QName qName, PredefinedModule predefinedModule) throws SecurityException {
            String string = qName.getNamespaceURI();
            if (!string.startsWith("java:")) {
                return null;
            }
            String string2 = string.substring(5);
            QName qName2 = null;
            int n = string2.indexOf(63);
            if (n > 0) {
                throw new SecurityException("auto arg0 is deprecated");
            }
            String string3 = qName.getLocalPart();
            int n2 = string3.lastIndexOf(46);
            if (n2 >= 0) {
                string2 = string2 + '.' + string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
            }
            if (this.allowedClasses != null && !this.allowedClasses.contains(string2)) {
                throw new SecurityException("Java extension: security restriction on class " + string2);
            }
            try {
                Signature[] signatureArray;
                Class<?> clazz;
                block19: {
                    clazz = Class.forName(string2);
                    try {
                        signatureArray = clazz.getMethod("plugHook", hookProto);
                        signatureArray.invoke(null, predefinedModule);
                    }
                    catch (Exception exception) {
                        if (!trace) break block19;
                        System.err.println("no hook for " + clazz + " " + exception);
                    }
                }
                int n3 = 0;
                String string4 = Util.camelCase(string3, false);
                if (trace) {
                    System.err.println("found Java class " + clazz + " for function " + string4);
                }
                if (string4.equals("new")) {
                    int n4 = clazz.getModifiers();
                    if (!Modifier.isPublic(n4) || Modifier.isAbstract(n4) || Modifier.isInterface(n4)) {
                        return null;
                    }
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    signatureArray = new Signature[constructorArray.length];
                    for (int i = 0; i < constructorArray.length; ++i) {
                        signatureArray[n3] = JavaFunction.convertConstructor(qName, constructorArray[i]);
                        if (signatureArray[n3] == null) continue;
                        if (trace) {
                            System.err.println("detected constructor " + signatureArray[n3]);
                        }
                        ++n3;
                    }
                } else {
                    Method[] methodArray = clazz.getMethods();
                    signatureArray = new Signature[methodArray.length];
                    for (int i = 0; i < methodArray.length; ++i) {
                        if (!methodArray[i].getName().equals(string4)) continue;
                        signatureArray[n3] = JavaFunction.convertMethod(qName, methodArray[i], qName2);
                        if (signatureArray[n3] == null) continue;
                        if (trace) {
                            System.err.println("detected method " + signatureArray[n3]);
                        }
                        ++n3;
                    }
                }
                if (n3 > 0) {
                    return new JavaFunction(signatureArray, n3);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (trace) {
                    System.err.println("*** class not found " + string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }
    }
}

