/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.StringLiteral;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Matches
extends Function {
    private static Prototype[] protos = new Prototype[]{Prototype.fn("matches", XQType.BOOLEAN.opt, Exec.class).arg("input", (XQType)XQType.STRING.opt).arg("pattern", (XQType)XQType.STRING), Prototype.fn("matches", XQType.BOOLEAN.opt, Exec.class).arg("input", (XQType)XQType.STRING.opt).arg("pattern", (XQType)XQType.STRING).arg("flags", (XQType)XQType.STRING)};

    public Prototype[] getProtos() {
        return protos;
    }

    public static int convertFlags(String string) {
        int n = 1;
        int n2 = string.length();
        while (--n2 >= 0) {
            if (string.charAt(n2) == 'm') {
                n |= 8;
                continue;
            }
            if (string.charAt(n2) == 'i') {
                n |= 0x42;
                continue;
            }
            if (string.charAt(n2) == 's') {
                n |= 0x20;
                continue;
            }
            if (string.charAt(n2) == 'x') {
                n |= 4;
                continue;
            }
            return -1;
        }
        return n;
    }

    public static Pattern precompileRegexp(Expression expression, Expression expression2, boolean bl) {
        if (expression instanceof StringLiteral && (expression2 == null || expression2 instanceof StringLiteral)) {
            try {
                int n;
                String string = ((StringLiteral)expression).value;
                String string2 = "";
                if (expression2 != null) {
                    string2 = ((StringLiteral)expression2).value;
                }
                if ((n = Matches.convertFlags(string2)) < 0) {
                    return null;
                }
                Pattern pattern = Pattern.compile(string, n);
                if (!bl && pattern.matcher("").matches()) {
                    return null;
                }
                return pattern;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Pattern compileRegexp(Expression expression, Expression expression2, boolean bl, Focus focus, EvalContext evalContext) throws EvaluationException {
        String string = expression.evalAsString(focus, evalContext);
        String string2 = expression2 == null ? "" : expression2.evalAsString(focus, evalContext);
        int n = Matches.convertFlags(string2);
        if (n < 0) {
            evalContext.error("FORX0001", expression2, "illegal regular expression flags");
        }
        try {
            Pattern pattern = Pattern.compile(string, n);
            if (!bl && pattern.matcher("").matches()) {
                evalContext.error("FORX0003", expression, "pattern matches empty string");
            }
            return pattern;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            evalContext.error("FORX0002", expression, "invalid regular expression: " + patternSyntaxException.getMessage());
            return null;
        }
    }

    public static class Exec
    extends Function.BoolCall {
        Pattern precompiled = null;

        public void compilationHook() {
            Expression expression = this.args.length < 3 ? null : this.args[2];
            this.precompiled = Matches.precompileRegexp(this.args[1], expression, true);
        }

        public Pattern preparedPattern(EvalContext evalContext) throws EvaluationException {
            Expression expression = this.args.length < 3 ? null : this.args[2];
            return this.precompiled != null ? this.precompiled : Matches.compileRegexp(this.args[1], expression, true, null, evalContext);
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
            String string = this.args[0].evalAsOptString(focus, evalContext);
            if (string == null) {
                string = "";
            }
            evalContext.at(this);
            Pattern pattern = this.preparedPattern(evalContext);
            Matcher matcher = pattern.matcher(string);
            return matcher.find();
        }
    }
}

