/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.NodeFilter;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.NodeType;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.impl.ErrorValue;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.UpdatingExpr;

public class UserFunction
extends Function {
    private static final EvaluationException STACK_OVF = new EvaluationException("XQuery stack overflow");
    protected Signature[] protos = new Signature[1];

    public Prototype[] getProtos() {
        return this.protos;
    }

    public boolean addPrototype(Signature signature) {
        if (this.protos[0] == null) {
            this.protos[0] = signature;
        } else {
            for (int i = 0; i < this.protos.length; ++i) {
                if (this.protos[i].argCnt != signature.argCnt) continue;
                return false;
            }
            Signature[] signatureArray = this.protos;
            this.protos = new Signature[signatureArray.length + 1];
            System.arraycopy(signatureArray, 0, this.protos, 0, signatureArray.length);
            this.protos[signatureArray.length] = signature;
        }
        return true;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) {
        throw new RuntimeException("UserFunction not evaluable");
    }

    public static class Call
    extends Function.Call {
        Signature signature;
        XQType[] argChecks;

        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header(this);
            exprDisplay.property("prototype", this.prototype.toString());
            exprDisplay.property("localSize", "" + this.getLocalSize());
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.argChecks.length; ++i) {
                stringBuilder.append(this.argChecks[i] != null ? "Y," : " ,");
            }
            exprDisplay.property("checks", stringBuilder.toString());
            exprDisplay.children(this.args);
        }

        public XQType getType() {
            if (this.type == null && this.signature.body != null) {
                this.type = XQType.ANY;
                this.type = this.signature.body.getType();
            }
            if (this.type == null) {
                this.type = XQType.ANY;
            }
            return this.type;
        }

        public int getLocalSize() {
            return ((Signature)this.prototype).maxStackSize;
        }

        public int getFlags() {
            return super.getFlags() + (((Signature)this.prototype).updating ? 128 : 0);
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            try {
                EvalContext evalContext2 = this.signature.createContext(focus, evalContext, this.args, this.argChecks);
                XQValue xQValue = this.signature.body.eval(null, evalContext2);
                XQType xQType = this.prototype.declaredReturnType;
                if (xQType != null && (xQValue = xQValue.checkTypeExpand(xQType, evalContext, true, true)) instanceof ErrorValue) {
                    evalContext.error("XPTY0004", (Expression)this, ((ErrorValue)xQValue).getReason());
                }
                return xQValue;
            }
            catch (StackOverflowError stackOverflowError) {
                return evalContext.error(this, STACK_OVF);
            }
        }

        public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            EvalContext evalContext2 = this.signature.createContext(focus, evalContext, this.args, this.argChecks);
            this.signature.body.evalAsEvents(xMLPushStreamBase, null, evalContext2);
        }

        public long evalAsInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            EvalContext evalContext2 = this.signature.createContext(focus, evalContext, this.args, this.argChecks);
            return this.signature.body.evalAsInteger(null, evalContext2);
        }

        public long evalAsOptInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            EvalContext evalContext2 = this.signature.createContext(focus, evalContext, this.args, this.argChecks);
            return this.signature.body.evalAsOptInteger(null, evalContext2);
        }

        public double evalAsDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
            EvalContext evalContext2 = this.signature.createContext(focus, evalContext, this.args, this.argChecks);
            return this.signature.body.evalAsDouble(null, evalContext2);
        }

        public double evalAsOptDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
            EvalContext evalContext2 = this.signature.createContext(focus, evalContext, this.args, this.argChecks);
            return this.signature.body.evalAsOptDouble(null, evalContext2);
        }
    }

    public static class Signature
    extends Prototype {
        public boolean updating;
        public Expression body;
        LocalVariable[] argDecls;
        public int maxStackSize;
        public Expression[] argInit;
        public boolean[] tunnelArg;

        public Signature(QName qName) {
            super(qName, null, Call.class);
            this.argInit = new Expression[this.argNames.length];
            this.tunnelArg = new boolean[this.argNames.length];
        }

        public void arg(QName qName, XQType xQType, Expression expression, boolean bl) {
            super.arg(qName, xQType);
            if (this.argCnt >= this.argInit.length) {
                Expression[] expressionArray = this.argInit;
                this.argInit = new Expression[this.argNames.length];
                System.arraycopy(expressionArray, 0, this.argInit, 0, expressionArray.length);
                boolean[] blArray = this.tunnelArg;
                this.tunnelArg = new boolean[this.argNames.length];
                System.arraycopy(blArray, 0, this.tunnelArg, 0, blArray.length);
            }
            this.argInit[this.argCnt - 1] = expression;
            this.tunnelArg[this.argCnt - 1] = bl;
        }

        public Expression staticCheck(ModuleContext moduleContext, int n) {
            moduleContext.resetLocals();
            this.argDecls = new LocalVariable[this.argCnt];
            for (int i = 0; i < this.argCnt; ++i) {
                QName qName = this.argNames[i];
                int n2 = i;
                while (--n2 >= 0 && this.argNames[n2] != qName) {
                }
                if (n2 >= 0) {
                    this.module.error("XQST0039", this.offset, "duplicate parameter $" + qName);
                }
                this.argDecls[i] = moduleContext.defineLocalVariable(qName, this.argTypes[i], null);
                this.argDecls[i].storageType(this.argTypes[i], moduleContext);
            }
            if (this.body == null) {
                this.module.error("XQST0000", this.offset, "unbound external function " + this.module.prefixedName(this.qname));
                return this;
            }
            this.body = moduleContext.simpleStaticCheck(this.body, 0);
            XQType xQType = this.body.getType();
            if (this.declaredReturnType == null) {
                XQType xQType2 = this.returnType = xQType != null ? xQType : XQType.ANY;
            }
            if (moduleContext.trace) {
                System.err.println("------- allocate register for " + this.qname);
            }
            this.maxStackSize = moduleContext.allocateLocalAddress(null);
            if (UpdatingExpr.isUpdating(this.body) != this.updating) {
                if (this.updating) {
                    if (!UpdatingExpr.isVacuous(this.body)) {
                        moduleContext.error("XUST0002", this.body, "function is declared updating but is not");
                    }
                } else {
                    moduleContext.error("XUST0001", this.body, "function is not declared updating but is");
                }
            }
            return this;
        }

        public Call instanciate(Expression[] expressionArray) {
            int n = expressionArray.length;
            Call call = (Call)super.instanciate(expressionArray);
            call.signature = this;
            call.argChecks = new XQType[n];
            call.module = this.module;
            call.offset = this.offset;
            int n2 = Math.min(n, this.argCnt);
            for (int i = 0; i < n2; ++i) {
                XQType xQType = this.argTypes[i];
                XQType xQType2 = expressionArray[i].getType();
                boolean bl = this.needsDynamicCheck(xQType.itemType());
                if (xQType2.getOccurrence() == 1 && bl) {
                    call.argChecks[i] = xQType;
                }
                if (xQType.getOccurrence() == 2 && !bl) continue;
                call.argChecks[i] = xQType;
            }
            return call;
        }

        protected EvalContext createContext(Focus focus, EvalContext evalContext, Expression[] expressionArray, XQType[] xQTypeArray) throws EvaluationException {
            EvalContext evalContext2 = evalContext.subContext(this);
            for (int i = 0; i < expressionArray.length; ++i) {
                try {
                    evalContext2.storeLocal(this.argDecls[i], expressionArray[i], xQTypeArray[i], true, focus, evalContext);
                    continue;
                }
                catch (EvaluationException evaluationException) {
                    NamespaceContext namespaceContext = evalContext.getStaticContext().getInScopeNS();
                    evalContext.error(evaluationException.getErrorCode(), expressionArray[i], "type mismatch on argument $" + this.argNames[i] + " of function " + this.displayName(namespaceContext) + " : " + evaluationException.getMessage());
                }
            }
            evalContext.at(this);
            return evalContext2;
        }

        public XQValue invoke(Expression[] expressionArray, Expression expression, EvalContext evalContext, Focus focus, EvalContext evalContext2) throws EvaluationException {
            evalContext2.at(expression);
            if (!this.accepts(expressionArray.length)) {
                evalContext2.error("XPTY0004", expression, "invalid number of arguments");
            }
            EvalContext evalContext3 = this.createContext(focus, evalContext2, expressionArray, this.argTypes);
            evalContext3.setClosure(evalContext);
            XQValue xQValue = this.body.eval(null, evalContext3);
            XQType xQType = this.declaredReturnType;
            if (xQType != null && (xQValue = xQValue.checkTypeExpand(xQType, evalContext2, true, true)) instanceof ErrorValue) {
                evalContext2.error("XPTY0004", (Expression)this, ((ErrorValue)xQValue).getReason());
            }
            return xQValue;
        }

        private boolean needsDynamicCheck(XQType xQType) {
            NodeFilter nodeFilter = null;
            return xQType instanceof NodeType && (nodeFilter = ((NodeType)xQType).nodeFilter) != null && !nodeFilter.staticallyCheckable();
        }

        public boolean equals(Object object) {
            if (object instanceof Signature) {
                Signature signature = (Signature)object;
                return signature.qname == this.qname && signature.argCnt == this.argCnt;
            }
            return false;
        }

        public int hashCode() {
            if (this.qname == null) {
                return this.argCnt;
            }
            return this.qname.hashCode() ^ this.argCnt;
        }

        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header("UserFunction");
            exprDisplay.property("signature", this.toString(null));
            exprDisplay.child("body", this.body);
        }
    }
}

