/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.Date;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.dt.MomentValue;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.op.Expression;

public class YearFromDate
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("year-from-date", XQType.INTEGER.opt, Exec.class).arg("op", (XQType)XQType.DATE.opt)};

    public Prototype[] getProtos() {
        return protos;
    }

    public static class Exec
    extends Function.IntegerCall {
        public long evalAsInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            if (xQItem == null) {
                throw EmptyException.instance();
            }
            if (xQItem instanceof MomentValue) {
                MomentValue momentValue = (MomentValue)xQItem;
                return momentValue.getValue().getYear();
            }
            try {
                Date date = Date.parseDate(xQItem.getString());
                return date.getYear();
            }
            catch (DateTimeException dateTimeException) {
                evalContext.error(Conversion.ERR_CAST, (Expression)this, "cannot cast to xs:date : " + dateTimeException.getMessage());
                return 0L;
            }
        }
    }
}

