/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.impl;

import com.qizx.api.CompilationException;
import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.ModuleResolver;
import com.qizx.api.QName;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.Thesaurus;
import com.qizx.queries.FullText;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Util;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.BaseNodeFilter;
import com.qizx.xdm.Conversion;
import com.qizx.xdm.DocumentTest;
import com.qizx.xdm.IQName;
import com.qizx.xdm.NodeFilter;
import com.qizx.xquery.BasicStaticContext;
import com.qizx.xquery.MainQuery;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.ModuleManager;
import com.qizx.xquery.SequenceType;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.dt.FunctionType;
import com.qizx.xquery.dt.LanguageType;
import com.qizx.xquery.dt.NodeType;
import com.qizx.xquery.fn.UserFunction;
import com.qizx.xquery.impl.NewLexer;
import com.qizx.xquery.op.AfterOp;
import com.qizx.xquery.op.AncestorOrSelfStep;
import com.qizx.xquery.op.AncestorStep;
import com.qizx.xquery.op.AndExpr;
import com.qizx.xquery.op.ApplyExpr;
import com.qizx.xquery.op.AssignExpr;
import com.qizx.xquery.op.AtomConstructor;
import com.qizx.xquery.op.AttributeConstructor;
import com.qizx.xquery.op.AttributeStep;
import com.qizx.xquery.op.BeforeOp;
import com.qizx.xquery.op.BlockExpr;
import com.qizx.xquery.op.CastExpr;
import com.qizx.xquery.op.CastableExpr;
import com.qizx.xquery.op.ChildStep;
import com.qizx.xquery.op.DecimalLiteral;
import com.qizx.xquery.op.DeleteExpr;
import com.qizx.xquery.op.DescendantOrSelfStep;
import com.qizx.xquery.op.DescendantStep;
import com.qizx.xquery.op.DivOp;
import com.qizx.xquery.op.DocumentConstructor;
import com.qizx.xquery.op.DoubleLiteral;
import com.qizx.xquery.op.ElementConstructor;
import com.qizx.xquery.op.EqOp;
import com.qizx.xquery.op.ExceptOp;
import com.qizx.xquery.op.ExitExpr;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FLWRExpr;
import com.qizx.xquery.op.FTAndOp;
import com.qizx.xquery.op.FTContainsOp;
import com.qizx.xquery.op.FTMildNotOp;
import com.qizx.xquery.op.FTNotOp;
import com.qizx.xquery.op.FTOrOp;
import com.qizx.xquery.op.FTPosFilters;
import com.qizx.xquery.op.FTSelectionOp;
import com.qizx.xquery.op.FTWordsOp;
import com.qizx.xquery.op.FilterExpr;
import com.qizx.xquery.op.FollowingSiblingStep;
import com.qizx.xquery.op.FollowingStep;
import com.qizx.xquery.op.ForClause;
import com.qizx.xquery.op.FunctionCall;
import com.qizx.xquery.op.FunctionItemCall;
import com.qizx.xquery.op.FunctionLiteral;
import com.qizx.xquery.op.GeOp;
import com.qizx.xquery.op.GlobalVariable;
import com.qizx.xquery.op.GroupingVariable;
import com.qizx.xquery.op.GtOp;
import com.qizx.xquery.op.IDivOp;
import com.qizx.xquery.op.IfExpr;
import com.qizx.xquery.op.InlineFunction;
import com.qizx.xquery.op.InsertExpr;
import com.qizx.xquery.op.InstanceofExpr;
import com.qizx.xquery.op.IntegerLiteral;
import com.qizx.xquery.op.IntersectOp;
import com.qizx.xquery.op.IsNotOp;
import com.qizx.xquery.op.IsOp;
import com.qizx.xquery.op.LeOp;
import com.qizx.xquery.op.LetClause;
import com.qizx.xquery.op.LtOp;
import com.qizx.xquery.op.MinusOp;
import com.qizx.xquery.op.ModOp;
import com.qizx.xquery.op.ModuleImport;
import com.qizx.xquery.op.MulOp;
import com.qizx.xquery.op.NamedConstructor;
import com.qizx.xquery.op.NamespaceConstructor;
import com.qizx.xquery.op.NeOp;
import com.qizx.xquery.op.NegateOp;
import com.qizx.xquery.op.OrExpr;
import com.qizx.xquery.op.OrderSpec;
import com.qizx.xquery.op.PIConstructor;
import com.qizx.xquery.op.ParentStep;
import com.qizx.xquery.op.PathExpr;
import com.qizx.xquery.op.PlusOp;
import com.qizx.xquery.op.Pragma;
import com.qizx.xquery.op.PrecedingSiblingStep;
import com.qizx.xquery.op.PrecedingStep;
import com.qizx.xquery.op.QNameLiteral;
import com.qizx.xquery.op.QuantifiedExpr;
import com.qizx.xquery.op.RangeExpr;
import com.qizx.xquery.op.RenameExpr;
import com.qizx.xquery.op.ReplaceExpr;
import com.qizx.xquery.op.ReverseStep;
import com.qizx.xquery.op.RootStep;
import com.qizx.xquery.op.SchemaContext;
import com.qizx.xquery.op.SelfStep;
import com.qizx.xquery.op.SequenceExpr;
import com.qizx.xquery.op.StringLiteral;
import com.qizx.xquery.op.SwitchExpr;
import com.qizx.xquery.op.TransformExpr;
import com.qizx.xquery.op.TreatExpr;
import com.qizx.xquery.op.TryCatchExpr;
import com.qizx.xquery.op.TypeCaseClause;
import com.qizx.xquery.op.TypeswitchExpr;
import com.qizx.xquery.op.UnionOp;
import com.qizx.xquery.op.Unordered;
import com.qizx.xquery.op.ValidateExpr;
import com.qizx.xquery.op.ValueEqOp;
import com.qizx.xquery.op.ValueGeOp;
import com.qizx.xquery.op.ValueGtOp;
import com.qizx.xquery.op.ValueLeOp;
import com.qizx.xquery.op.ValueLtOp;
import com.qizx.xquery.op.ValueNeOp;
import com.qizx.xquery.op.VarClause;
import com.qizx.xquery.op.VarReference;
import com.qizx.xquery.op.WhileExpr;
import com.qizx.xquery.op.WindowClause;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;

public class NewParser
extends NewLexer {
    public static final String XQUERY_VERSION = "1.1";
    static final String XMLNS = "xmlns";
    private static final QName UNORDERED = IQName.get(NamespaceContext.FN, "unordered");
    private static final String[] PreserveStrip_Keywords = new String[]{"preserve", "strip"};
    private static final String[] Ordering_Keywords = new String[]{"ordered", "unordered"};
    private static final String[] EmptyOrder_Keywords = new String[]{"least", "greatest"};
    private static final String[] CopyNS_Preserve_Keywords = new String[]{"preserve", "no-preserve"};
    private static final String[] CopyNS_Inherit_Keywords = new String[]{"inherit", "no-inherit"};
    private static final String CPF_TEXT = "on full-text expression: should be either inside or outside parentheses";
    private static final int DFLAG_ASSIGNABLE = 1;
    private static final int DFLAG_UNASSIGNABLE = 2;
    private static final int DFLAG_SIMPLE = 4;
    private static final int DFLAG_PUBLIC = 8;
    private static final int DFLAG_PRIVATE = 16;
    private static final int DFLAG_UPDATING = 32;
    private static final int DFLAG_SEQUENTIAL = 64;
    private static final int DFLAG_DETERMINISTIC = 128;
    private static final int DFLAG_UNDETERMINISTIC = 256;
    private static final String COMMA = ", ";
    private static final String SEMICOLON = ";";
    private static final String MORE_VAR = ", $ %Q";
    private ModuleManager moduleManager;
    private Pragma[] pragmas = new Pragma[0];
    private boolean preserveSpace = false;
    private int prologState;
    private HashSet<String> declared = new HashSet();
    private int declFlags;
    private ModuleResolver moduleResolver;
    private int lastTokenStart;
    private StringBuilder textBuf = new StringBuilder();

    public NewParser(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.moduleResolver = moduleManager.getResolver();
    }

    public void parseQuery(MainQuery mainQuery, String string, String string2) throws CompilationException {
        this.currentModule = mainQuery;
        this.startLexer(string);
        this.setupModule(string, string2);
        this.parseOptVersion();
        this.parseNewProlog();
        mainQuery.body = this.parseExpr();
        this.eat(SEMICOLON);
        if (!this.atEndOfInput()) {
            this.syntax("unrecognized characters at end of query");
        }
        this.currentModule.storePragmas(this.pragmas);
    }

    public BasicStaticContext parseModule(ModuleContext moduleContext, String string, String string2) throws CompilationException {
        this.startLexer(string);
        this.currentModule = moduleContext;
        this.setupModule(string, string2);
        this.parseOptVersion();
        this.want("module namespace %N = %S ; ");
        String string3 = this.savedName;
        String string4 = this.extractStringToken();
        this.currentModule.setNamespaceURI(string4);
        this.currentModule.addNamespaceDecl(this.lastTokenStart, string3, string4);
        this.parseNewProlog();
        if (!this.atEndOfInput()) {
            this.syntax("unrecognized characters at end of module");
        }
        this.currentModule.storePragmas(this.pragmas);
        return this.currentModule;
    }

    private void setupModule(String string, String string2) {
        this.currentModule.setSource(string, string2);
    }

    private void parseOptVersion() throws CompilationException {
        if (!this.eat("xquery version %S ")) {
            return;
        }
        String string = this.extractStringToken();
        if (string.compareTo(XQUERY_VERSION) > 0 || string.compareTo("1.0") < 0) {
            this.currentModule.error("XQST0031", this.prevTokenLoc, "XML Query version " + string + " not supported, the current version is " + XQUERY_VERSION);
        }
        if (this.eat("encoding %S ")) {
            String string2 = this.extractStringToken();
            if (!XMLUtil.isNCName(string2)) {
                this.currentModule.error("XQST0087", this.prevTokenLoc, "improper encoding name: " + string2);
            } else {
                this.currentModule.warning(this.prevTokenLoc, "Encoding currently ignored");
            }
        }
        this.want(SEMICOLON);
    }

    private void parseNewProlog() throws CompilationException {
        this.prologState = 0;
        while (true) {
            if (this.eat("declare ")) {
                this.parseDeclFlags();
                this.parseDeclaration();
                continue;
            }
            if (this.eat("import module ")) {
                this.checkPrologState(1, "import module");
                this.parseImportModule();
                continue;
            }
            if (!this.eat("import schema ")) break;
            this.checkPrologState(1, "import schema");
            this.parseImportSchema();
        }
    }

    private void checkPrologState(int n, String string) {
        if (n >= this.prologState) {
            this.prologState = n;
        } else {
            this.currentModule.error("XPST0003", this.tokenStart, string + " declaration may not appear after functions, variables");
        }
    }

    private void parseDeclaration() throws CompilationException {
        if (this.eat("namespace")) {
            this.checkPrologState(1, "namespace");
            this.parseNamespaceDecl();
        } else if (this.eat("default element namespace")) {
            this.checkPrologState(1, "default element namespace ");
            this.parseDefaultNamespaceDecl(false);
        } else if (this.eat("default function namespace")) {
            this.checkPrologState(1, "default function namespace ");
            this.parseDefaultNamespaceDecl(true);
        } else if (this.eat("default order empty")) {
            this.checkPrologState(1, "ordering");
            int n = this.checkOptionKeyword(EmptyOrder_Keywords);
            this.checkDeclared("empty order", "XQST0065");
            this.currentModule.setDefaultOrderEmptyGreatest(n == 1);
        } else if (this.eat("ordering")) {
            this.checkPrologState(1, "ordering");
            int n = this.checkOptionKeyword(Ordering_Keywords);
            this.checkDeclared("ordering", "XQST0065");
            this.currentModule.setOrderingMode(n == 0 ? 11 : 10);
        } else if (this.eat("boundary-space")) {
            this.checkPrologState(1, "boundary-space");
            this.checkDeclared("boundary-space", "XQST0068");
            this.preserveSpace = this.checkOptionKeyword(PreserveStrip_Keywords) == 0;
            this.currentModule.setBoundarySpacePolicy(this.preserveSpace ? 21 : 20);
        } else if (this.eat("construction")) {
            this.checkPrologState(1, "construction");
            int n = this.checkOptionKeyword(PreserveStrip_Keywords);
            this.checkDeclared("construction", "XQST0067");
            this.currentModule.setConstructionMode(n == 0 ? 21 : 20);
        } else if (this.eat("copy-namespaces")) {
            this.checkPrologState(1, "copy-namespaces");
            int n = this.checkOptionKeyword(CopyNS_Preserve_Keywords);
            this.want(COMMA);
            int n2 = this.checkOptionKeyword(CopyNS_Inherit_Keywords);
            this.checkDeclared("copy-namespaces", "XQST0055");
            this.currentModule.setNamespaceInheritMode(n2 == 0 ? 31 : 30);
            this.currentModule.setNamespacePreserveMode(n == 0 ? 21 : 20);
        } else if (this.eat("default collation %S")) {
            this.checkPrologState(1, "default collation");
            String string = this.extractStringToken();
            this.checkDeclared("default collation", "XQST0038");
            try {
                this.currentModule.setDefaultCollation(string);
            }
            catch (DataModelException dataModelException) {
                this.currentModule.error("XQST0038", this.prevTokenLoc, dataModelException.getMessage());
            }
        } else if (this.eat("base-uri %S")) {
            this.checkPrologState(1, "base-uri");
            this.checkDeclared("static base-uri", "XQST0032");
            this.currentModule.setBaseURI(this.extractStringToken());
        } else if (this.eat("revalidation lax") || this.eat("revalidation strict") || this.eat("revalidation skip")) {
            this.currentModule.error("XUST0026", this.tokenStart, "revalidation is not supported");
        } else if (this.eat("ft-option")) {
            this.checkPrologState(1, "full-text option");
            FullText.MatchOptions matchOptions = new FullText.MatchOptions();
            this.parseFTMatchOptions(matchOptions);
            this.currentModule.setDefaultFtOptions(matchOptions);
        } else if (this.eat("option %Q %S")) {
            this.checkPrologState(2, "option");
            IQName iQName = this.resolveQName(null);
            if (iQName.hasNoNamespace()) {
                this.currentModule.error("XPST0081", this.tokenStart, "blank namespace not allowed");
            }
            String string = this.extractStringToken();
            this.currentModule.storeOption(iQName, string);
        } else if (this.eat("variable")) {
            this.checkPrologState(2, "variable");
            this.parseGlobalVarDecl();
        } else if (this.eat("function")) {
            this.checkPrologState(2, "function");
            this.parseFunctionDecl();
        } else {
            this.syntax("expecting declaration");
        }
        this.eat(" ; ");
    }

    private boolean checkDeclared(String string, String string2) {
        if (this.declared.contains(string)) {
            this.currentModule.error(string2, this.prevTokenLoc, string + " already declared");
            return false;
        }
        this.declared.add(string);
        return true;
    }

    private void parseDeclFlags() throws CompilationException {
        this.declFlags = 0;
        while (true) {
            boolean bl = false;
            if (this.eat("assignable")) {
                this.flagAdd(1);
                this.flagConflict(2);
                continue;
            }
            if (this.eat("unassignable")) {
                this.flagAdd(2);
                this.flagConflict(1);
                continue;
            }
            if (this.eat("simple")) {
                this.flagAdd(4);
                continue;
            }
            if (this.eat("updating")) {
                this.flagAdd(32);
                continue;
            }
            if (this.eat("sequential")) {
                this.flagAdd(64);
                continue;
            }
            if (this.eat("public")) {
                this.flagAdd(8);
                this.flagConflict(16);
                continue;
            }
            if (this.eat("private")) {
                this.flagAdd(16);
                this.flagConflict(8);
                continue;
            }
            if (this.eat("deterministic")) {
                this.flagAdd(128);
                this.flagConflict(256);
                continue;
            }
            if (!this.eat("nondeterministic")) break;
            this.flagAdd(256);
            this.flagConflict(128);
        }
    }

    private void flagConflict(int n) {
        if ((this.declFlags & n) != 0) {
            this.currentModule.error("XQST0106", this.prevTokenLoc, "'" + this.lastToken() + "' conflicts with previous indicators");
        }
    }

    private void flagAdd(int n) {
        if ((this.declFlags & n) != 0) {
            this.currentModule.error("XQST0106", this.prevTokenLoc, "duplicate indicator '" + this.lastToken() + "'");
        }
        this.declFlags |= n;
    }

    private String parseNamespaceDecl() throws CompilationException {
        this.want("%N = %S");
        String string = this.savedName;
        String string2 = this.extractStringToken();
        if (string.equals("xml") || string.equals(XMLNS) || string2.equals(NamespaceContext.XML)) {
            this.currentModule.error("XQST0070", this.tokenStart, "illegal namespace declaration");
        }
        this.currentModule.addNamespaceDecl(this.lastTokenStart, string, string2);
        return string2;
    }

    private String parseDefaultNamespaceDecl(boolean bl) throws CompilationException {
        this.want("%S");
        String string = this.extractStringToken();
        if (this.checkDeclared(bl ? "function namespace" : "element namespace", "XQST0066")) {
            this.currentModule.addDefaultNamespace(bl, string);
        }
        return string;
    }

    private void parseGlobalVarDecl() throws CompilationException {
        this.want("$ %Q");
        int n = this.tokenStart;
        IQName iQName = this.resolveVarName();
        String string = this.currentModule.getNamespaceURI();
        if (string != NamespaceContext.LOCAL_NS && string != iQName.getNamespaceURI()) {
            this.currentModule.error("XQST0048", this.prevTokenLoc, "namespace of variable name " + this.currentModule.prefixedName(iQName) + " should match the module namespace");
        }
        SequenceType sequenceType = null;
        if (this.eat("as ")) {
            sequenceType = this.parseSequenceType();
        }
        Expression expression = null;
        if (!this.eat("external")) {
            if (this.eat(":=")) {
                expression = this.parseExprSingle();
            } else {
                this.want("{");
                expression = this.parseEnclosedExpr();
            }
        }
        GlobalVariable globalVariable = new GlobalVariable(iQName, sequenceType, expression);
        this.currentModule.addDeclaration(this.locate(globalVariable, n));
    }

    private UserFunction parseFunctionDecl() throws CompilationException {
        UserFunction userFunction;
        this.want("%Q (");
        IQName iQName = this.resolveQName(this.currentModule.getDefaultFunctionNamespace());
        String string = iQName.getNamespaceURI();
        if (string == NamespaceContext.EMPTY) {
            this.currentModule.error("XQST0060", this.prevTokenLoc, "function name has no namespace: " + iQName);
        }
        if (this.currentModule.getNamespaceURI() == NamespaceContext.LOCAL_NS) {
            if (string == NamespaceContext.FN || string == NamespaceContext.XSD || string == NamespaceContext.XML || string == NamespaceContext.XSI) {
                this.currentModule.error("XQST0045", this.prevTokenLoc, "illegal namespace for function " + this.currentModule.prefixedName(iQName));
            }
        } else if (string != this.currentModule.getNamespaceURI()) {
            this.currentModule.error("XQST0048", this.prevTokenLoc, "namespace of function name " + this.currentModule.prefixedName(iQName) + " does not match module namespace");
        }
        if ((userFunction = (UserFunction)this.currentModule.localFunctionLookup(iQName)) == null) {
            userFunction = new UserFunction();
        }
        UserFunction.Signature signature = new UserFunction.Signature(iQName);
        signature.module = this.currentModule;
        signature.offset = this.prevTokenLoc;
        signature.updating = (this.declFlags & 0x20) != 0;
        this.currentModule.declareFunction(iQName, userFunction);
        this.currentModule.addDeclaration(signature);
        this.parseFunctionProto(signature);
        if (!userFunction.addPrototype(signature)) {
            this.currentModule.error("XQST0034", signature.offset, "duplicate prototype for function '" + iQName + "'");
        }
        Expression expression = null;
        if (!this.eat("external")) {
            this.want("{");
            expression = this.parseEnclosedExpr();
        }
        signature.body = expression;
        this.want(SEMICOLON);
        return userFunction;
    }

    private void parseFunctionProto(UserFunction.Signature signature) throws CompilationException {
        if (!this.eat(")")) {
            do {
                this.want("$ %Q");
                IQName iQName = this.resolveVarName();
                XQType xQType = XQType.ANY;
                if (this.eat("as ")) {
                    xQType = this.parseSequenceType();
                }
                signature.arg(iQName, xQType);
            } while (this.eat(COMMA));
            this.want(")");
        }
        if (this.eat("as ")) {
            signature.returnType = signature.declaredReturnType = this.parseSequenceType();
        }
    }

    private void parseImportModule() throws CompilationException {
        int n = this.tokenStart;
        String string = null;
        String string2 = null;
        int n2 = n;
        if (this.eat("namespace %N = ")) {
            n2 = this.tokenStart;
            string = this.savedName;
        }
        if (!this.eatStringLiteral()) {
            this.errorExpect("namespace URI");
        }
        String string3 = this.extractStringToken();
        ArrayList<String> arrayList = null;
        if (this.eat("at %S")) {
            string2 = this.extractStringToken();
            arrayList = new ArrayList<String>();
            arrayList.add(string2);
            while (this.eat(", %S")) {
                string2 = this.extractStringToken();
                arrayList.add(string2);
            }
        }
        this.eat(SEMICOLON);
        this.moduleImport(n, string3, arrayList);
        if (string != null) {
            this.currentModule.addNamespaceDecl(n2, string, string3);
        }
    }

    private void parseImportSchema() throws CompilationException {
        int n = this.tokenStart;
        String string = "";
        if (this.eat("default element namespace")) {
            string = this.parseDefaultNamespaceDecl(false);
        } else if (this.eat("namespace %?%N")) {
            string = this.parseNamespaceDecl();
        } else if (this.eat("%S")) {
            string = this.extractStringToken();
            this.currentModule.addDefaultNamespace(false, string);
        } else {
            this.syntax("improper schema import");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.eat("at %S")) {
            arrayList.add(this.extractStringToken());
            while (this.eat(", %S")) {
                arrayList.add(this.extractStringToken());
            }
        }
        this.eat(SEMICOLON);
        this.currentModule.error("XQST0009", n, "schema import is not supported");
    }

    private Expression parseExpr() throws CompilationException {
        Expression expression = this.parseExprSeq();
        if (!this.eat(SEMICOLON)) {
            return expression;
        }
        ApplyExpr applyExpr = new ApplyExpr();
        this.locate(applyExpr);
        applyExpr.addExpr(expression);
        while (!(this.atEndOfInput() || this.see(")") || this.see("]") || this.see("}"))) {
            applyExpr.addExpr(this.parseExprSeq());
            this.want(SEMICOLON);
        }
        return applyExpr;
    }

    private Expression parseExprSeq() throws CompilationException {
        Expression expression = this.parseExprSingle();
        if (!this.eat(COMMA)) {
            return expression;
        }
        SequenceExpr sequenceExpr = new SequenceExpr();
        this.locate(sequenceExpr);
        sequenceExpr.addExpr(expression);
        sequenceExpr.addExpr(this.parseExprSingle());
        while (this.eat(COMMA)) {
            sequenceExpr.addExpr(this.parseExprSingle());
        }
        return sequenceExpr;
    }

    private Expression parseExprSingle() throws CompilationException {
        if (this.eat("for $ %Q")) {
            return this.parseFLWRExpr(this.parseForClause(true));
        }
        if (this.eat("let $ %Q")) {
            return this.parseFLWRExpr(this.parseLetClause(false));
        }
        if (this.eat("let score $ %Q")) {
            return this.parseFLWRExpr(this.parseLetClause(true));
        }
        if (this.eat("for tumbling window $ %Q")) {
            return this.parseFLWRExpr(this.parseWindowClause(false));
        }
        if (this.eat("for sliding window $ %Q")) {
            return this.parseFLWRExpr(this.parseWindowClause(true));
        }
        if (this.eat("every $ %Q")) {
            return this.parseQuantifiedExpr(true);
        }
        if (this.eat("some $ %Q")) {
            return this.parseQuantifiedExpr(false);
        }
        if (this.eat("if (")) {
            return this.parseIfExpr();
        }
        if (this.eat("typeswitch (")) {
            return this.parseTypeswitchExpr();
        }
        if (this.eat("switch (")) {
            return this.parseSwitchExpr();
        }
        if (this.eat("block {")) {
            return this.parseBlock();
        }
        if (this.eat("exit returning")) {
            return this.parseExitExpr();
        }
        if (this.eat("while (")) {
            return this.parseWhileExpr();
        }
        if (this.eat("insert nodes") || this.eat("insert node")) {
            return this.parseInsertNodes();
        }
        if (this.eat("delete nodes") || this.eat("delete node")) {
            return this.parseDeleteNodes();
        }
        if (this.eat("replace node")) {
            return this.parseReplaceNode(false);
        }
        if (this.eat("replace value of node")) {
            return this.parseReplaceNode(true);
        }
        if (this.eat("rename node")) {
            return this.parseRenameNode();
        }
        if (this.eat("copy $ %Q")) {
            return this.parseTransform();
        }
        Expression expression = this.parseOrExpr();
        if (this.eat(":=")) {
            return this.parseAssign2(expression);
        }
        return expression;
    }

    private Expression parseFLWRExpr(VarClause varClause) throws CompilationException {
        FLWRExpr fLWRExpr = new FLWRExpr();
        this.locate(fLWRExpr, varClause.offset);
        fLWRExpr.addClause(varClause);
        if (this.eat(MORE_VAR)) {
            if (varClause instanceof ForClause) {
                fLWRExpr.addClause(this.parseForClause(true));
                while (this.eat(MORE_VAR)) {
                    fLWRExpr.addClause(this.parseForClause(true));
                }
            } else if (varClause instanceof LetClause) {
                LetClause letClause = (LetClause)varClause;
                fLWRExpr.addClause(this.parseLetClause(letClause.score));
                while (this.eat(MORE_VAR)) {
                    fLWRExpr.addClause(this.parseLetClause(letClause.score));
                }
            } else {
                this.syntax("unexpected comma");
            }
        }
        boolean bl = false;
        block2: while (true) {
            if (this.eat("for $ %Q")) {
                fLWRExpr.addClause(this.parseForClause(true));
                while (true) {
                    if (!this.eat(MORE_VAR)) continue block2;
                    fLWRExpr.addClause(this.parseForClause(true));
                }
            }
            if (this.eat("let $ %Q")) {
                if (bl) {
                    fLWRExpr.addPostLetClause(this.parseLetClause(false));
                } else {
                    fLWRExpr.addClause(this.parseLetClause(false));
                }
                while (true) {
                    if (!this.eat(MORE_VAR)) continue block2;
                    if (bl) {
                        fLWRExpr.addPostLetClause(this.parseLetClause(false));
                        continue;
                    }
                    fLWRExpr.addClause(this.parseLetClause(false));
                }
            }
            if (this.eat("let score $ %Q")) {
                fLWRExpr.addClause(this.parseLetClause(true));
                while (true) {
                    if (!this.eat(COMMA)) continue block2;
                    fLWRExpr.addClause(this.parseLetClause(true));
                }
            }
            if (this.eat("for tumbling window $ %Q")) {
                fLWRExpr.addClause(this.parseWindowClause(false));
                continue;
            }
            if (this.eat("for sliding window $ %Q")) {
                fLWRExpr.addClause(this.parseWindowClause(true));
                continue;
            }
            if (this.eat("where")) {
                if (bl) {
                    fLWRExpr.postGroupingWhere = this.parseExprSingle();
                    continue;
                }
                fLWRExpr.where = this.parseExprSingle();
                continue;
            }
            if (this.eat("group by")) {
                GroupingVariable groupingVariable = this.parseGroupBySpec();
                fLWRExpr.groupingKeys = new GroupingVariable[]{groupingVariable};
                fLWRExpr.postGroupingLets = new LetClause[0];
                while (this.eat(COMMA)) {
                    groupingVariable = this.parseGroupBySpec();
                    GroupingVariable[] groupingVariableArray = fLWRExpr.groupingKeys;
                    fLWRExpr.groupingKeys = new GroupingVariable[groupingVariableArray.length + 1];
                    System.arraycopy(groupingVariableArray, 0, fLWRExpr.groupingKeys, 0, groupingVariableArray.length);
                    fLWRExpr.groupingKeys[groupingVariableArray.length] = groupingVariable;
                }
                bl = true;
                continue;
            }
            fLWRExpr.stableOrder = this.eat("stable order by");
            if (fLWRExpr.stableOrder || this.eat("order by")) {
                fLWRExpr.addOrderSpec(this.parseOrderSpec());
                while (true) {
                    if (!this.eat(COMMA)) continue block2;
                    fLWRExpr.addOrderSpec(this.parseOrderSpec());
                }
            }
            if (!this.eat("count $ %Q")) break;
        }
        this.want("return");
        fLWRExpr.expr = this.parseExprSingle();
        return fLWRExpr;
    }

    private ForClause parseForClause(boolean bl) throws CompilationException {
        int n = this.tokenStart;
        ForClause forClause = new ForClause(this.resolveVarName());
        this.locate(forClause, n);
        if (this.eat("as")) {
            forClause.declaredType = this.parseSequenceType();
        }
        if (bl && this.eat("at $ %Q")) {
            forClause.position = this.resolveVarName();
        }
        if (this.eat("score $ %Q")) {
            forClause.score = this.resolveVarName();
        }
        this.want("in");
        forClause.expr = this.parseExprSingle();
        return forClause;
    }

    private LetClause parseLetClause(boolean bl) throws CompilationException {
        int n = this.tokenStart;
        LetClause letClause = new LetClause(this.resolveVarName());
        letClause.score = bl;
        this.locate(letClause, n);
        if (this.eat("as")) {
            if (bl) {
                this.currentModule.error("XPST0003", this.prevTokenLoc, "invalid type declaration after 'score'");
            }
            letClause.declaredType = this.parseSequenceType();
        }
        this.want(":=");
        letClause.expr = this.parseExprSingle();
        return letClause;
    }

    private VarClause parseWindowClause(boolean bl) throws CompilationException {
        int n = this.tokenStart;
        IQName iQName = this.resolveVarName();
        WindowClause windowClause = new WindowClause(iQName, bl);
        this.locate(windowClause, n);
        if (this.eat("as")) {
            windowClause.declaredType = this.parseSequenceType();
        }
        this.want("in");
        windowClause.expr = this.parseExprSingle();
        this.want("start");
        this.parseWindowCond(windowClause.startCond);
        if (this.eat("only end")) {
            windowClause.onlyEnd = true;
            this.parseWindowCond(windowClause.endCond);
        } else if (this.eat("end")) {
            this.parseWindowCond(windowClause.endCond);
        } else if (!bl) {
            windowClause.endCond = null;
        } else {
            this.errorExpect("end condition");
        }
        return windowClause;
    }

    private void parseWindowCond(WindowClause.Condition condition) throws CompilationException {
        if (this.eat("$ %Q")) {
            condition.itemVarName = this.resolveVarName();
        }
        if (this.eat("at $ %Q")) {
            condition.atVarName = this.resolveVarName();
        }
        if (this.eat("previous $ %Q")) {
            condition.previousVarName = this.resolveVarName();
        }
        if (this.eat("next $ %Q")) {
            condition.nextVarName = this.resolveVarName();
        }
        this.want("when");
        condition.cond = this.parseExprSingle();
    }

    private OrderSpec parseOrderSpec() throws CompilationException {
        int n = this.currentPos();
        OrderSpec orderSpec = new OrderSpec(this.parseExprSingle());
        this.locate(orderSpec, n);
        if (this.eat("descending")) {
            orderSpec.descending = true;
        } else {
            this.eat("ascending");
        }
        orderSpec.emptyGreatest = this.currentModule.getDefaultOrderEmptyGreatest();
        if (this.eat("empty greatest")) {
            orderSpec.emptyGreatest = true;
        } else if (this.eat("empty least")) {
            orderSpec.emptyGreatest = false;
        }
        if (this.eat("collation %S")) {
            orderSpec.collation = this.extractStringToken();
        }
        return orderSpec;
    }

    private GroupingVariable parseGroupBySpec() throws CompilationException {
        this.want("$ %Q");
        IQName iQName = this.resolveVarName();
        String string = null;
        if (this.eat("collation %S")) {
            string = this.extractStringToken();
        }
        GroupingVariable groupingVariable = new GroupingVariable(iQName, string);
        this.locate2(groupingVariable);
        return groupingVariable;
    }

    private Expression parseQuantifiedExpr(boolean bl) throws CompilationException {
        QuantifiedExpr quantifiedExpr = new QuantifiedExpr(bl);
        this.locate(quantifiedExpr);
        quantifiedExpr.addVarClause(this.parseForClause(false));
        while (this.eat(MORE_VAR)) {
            quantifiedExpr.addVarClause(this.parseForClause(false));
        }
        this.want("satisfies");
        quantifiedExpr.cond = this.parseExprSingle();
        return quantifiedExpr;
    }

    private Expression parseSwitchExpr() throws CompilationException {
        SwitchExpr.Case case_;
        int n = this.tokenStart;
        SwitchExpr switchExpr = new SwitchExpr(this.parseExpr());
        this.locate(switchExpr, n);
        this.want(")");
        while (this.eat("case")) {
            case_ = new SwitchExpr.Case();
            this.locate2(case_);
            switchExpr.addCase(case_);
            case_.key = this.parseExprSingle();
            if (!this.eat("return")) continue;
            case_.expr = this.parseExprSingle();
        }
        this.want("default");
        case_ = new SwitchExpr.Case();
        this.locate2(case_);
        this.want("return");
        case_.expr = this.parseExprSingle();
        switchExpr.addCase(case_);
        return switchExpr;
    }

    private Expression parseTypeswitchExpr() throws CompilationException {
        TypeCaseClause typeCaseClause;
        int n = this.tokenStart;
        TypeswitchExpr typeswitchExpr = new TypeswitchExpr(this.parseExpr());
        this.locate(typeswitchExpr, n);
        this.want(")");
        while (this.eat("case ")) {
            typeCaseClause = new TypeCaseClause();
            this.locate2(typeCaseClause);
            typeswitchExpr.addCaseClause(typeCaseClause);
            if (this.eat("$ %Q as")) {
                typeCaseClause.variable = this.resolveVarName();
            }
            typeCaseClause.declaredType = this.parseSequenceType();
            this.want("return");
            typeCaseClause.expr = this.parseExprSingle();
        }
        this.want("default");
        typeCaseClause = new TypeCaseClause();
        this.locate2(typeCaseClause);
        typeswitchExpr.addCaseClause(typeCaseClause);
        if (this.eat("$ %Q")) {
            typeCaseClause.variable = this.resolveVarName();
        }
        this.want("return");
        typeCaseClause.expr = this.parseExprSingle();
        return typeswitchExpr;
    }

    private Expression parseWhileExpr() throws CompilationException {
        int n = this.tokenStart;
        Expression expression = this.parseExprSingle();
        this.want(") {");
        Expression expression2 = this.parseBlock();
        return this.locate(new WhileExpr(expression, expression2), n);
    }

    private Expression parseBlock() throws CompilationException {
        BlockExpr blockExpr = new BlockExpr();
        this.locate(blockExpr, this.prevTokenLoc);
        while (this.eat("declare")) {
            blockExpr.addClause(this.parseBlockVar());
            while (this.eat(COMMA)) {
                blockExpr.addClause(this.parseBlockVar());
            }
            this.want(SEMICOLON);
        }
        blockExpr.body = this.parseExpr();
        this.want("}");
        return blockExpr;
    }

    private LetClause parseBlockVar() throws CompilationException {
        int n = this.currentPos();
        this.want("$ %Q");
        LetClause letClause = new LetClause(this.resolveVarName());
        this.locate(letClause, n);
        if (this.eat("as")) {
            letClause.declaredType = this.parseSequenceType();
        }
        if (this.eat(":=")) {
            letClause.expr = this.parseExprSingle();
        }
        return letClause;
    }

    private Expression parseAssign2(Expression expression) throws CompilationException {
        int n = this.tokenStart;
        if (expression instanceof VarReference) {
            VarReference varReference = (VarReference)expression;
            return this.locate(new AssignExpr(varReference.name, this.parseExprSingle()), n);
        }
        this.syntax("invalid left handside of assignment");
        return null;
    }

    private Expression parseExitExpr() throws CompilationException {
        int n = this.tokenStart;
        Expression expression = this.parseExprSingle();
        return this.locate(new ExitExpr(expression), n);
    }

    private Expression parseIfExpr() throws CompilationException {
        int n = this.tokenStart;
        Expression expression = this.parseExpr();
        this.want(")");
        this.want("then");
        Expression expression2 = this.parseExprSingle();
        this.want("else");
        return this.locate(new IfExpr(expression, expression2, this.parseExprSingle()), n);
    }

    private Expression parseOrExpr() throws CompilationException {
        Expression expression = this.parseAndExpr();
        if (!this.eat("or")) {
            return expression;
        }
        OrExpr orExpr = new OrExpr(expression);
        this.locate(orExpr);
        orExpr.addExpr(this.parseAndExpr());
        while (this.eat("or")) {
            orExpr.addExpr(this.parseAndExpr());
        }
        return orExpr;
    }

    private Expression parseAndExpr() throws CompilationException {
        Expression expression = this.parseComparisonExpr();
        if (!this.eat("and")) {
            return expression;
        }
        AndExpr andExpr = new AndExpr(expression);
        this.locate(andExpr);
        andExpr.addExpr(this.parseComparisonExpr());
        while (this.eat("and")) {
            andExpr.addExpr(this.parseComparisonExpr());
        }
        return andExpr;
    }

    private Expression parseComparisonExpr() throws CompilationException {
        Expression expression = this.parseFTContainsExpr();
        while (true) {
            this.eatSpace();
            int n = this.currentPos();
            if (this.eat("lt")) {
                expression = new ValueLtOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("le")) {
                expression = new ValueLeOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("eq")) {
                expression = new ValueEqOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("ne")) {
                expression = new ValueNeOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("gt")) {
                expression = new ValueGtOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("ge")) {
                expression = new ValueGeOp(expression, this.parseFTContainsExpr());
            } else if (this.eat(">=")) {
                expression = new GeOp(expression, this.parseFTContainsExpr());
            } else if (this.eat(">>")) {
                expression = new AfterOp(expression, this.parseFTContainsExpr());
            } else if (this.eat(">")) {
                expression = new GtOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("<<")) {
                expression = new BeforeOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("<=")) {
                expression = new LeOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("<")) {
                expression = new LtOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("=")) {
                expression = new EqOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("!=")) {
                expression = new NeOp(expression, this.parseFTContainsExpr());
            } else if (this.eat("is not")) {
                expression = new IsNotOp(expression, this.parseFTContainsExpr());
            } else {
                if (!this.eat("is")) break;
                expression = new IsOp(expression, this.parseFTContainsExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    private Expression parseFTContainsExpr() throws CompilationException {
        Expression expression = this.parseRangeExpr();
        if (this.eat("ftcontains") || this.eat("contains text")) {
            FTContainsOp fTContainsOp = new FTContainsOp(expression, this.parseFTSelection());
            expression = fTContainsOp;
            if (this.eat("without content")) {
                fTContainsOp.ignore = this.parseUnionExpr();
            }
        }
        return expression;
    }

    private Expression parseRangeExpr() throws CompilationException {
        Expression expression = this.parseAdditiveExpr();
        if (this.eat("to")) {
            int n = this.tokenStart;
            expression = new RangeExpr(expression, this.parseAdditiveExpr());
            this.locate(expression, n);
        }
        return expression;
    }

    private Expression parseAdditiveExpr() throws CompilationException {
        Expression expression = this.parseMultiplicativeExpr();
        while (true) {
            int n = this.currentPos();
            if (this.eat("+")) {
                expression = new PlusOp(expression, this.parseMultiplicativeExpr());
            } else {
                if (!this.eat("-")) break;
                expression = new MinusOp(expression, this.parseMultiplicativeExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseMultiplicativeExpr() throws CompilationException {
        Expression expression = this.parseUnionExpr();
        while (true) {
            int n = this.currentPos();
            if (this.eat("*")) {
                expression = new MulOp(expression, this.parseUnionExpr());
            } else if (this.eat("div")) {
                expression = new DivOp(expression, this.parseUnionExpr());
            } else if (this.eat("idiv")) {
                expression = new IDivOp(expression, this.parseUnionExpr());
            } else {
                if (!this.eat("mod")) break;
                expression = new ModOp(expression, this.parseUnionExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseUnionExpr() throws CompilationException {
        Expression expression = this.parseIntersectExceptExpr();
        while (this.eat("union") || this.eat("|")) {
            int n = this.prevTokenLoc;
            expression = new UnionOp(expression, this.parseIntersectExceptExpr());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseIntersectExceptExpr() throws CompilationException {
        Expression expression = this.parseInstanceofExpr();
        while (true) {
            int n = this.currentPos();
            if (this.eat("intersect")) {
                expression = new IntersectOp(expression, this.parseInstanceofExpr());
            } else {
                if (!this.eat("except")) break;
                expression = new ExceptOp(expression, this.parseInstanceofExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseInstanceofExpr() throws CompilationException {
        Expression expression = this.parseTreatExpr();
        int n = this.currentPos();
        if (this.eat("instance of")) {
            expression = new InstanceofExpr(expression, this.parseSequenceType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseTreatExpr() throws CompilationException {
        Expression expression = this.parseCastableExpr();
        int n = this.currentPos();
        if (this.eat("treat as")) {
            expression = new TreatExpr(expression, this.parseSequenceType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseCastableExpr() throws CompilationException {
        Expression expression = this.parseCastExpr();
        int n = this.currentPos();
        if (this.eat("castable as")) {
            expression = new CastableExpr(expression, this.parseSingleType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseCastExpr() throws CompilationException {
        Expression expression = this.parseUnaryExpr();
        if (this.eat("cast as")) {
            int n = this.tokenStart;
            expression = new CastExpr(expression, this.parseSingleType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseUnaryExpr() throws CompilationException {
        if (this.eat("-")) {
            int n = this.tokenStart;
            return this.locate(new NegateOp(this.parseUnaryExpr()), n);
        }
        if (this.eat("+")) {
            Expression expression = this.parseUnaryExpr();
            if (expression instanceof StringLiteral) {
                this.currentModule.error("XPTY0004", this.tokenStart, "improper operand type for +");
            }
            return expression;
        }
        return this.parseValueExpr();
    }

    Expression parseValueExpr() throws CompilationException {
        if (this.eat("try {")) {
            return this.parseTryCatchExpr();
        }
        if (this.eat("validate %? %N") || this.eat("validate %? {")) {
            return this.parseValidateExpr();
        }
        if (this.eatPragma()) {
            Object object;
            do {
                object = this.checkPragma();
            } while (this.eatPragma());
            this.want("{");
            object = this.parseExpr();
            this.want("}");
            return object;
        }
        return this.parsePathExpr();
    }

    private QName checkPragma() throws CompilationException {
        String string = this.expandPrefix(this.savedPrefix);
        if (string == NamespaceContext.EMPTY) {
            this.currentModule.error("XPST0081", this.tokenEnd + 3, "blank namespace not allowed for extension");
        }
        return IQName.get(string, this.savedName);
    }

    Expression parseTryCatchExpr() throws CompilationException {
        int n = this.tokenStart;
        Expression expression = this.parseEnclosedExpr();
        this.want("catch");
        TryCatchExpr tryCatchExpr = null;
        if (this.eat("( $ %Q")) {
            IQName iQName = this.resolveVarName();
            this.want(") {");
            tryCatchExpr = new TryCatchExpr(expression, iQName, this.parseEnclosedExpr());
        } else {
            TryCatchExpr.Catch catch_ = this.parseCatch();
            tryCatchExpr = new TryCatchExpr(expression, catch_);
            while (this.eat("catch")) {
                catch_ = this.parseCatch();
                tryCatchExpr.addCatch(catch_);
            }
        }
        return this.locate(tryCatchExpr, n);
    }

    private TryCatchExpr.Catch parseCatch() throws CompilationException {
        int n = this.tokenStart;
        BaseNodeFilter baseNodeFilter = this.parseNameTest(false, false);
        TryCatchExpr.Catch catch_ = new TryCatchExpr.Catch(baseNodeFilter);
        this.locate(catch_, n);
        while (this.eat("|")) {
            baseNodeFilter = this.parseNameTest(false, false);
            catch_.addTest(baseNodeFilter);
        }
        if (this.eat("( $ %Q")) {
            catch_.codeVarName = this.resolveVarName();
            if (this.eat(MORE_VAR)) {
                catch_.descVarName = this.resolveVarName();
                if (this.eat(MORE_VAR)) {
                    catch_.valueVarName = this.resolveVarName();
                }
            }
            this.want(")");
        }
        this.want("{");
        catch_.handler = this.parseEnclosedExpr();
        return catch_;
    }

    Expression parsePathExpr() throws CompilationException {
        int n = this.currentPos();
        boolean bl = false;
        boolean bl2 = false;
        if (this.eat("//")) {
            bl2 = true;
            bl = true;
        } else if (this.eat("/")) {
            bl = true;
        }
        Expression expression = this.parseStepExpr();
        PathExpr pathExpr = null;
        if (bl || expression instanceof ReverseStep) {
            pathExpr = new PathExpr();
            this.locate(pathExpr, n);
            if (bl) {
                pathExpr.addStep(this.locate(new RootStep(null), n));
            }
            if (bl2) {
                if (expression != null) {
                    pathExpr.addStep(this.locate(new DescendantOrSelfStep(null), n));
                } else {
                    this.syntax("unterminated path '//'");
                }
            }
            if (expression != null) {
                pathExpr.addStep(expression);
            }
        } else if (expression == null) {
            this.syntax("expecting expression");
        }
        if (!this.see("/")) {
            return pathExpr != null ? pathExpr : expression;
        }
        if (pathExpr == null) {
            pathExpr = new PathExpr();
            this.locate(pathExpr, n);
            pathExpr.addStep(expression);
        }
        while (true) {
            if (this.eat("//")) {
                pathExpr.addStep(this.locate(new DescendantOrSelfStep(null), n));
            } else if (!this.eat("/")) break;
            expression = this.parseStepExpr();
            if (expression == null) {
                this.syntax("unterminated path expression");
            }
            pathExpr.addStep(expression);
        }
        this.locate(pathExpr, n);
        return pathExpr;
    }

    Expression parseStepExpr() throws CompilationException {
        Object object;
        Expression expression = null;
        this.eatSpace();
        int n = this.currentPos();
        if (this.eat("..")) {
            expression = new ParentStep(null);
        } else if (!this.see("%u") && this.eat(".")) {
            expression = new SelfStep(null);
        } else if (this.eat("ancestor ::")) {
            expression = new AncestorStep(this.parseNodeTest(false));
        } else if (this.eat("ancestor-or-self ::")) {
            expression = new AncestorOrSelfStep(this.parseNodeTest(false));
        } else if (this.eat("attribute ::")) {
            expression = new AttributeStep(this.parseNodeTest(true));
        } else if (this.eat("@")) {
            expression = new AttributeStep(this.parseNameTest(true, false));
        } else if (this.eat("child ::")) {
            expression = new ChildStep(this.parseNodeTest(false));
        } else if (this.eat("descendant ::")) {
            expression = new DescendantStep(this.parseNodeTest(false));
        } else if (this.eat("descendant-or-self ::")) {
            expression = new DescendantOrSelfStep(this.parseNodeTest(false));
        } else if (this.eat("following-sibling ::")) {
            expression = new FollowingSiblingStep(this.parseNodeTest(false));
        } else if (this.eat("following ::")) {
            expression = new FollowingStep(this.parseNodeTest(false));
        } else if (this.eat("self ::")) {
            expression = new SelfStep(this.parseNodeTest(false));
        } else if (this.eat("parent ::")) {
            expression = new ParentStep(this.parseNodeTest(false));
        } else if (this.eat("preceding-sibling ::")) {
            expression = new PrecedingSiblingStep(this.parseNodeTest(false));
        } else if (this.eat("preceding ::")) {
            expression = new PrecedingStep(this.parseNodeTest(false));
        } else {
            expression = this.parsePrimaryExpr();
            if (expression == null) {
                object = this.parseNodeTest(false, true);
                if (object == null) {
                    return null;
                }
                expression = new ChildStep((NodeFilter)object);
            }
        }
        if (expression != null) {
            this.locate(expression, n);
        }
        Object object2 = object = expression instanceof FilterExpr ? (FilterExpr)expression : null;
        while (true) {
            if (this.eat("[")) {
                n = this.tokenStart;
                if (object == null) {
                    object = new FilterExpr(expression);
                }
                ((FilterExpr)object).addPredicate(this.parseExpr());
                this.locate((Expression)object, n);
                this.want("]");
                continue;
            }
            if (!this.eat("(")) break;
            FunctionItemCall functionItemCall = new FunctionItemCall(expression);
            this.locate(functionItemCall, this.tokenStart);
            if (!this.eat(")")) {
                functionItemCall.addArgument(this.parseExprSingle());
                while (this.eat(COMMA)) {
                    functionItemCall.addArgument(this.parseExprSingle());
                }
                this.want(")");
            }
            object = null;
            expression = functionItemCall;
        }
        return object == null ? expression : object;
    }

    Expression parseValidateExpr() throws CompilationException {
        int n = this.tokenStart;
        int n2 = -1;
        IQName iQName = null;
        if (this.eat("as %Q")) {
            iQName = this.resolveElementName();
        } else if (this.eat("lax")) {
            n2 = 1;
        } else if (this.eat("strict")) {
            n2 = 2;
        }
        this.want("{");
        Expression expression = this.parseExpr();
        this.want("}");
        expression = new ValidateExpr(n2, iQName, expression);
        this.locate(expression, n);
        return expression;
    }

    Expression parsePrimaryExpr() throws CompilationException {
        int n = this.currentPos();
        if (this.eatNumber()) {
            switch (this.numberToken) {
                case 1: {
                    return this.locate(new IntegerLiteral(this.makeInteger()));
                }
                case 2: {
                    return this.locate(new DecimalLiteral(this.makeDecimal()));
                }
                case 3: {
                    return this.locate(new DoubleLiteral(this.makeNumber()));
                }
            }
        } else if (this.eatStringLiteral()) {
            return this.locate(new StringLiteral(this.extractStringToken()));
        }
        if (this.see("item (") || this.see("node (") || this.see("document-node (") || this.see("element (") || this.see("text (") || this.see("attribute (") || this.see("processing-instruction (") || this.see("comment (")) {
            return null;
        }
        if (this.eat("function (")) {
            n = this.tokenStart;
            return this.locate(this.parseLambdaFunction(), n);
        }
        if (this.eat("%Q (")) {
            return this.parseFunctionCall();
        }
        if (this.eat("%Q # %u")) {
            return this.parseFunctionLiteral();
        }
        if (this.eat("$ %Q")) {
            return this.locate2(new VarReference(this.resolveVarName()));
        }
        if (this.eat("(")) {
            return this.parseParenthesizedExpr();
        }
        if (this.eat("ordered {") || this.eat("unordered {")) {
            Expression expression = this.parseExpr();
            this.want("}");
            return expression;
        }
        if (this.eat("<%Q")) {
            return this.parseElementConstructor();
        }
        if (this.eatXmlComment()) {
            return this.newCommentConstructor();
        }
        if (this.eatPI()) {
            return this.locate2(new PIConstructor(this.extractStringToken()));
        }
        if (this.eat("text {")) {
            AtomConstructor atomConstructor = new AtomConstructor(7, this.parseExpr());
            this.want("}");
            return this.locate(atomConstructor, n);
        }
        if (this.eat("document {")) {
            DocumentConstructor documentConstructor = new DocumentConstructor(this.parseExpr());
            this.want("}");
            return this.locate(documentConstructor, n);
        }
        if (this.eat("element {")) {
            Expression expression = this.parseExpr();
            this.want("} {");
            return this.parseNamedConstructorBody(n, new ElementConstructor(expression));
        }
        if (this.eat("element %Q {")) {
            Expression expression = this.parseNamedConstructorName(true);
            return this.parseNamedConstructorBody(n, new ElementConstructor(expression));
        }
        if (this.eat("attribute {")) {
            Expression expression = this.parseExpr();
            this.want("} {");
            return this.parseNamedConstructorBody(n, new AttributeConstructor(expression));
        }
        if (this.eat("attribute %Q {")) {
            Expression expression = this.parseNamedConstructorName(false);
            return this.parseNamedConstructorBody(n, new AttributeConstructor(expression));
        }
        if (this.eat("comment {")) {
            Expression expression = this.parseExpr();
            this.want("}");
            return this.locate(new AtomConstructor(6, expression), n);
        }
        if (this.eat("namespace {")) {
            Expression expression = this.parseExpr();
            this.want("} {");
            Expression expression2 = this.parseExpr();
            this.want("}");
            return this.locate(new NamespaceConstructor(expression, expression2), n);
        }
        if (this.eat("namespace %N {")) {
            StringLiteral stringLiteral = new StringLiteral(this.savedName);
            Expression expression = this.parseExpr();
            this.want("}");
            return this.locate(new NamespaceConstructor(stringLiteral, expression), n);
        }
        if (this.eat("processing-instruction {")) {
            Expression expression = this.parseExpr();
            Expression expression3 = null;
            this.want("} {");
            if (!this.eat("}")) {
                expression3 = this.parseExpr();
                this.want("}");
            }
            return this.locate(new PIConstructor(expression, expression3), n);
        }
        if (this.eat("processing-instruction %N {")) {
            String string = this.savedName;
            Expression expression = this.parseExpr();
            this.want("}");
            return this.locate(new PIConstructor(new StringLiteral(string), expression), n);
        }
        return null;
    }

    Expression parseParenthesizedExpr() throws CompilationException {
        if (this.eat(")")) {
            return new SequenceExpr();
        }
        Expression expression = this.parseExpr();
        this.want(")");
        return expression;
    }

    Expression parseFunctionCall() throws CompilationException {
        int n = this.tokenStart;
        IQName iQName = this.resolveQName(this.currentModule.getDefaultFunctionNamespace());
        FunctionCall functionCall = new FunctionCall(iQName);
        this.locate(functionCall, n);
        if (!this.eat(")")) {
            functionCall.addArgument(this.parseExprSingle());
            while (this.eat(COMMA)) {
                functionCall.addArgument(this.parseExprSingle());
            }
            this.want(")");
        }
        if (iQName == UNORDERED) {
            if (functionCall.getArgCount() != 1) {
                this.currentModule.error("XPST0017", n, "unordered wants exactly 1 argument");
            }
            return this.locate(new Unordered(functionCall.child(0)), n);
        }
        return functionCall;
    }

    private Expression parseFunctionLiteral() throws CompilationException {
        IQName iQName = this.resolveQName(this.currentModule.getDefaultFunctionNamespace());
        return new FunctionLiteral(iQName, this.makeInteger());
    }

    private Expression parseLambdaFunction() throws CompilationException {
        UserFunction.Signature signature = new UserFunction.Signature(null);
        signature.module = this.currentModule;
        signature.offset = this.tokenStart;
        this.parseFunctionProto(signature);
        this.want("{");
        signature.body = this.parseEnclosedExpr();
        return new InlineFunction(signature);
    }

    XQItemType checkTypeName(QName qName) {
        XQItemType xQItemType = this.currentModule.lookForType(qName);
        if (xQItemType == null) {
            this.currentModule.error("XPST0051", this.prevTokenLoc, "unknown type " + this.currentModule.prefixedName(qName));
            return XQType.ITEM;
        }
        if (!XQType.ATOM.accepts(xQItemType)) {
            this.currentModule.error("XPTY0004", this.prevTokenLoc, "non atomic type " + this.currentModule.prefixedName(qName));
        }
        return xQItemType;
    }

    XQType parseSingleType() throws CompilationException {
        this.want("%Q");
        XQItemType xQItemType = this.checkTypeName(this.resolveElementName());
        return this.eat("?") ? xQItemType.opt : xQItemType;
    }

    SequenceType parseSequenceType() throws CompilationException {
        if (this.eat("empty-sequence ( )")) {
            return XQType.NONE.opt;
        }
        XQItemType xQItemType = this.parseItemType();
        if (this.eat("*")) {
            return xQItemType.star;
        }
        if (this.eat("+")) {
            return xQItemType.plus;
        }
        if (this.eat("?")) {
            return xQItemType.opt;
        }
        return xQItemType.one;
    }

    XQItemType parseItemType() throws CompilationException {
        if (this.eat("item ( )")) {
            return XQType.ITEM;
        }
        if (this.eat("function (")) {
            if (this.eat("* )")) {
                return new FunctionType(null);
            }
            UserFunction.Signature signature = new UserFunction.Signature(null);
            if (!this.eat(")")) {
                do {
                    SequenceType sequenceType = this.parseSequenceType();
                    signature.arg((QName)null, (XQType)sequenceType);
                } while (this.eat(COMMA));
                this.want(")");
            }
            if (this.eat("as ")) {
                signature.returnType = signature.declaredReturnType = this.parseSequenceType();
            }
            return new FunctionType(signature);
        }
        if (this.see("%N (")) {
            NodeFilter nodeFilter = this.parseNodeTest(false);
            return new NodeType(nodeFilter);
        }
        if (this.eat("%Q")) {
            XQItemType xQItemType = this.checkTypeName(this.resolveElementName());
            return xQItemType;
        }
        this.syntax("expect type");
        return null;
    }

    NodeFilter parseNodeTest() throws CompilationException {
        return this.parseNodeTest(false);
    }

    NodeFilter parseNodeTest(boolean bl) throws CompilationException {
        return this.parseNodeTest(bl, false);
    }

    NodeFilter parseNodeTest(boolean bl, boolean bl2) throws CompilationException {
        this.eatSpace();
        int n = this.currentPos();
        if (this.eat("document-node (")) {
            BaseNodeFilter baseNodeFilter = null;
            if (!this.eat(")")) {
                this.want("element (");
                baseNodeFilter = this.parseElemAttrTest(false);
                this.want(")");
            }
            if (baseNodeFilter == null) {
                baseNodeFilter = new BaseNodeFilter(2, null, null);
            }
            return this.locate(n, new DocumentTest(baseNodeFilter));
        }
        if (this.eat("element (")) {
            return this.locate(n, this.parseElemAttrTest(false));
        }
        if (this.eat("attribute (")) {
            return this.locate(n, this.parseElemAttrTest(true));
        }
        if (this.eat("text ( )")) {
            return this.locate(n, new BaseNodeFilter(7, null, null));
        }
        if (this.eat("comment ( )")) {
            return this.locate(n, new BaseNodeFilter(6, null, null));
        }
        if (this.eat("processing-instruction (")) {
            String string = null;
            if (this.eatStringLiteral()) {
                string = this.extractStringToken();
            } else if (this.eat("%N")) {
                string = this.savedName;
            }
            this.want(")");
            return this.locate(n, new BaseNodeFilter(5, null, string));
        }
        if (this.eat("node ( )")) {
            return new BaseNodeFilter(-1, null, null);
        }
        return this.parseNameTest(bl, bl2);
    }

    BaseNodeFilter parseElemAttrTest(boolean bl) throws CompilationException {
        QName qName;
        String string = null;
        String string2 = null;
        SchemaContext schemaContext = null;
        this.eatSpace();
        if (!this.see(")") && !this.eat("*") && (schemaContext = this.parseSchemaContextPath(bl)).isSimpleName()) {
            qName = schemaContext.getStep(0);
            schemaContext = null;
            string = qName.getNamespaceURI();
            string2 = qName.getLocalPart();
        }
        if (schemaContext == null && this.eat(COMMA)) {
            qName = this.parseStarName();
            schemaContext = new SchemaContext(true);
            this.locate2(schemaContext);
            schemaContext.addStep(qName);
            if (qName != null && qName.getNamespaceURI() != NamespaceContext.XSD) {
                schemaContext.module.error("XPST0001", schemaContext.offset, "undefined type " + qName);
            }
            if (qName == XQType.ANY.getName()) {
                schemaContext = null;
            }
        }
        this.want(")");
        if (schemaContext != null) {
            this.currentModule.warning("XPST0008", schemaContext.offset, "Schema Type test not supported");
        }
        return new BaseNodeFilter(bl ? 3 : 2, string, string2, schemaContext);
    }

    QName parseStarName() throws CompilationException {
        if (this.eat("%Q")) {
            return this.resolveElementName();
        }
        if (this.eat("*")) {
            return null;
        }
        this.syntax("expecting name or '*'");
        return null;
    }

    BaseNodeFilter parseNameTest(boolean bl, boolean bl2) throws CompilationException {
        int n = this.currentPos();
        String string = bl ? "" : this.currentModule.getDefaultElementNamespace();
        int n2 = bl ? 3 : 2;
        BaseNodeFilter baseNodeFilter = null;
        if (this.eat("* : %N")) {
            baseNodeFilter = new BaseNodeFilter(n2, null, this.savedName);
        } else if (this.eat("*")) {
            baseNodeFilter = new BaseNodeFilter(n2, null, null);
        } else if (this.eat("%N : *")) {
            baseNodeFilter = new BaseNodeFilter(n2, this.expandPrefix(this.extractStringToken(), string), null);
        } else if (this.eat("%Q")) {
            baseNodeFilter = new BaseNodeFilter(n2, this.expandPrefix(this.savedPrefix, string), this.savedName);
        } else {
            if (!bl2) {
                this.syntax("expecting name test");
            }
            return null;
        }
        this.locate(n, baseNodeFilter);
        return baseNodeFilter;
    }

    SchemaContext parseSchemaContext() throws CompilationException {
        if (this.eat("global")) {
            return null;
        }
        if (this.eat("context")) {
            return this.parseSchemaContextPath(false);
        }
        this.syntax("expecting schema context");
        return null;
    }

    SchemaContext parseSchemaContextPath(boolean bl) throws CompilationException {
        SchemaContext schemaContext = new SchemaContext(false);
        String string = bl ? null : this.currentModule.getDefaultElementNamespace();
        this.want("%Q");
        schemaContext.addStep(this.resolveQName(string));
        while (this.eat("/")) {
            if (this.eat("%Q")) {
                schemaContext.addStep(this.resolveQName(string));
                continue;
            }
            schemaContext.endsWithSlash = true;
            break;
        }
        return schemaContext;
    }

    private Expression parseNamedConstructorName(boolean bl) throws CompilationException {
        String string = "";
        if (bl || this.savedPrefix.length() > 0) {
            string = this.expandPrefix(this.savedPrefix);
        }
        IQName iQName = IQName.get(string, this.savedName);
        QNameLiteral qNameLiteral = new QNameLiteral(iQName);
        this.locate(qNameLiteral, this.tokenStart);
        return qNameLiteral;
    }

    private Expression parseNamedConstructorBody(int n, NamedConstructor namedConstructor) throws CompilationException {
        if (!this.eat("}")) {
            namedConstructor.addItem(this.parseExpr());
            this.want("}");
        }
        return this.locate(namedConstructor, n);
    }

    private Expression newCommentConstructor() throws CompilationException {
        return this.locate2(new AtomConstructor(6, new StringLiteral(this.extractStringToken())));
    }

    ElementConstructor parseElementConstructor() throws CompilationException {
        Object object;
        int n = this.tokenStart;
        String string = this.savedPrefix;
        String string2 = this.savedName;
        ElementConstructor elementConstructor = new ElementConstructor(null);
        elementConstructor.setDirect();
        this.locate(elementConstructor, n);
        NamespaceContext namespaceContext = this.currentModule.getInScopeNS();
        namespaceContext.newLevel();
        this.setSkipSpace(true);
        this.allowComments = false;
        while (this.eat("%Q =")) {
            this.parseAttribute(elementConstructor);
        }
        String string3 = this.expandPrefix(string);
        IQName iQName = IQName.get(string3, string2);
        elementConstructor.name = new QNameLiteral(iQName);
        this.locate(elementConstructor.name, n);
        int n2 = elementConstructor.attributes.size();
        for (int i = 0; i < n2; ++i) {
            object = elementConstructor.getAttribute(i);
            if (object instanceof NamespaceConstructor) continue;
            String string4 = ((AttributeConstructor)object).prefix.length() == 0 ? "" : this.expandPrefix(((AttributeConstructor)object).prefix);
            ((AttributeConstructor)object).name = new QNameLiteral(IQName.get(string4, ((AttributeConstructor)object).value));
            ((AttributeConstructor)object).value = null;
            ((AttributeConstructor)object).prefix = null;
        }
        if (this.eat("/>")) {
            this.allowComments = true;
            namespaceContext.popLevel();
            return elementConstructor;
        }
        this.want(">");
        this.setSkipSpace(false);
        this.allowComments = true;
        this.whiteSpace = true;
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            n = this.tokenStart;
            n2 = 0;
            stringBuilder.setLength(0);
            while (true) {
                if (this.eatXmlChars('\u0000')) {
                    if (!this.whiteSpace) {
                        n2 = 1;
                    }
                    stringBuilder.append((CharSequence)this.saveBuffer);
                    continue;
                }
                if (!this.eatCDATASection() && !this.eatCharRef()) break;
                stringBuilder.append((CharSequence)this.saveBuffer);
                n2 = 1;
            }
            if (this.preserveSpace || n2 != 0) {
                this.locate(elementConstructor.addTextItem(stringBuilder.toString()), n);
            }
            if (this.eat("{")) {
                this.setSkipSpace(true);
                elementConstructor.addItem(this.parseEnclosedExpr());
                this.setSkipSpace(false);
                continue;
            }
            if (this.eat("<%Q")) {
                elementConstructor.addItem(this.parseElementConstructor());
                continue;
            }
            if (this.eatXmlComment()) {
                elementConstructor.addItem(this.newCommentConstructor());
                continue;
            }
            if (this.eatPI()) {
                elementConstructor.addItem(this.locate2(new PIConstructor(this.extractStringToken())));
                continue;
            }
            if (this.eatNoSkip("</%Q")) break;
            this.syntax("invalid element content");
        }
        String string5 = this.savedPrefix;
        if (!string.equals(string5)) {
            this.currentModule.error("XPST0003", this.tokenStart, "mismatched prefix on end-tag: must be equal to start tag prefix");
        }
        string2 = this.extractStringToken();
        string3 = this.expandPrefix(string5);
        object = IQName.get(string3 == null ? "" : string3, string2);
        if (object != iQName) {
            this.syntax("tag mismatch: " + object + " encountered when expecting " + iQName);
        }
        this.setSkipSpace(true);
        this.allowComments = false;
        this.want(">");
        namespaceContext.popLevel();
        this.allowComments = true;
        return elementConstructor;
    }

    private boolean parseAttribute(ElementConstructor elementConstructor) throws CompilationException {
        AttributeConstructor attributeConstructor = new AttributeConstructor(null);
        attributeConstructor.prefix = this.savedPrefix;
        attributeConstructor.value = this.extractStringToken();
        this.locate(attributeConstructor);
        this.parseAttributeValue(attributeConstructor);
        String string = null;
        if (attributeConstructor.prefix.equals(XMLNS)) {
            string = attributeConstructor.value;
        } else if (attributeConstructor.prefix.length() == 0 && attributeConstructor.value.equals(XMLNS)) {
            string = "";
        }
        if (string == null) {
            elementConstructor.addAttribute(attributeConstructor);
            return true;
        }
        if (attributeConstructor.contents.length != 1 || !(attributeConstructor.contents[0] instanceof StringLiteral)) {
            attributeConstructor.module.error("XQST0022", attributeConstructor.offset, "namespaces must have a literal value");
        } else {
            if ("xml".equals(string) || XMLNS.equals(string)) {
                attributeConstructor.module.error("XQST0070", attributeConstructor.offset, "reserved namespace prefix");
            }
            String string2 = ((StringLiteral)attributeConstructor.contents[0]).value;
            this.currentModule.getInScopeNS().addMapping(string, string2);
            NamespaceConstructor namespaceConstructor = new NamespaceConstructor(string, string2);
            this.locate2(namespaceConstructor);
            elementConstructor.addAttribute(namespaceConstructor);
        }
        return false;
    }

    private void parseAttributeValue(AttributeConstructor attributeConstructor) throws CompilationException {
        String string = null;
        this.eatSpace();
        if (this.eatRaw("\"")) {
            string = "\"";
        } else if (this.eatRaw("'")) {
            string = "'";
        } else {
            this.syntax("bad attribute delimiter");
        }
        while (this.curChar != '\u0000') {
            if (this.eatRaw(string)) {
                if (!this.eatRaw(string)) break;
                attributeConstructor.addTextItem(string);
                continue;
            }
            if (this.eatXmlChars(string.charAt(0))) {
                String string2 = this.extractStringToken();
                this.locate(attributeConstructor.addTextItem(XMLUtil.replaceWhiteSpace(string2)));
                continue;
            }
            if (this.eatCharRef()) {
                this.locate(attributeConstructor.addTextItem(this.extractStringToken()));
                continue;
            }
            if (this.eat("{")) {
                attributeConstructor.addItem(this.parseEnclosedExpr());
                continue;
            }
            this.syntax("invalid attribute content");
        }
        if (attributeConstructor.contents.length == 0) {
            attributeConstructor.addTextItem("");
        }
    }

    Expression parseEnclosedExpr() throws CompilationException {
        Expression expression = this.parseExpr();
        this.want("}");
        return expression;
    }

    private FTSelectionOp parseFTSelection() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTOr();
        FTPosFilters fTPosFilters = this.parseFTPosFilters(fTSelectionOp);
        if (fTPosFilters != null) {
            if (fTSelectionOp.posFilters == null) {
                fTSelectionOp.posFilters = fTPosFilters;
            } else {
                this.currentModule.error("XPTY0004", (Expression)fTSelectionOp, "conflicting position filters on full-text expression: should be either inside or outside parentheses");
            }
        }
        if (this.eat("weight")) {
            if (fTSelectionOp.weight != null) {
                this.currentModule.error("XPTY0004", (Expression)fTSelectionOp, "conflicting weight on full-text expression: should be either inside or outside parentheses");
            }
            if (this.currentModule.sObs()) {
                this.want("{");
                fTSelectionOp.weight = this.parseRangeExpr();
                this.want("}");
            } else {
                boolean bl = this.eat("{");
                fTSelectionOp.weight = this.parseRangeExpr();
                if (bl) {
                    this.want("}");
                }
            }
        }
        return fTSelectionOp;
    }

    private FTSelectionOp parseFTOr() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTAnd();
        if (!this.eat("ftor")) {
            return fTSelectionOp;
        }
        FTOrOp fTOrOp = new FTOrOp(fTSelectionOp);
        fTOrOp.addChild(this.parseFTAnd());
        this.locate(fTOrOp);
        while (this.eat("ftor")) {
            fTOrOp.addChild(this.parseFTAnd());
        }
        return fTOrOp;
    }

    private FTSelectionOp parseFTAnd() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTMildNot();
        if (!this.eat("ftand")) {
            return fTSelectionOp;
        }
        FTAndOp fTAndOp = new FTAndOp(fTSelectionOp);
        fTAndOp.addChild(this.parseFTMildNot());
        this.locate(fTAndOp);
        while (this.eat("ftand")) {
            fTAndOp.addChild(this.parseFTMildNot());
        }
        return fTAndOp;
    }

    private FTSelectionOp parseFTMildNot() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTNot();
        if (this.eat("not in")) {
            int n = this.tokenStart;
            fTSelectionOp = new FTMildNotOp(fTSelectionOp, this.parseFTNot());
            this.locate(fTSelectionOp, n);
        }
        return fTSelectionOp;
    }

    private FTSelectionOp parseFTNot() throws CompilationException {
        int n = this.tokenStart;
        if (this.eat("ftnot")) {
            FTNotOp fTNotOp = new FTNotOp(this.parseFTPrimaryWithOptions());
            this.locate(fTNotOp, n);
            return fTNotOp;
        }
        return this.parseFTPrimaryWithOptions();
    }

    private FTSelectionOp parseFTPrimaryWithOptions() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTPrimary();
        if (fTSelectionOp.matchOptions == null) {
            fTSelectionOp.matchOptions = new FullText.MatchOptions();
        }
        this.parseFTMatchOptions(fTSelectionOp.matchOptions);
        if (fTSelectionOp.matchOptions.likeDefault()) {
            fTSelectionOp.matchOptions = null;
        }
        return fTSelectionOp;
    }

    private FTSelectionOp parseFTPrimary() throws CompilationException {
        if (this.eatPragma()) {
            Object object;
            do {
                object = this.checkPragma();
            } while (this.eatPragma());
            this.want("{");
            object = this.parseFTSelection();
            this.want("}");
            return object;
        }
        if (this.eat("(")) {
            FTSelectionOp fTSelectionOp = this.parseFTSelection();
            this.want(")");
            return fTSelectionOp;
        }
        FTWordsOp fTWordsOp = null;
        if (this.eat("{")) {
            fTWordsOp = new FTWordsOp(this.parseExpr());
            this.want("}");
        } else if (this.eatStringLiteral()) {
            fTWordsOp = new FTWordsOp(this.makeStringLiteral());
        } else {
            this.syntax("expecting literal string or '{' or '('");
        }
        if (this.eat("any word")) {
            fTWordsOp.anyAll = 1;
        } else if (this.eat("any")) {
            fTWordsOp.anyAll = 0;
        } else if (this.eat("all words")) {
            fTWordsOp.anyAll = 3;
        } else if (this.eat("all")) {
            fTWordsOp.anyAll = 2;
        } else if (this.eat("phrase")) {
            fTWordsOp.anyAll = 4;
        }
        if (this.eat("occurs")) {
            fTWordsOp.occs = this.parseFTRange();
            this.want("times");
        }
        return fTWordsOp;
    }

    private FTPosFilters parseFTPosFilters(FTSelectionOp fTSelectionOp) throws CompilationException {
        FTPosFilters fTPosFilters = new FTPosFilters(false);
        HashSet hashSet = new HashSet();
        while (true) {
            if (this.eat("ordered")) {
                this.checkOption(hashSet, "ordered");
                fTPosFilters.ordered = true;
                continue;
            }
            if (this.eat("window")) {
                this.checkOption(hashSet, "window");
                fTPosFilters.windowExpr = this.parseAdditiveExpr();
                fTPosFilters.windowUnit = this.parseDistanceUnit();
                if (fTPosFilters.windowUnit == 1) continue;
                this.currentModule.error("FTST0003", (Expression)fTSelectionOp, "unsupported full-text window unit");
                continue;
            }
            if (this.eat("distance")) {
                this.checkOption(hashSet, "distance");
                fTPosFilters.distance = this.parseFTRange();
                fTPosFilters.distanceUnit = this.parseDistanceUnit();
                if (fTPosFilters.distanceUnit == 1) continue;
                this.currentModule.error("FTST0003", (Expression)fTSelectionOp, "unsupported full-text distance unit");
                continue;
            }
            if (this.eat("same sentence")) {
                this.checkOption(hashSet, "scope");
                fTPosFilters.scope = 1;
                continue;
            }
            if (this.eat("same paragraph")) {
                this.checkOption(hashSet, "scope");
                fTPosFilters.scope = 2;
                continue;
            }
            if (this.eat("different paragraph")) {
                this.checkOption(hashSet, "scope");
                fTPosFilters.scope = 3;
                continue;
            }
            if (this.eat("different sentence")) {
                this.checkOption(hashSet, "scope");
                fTPosFilters.scope = 4;
                continue;
            }
            if (this.eat("at start")) {
                this.checkOption(hashSet, "anchor");
                fTPosFilters.content = 1;
                continue;
            }
            if (this.eat("at end")) {
                this.checkOption(hashSet, "anchor");
                fTPosFilters.content = 2;
                continue;
            }
            if (!this.eat("entire content")) break;
            this.checkOption(hashSet, "anchor");
            fTPosFilters.content = 3;
        }
        if (fTPosFilters.scope != 0) {
            this.currentModule.error("FTST0004", (Expression)fTSelectionOp, "unsupported full-text feature 'same' / 'different'");
        }
        return hashSet.isEmpty() ? null : fTPosFilters;
    }

    private int parseDistanceUnit() throws CompilationException {
        if (this.eat("words")) {
            return 1;
        }
        if (this.eat("sentences")) {
            return 2;
        }
        if (this.eat("paragraphs")) {
            return 3;
        }
        this.syntax("expect 'words', 'sentences' or 'paragraphs'");
        return -1;
    }

    private void parseFTMatchOptions(FullText.MatchOptions matchOptions) throws CompilationException {
        HashSet hashSet = new HashSet();
        block0: while (true) {
            int n = this.currentPos();
            if (this.eat("using language %S") || this.eat("language %S")) {
                this.checkOption(hashSet, "language");
                matchOptions.language = this.extractStringToken();
                if (((LanguageType)XQType.LANGUAGE).checkValue(matchOptions.language)) continue;
                this.currentModule.error("FTST0013", n, "invalid language " + matchOptions.language);
                continue;
            }
            if (this.eat("using case sensitive") || this.eat("case sensitive")) {
                this.checkOption(hashSet, "case");
                matchOptions.caseSensitivity = 1;
                continue;
            }
            if (this.eat("using case insensitive") || this.eat("case insensitive")) {
                this.checkOption(hashSet, "case");
                matchOptions.caseSensitivity = (byte)2;
                continue;
            }
            if (this.eat("using lowercase") || this.eat("lowercase")) {
                this.checkOption(hashSet, "case");
                matchOptions.caseSensitivity = (byte)3;
                continue;
            }
            if (this.eat("using uppercase") || this.eat("uppercase")) {
                this.checkOption(hashSet, "case");
                matchOptions.caseSensitivity = (byte)4;
                continue;
            }
            if (this.eat("using diacritics sensitive") || this.eat("diacritics sensitive")) {
                this.checkOption(hashSet, "diacritics");
                matchOptions.diacritics = 1;
                continue;
            }
            if (this.eat("using diacritics insensitive") || this.eat("diacritics insensitive")) {
                this.checkOption(hashSet, "diacritics");
                matchOptions.diacritics = (byte)2;
                continue;
            }
            if (this.eat("using wildcards") || this.eat("with wildcards")) {
                this.checkOption(hashSet, "wildcards");
                matchOptions.wildcards = 1;
                continue;
            }
            if (this.eat("using no wildcards") || this.eat("without wildcards")) {
                this.checkOption(hashSet, "wildcards");
                matchOptions.wildcards = (byte)2;
                continue;
            }
            if (this.eat("using stemming") || this.eat("with stemming")) {
                this.checkOption(hashSet, "stemming");
                matchOptions.stemming = 1;
                continue;
            }
            if (this.eat("using no stemming") || this.eat("without stemming")) {
                this.checkOption(hashSet, "stemming");
                matchOptions.stemming = (byte)2;
                continue;
            }
            if (this.eat("using thesaurus") || this.eat("with thesaurus")) {
                this.checkOption(hashSet, "thesaurus");
                if (this.eat("(")) {
                    this.parseThesaurus(matchOptions);
                    while (this.eat(COMMA)) {
                        this.parseThesaurus(matchOptions);
                    }
                    this.want(")");
                    continue;
                }
                this.parseThesaurus(matchOptions);
                continue;
            }
            if (this.eat("using no thesaurus") || this.eat("without thesaurus")) {
                this.checkOption(hashSet, "thesaurus");
                continue;
            }
            if (this.eat("using no stop words")) {
                this.checkOption(hashSet, "stopwords");
                continue;
            }
            if (this.eat("using stop words")) {
                this.checkOption(hashSet, "stopwords");
                this.currentModule.error("FTST0008", this.tokenStart, "stop-words are not supported");
                this.parseStopWords(matchOptions.language);
                while (true) {
                    if (this.eat("union")) {
                        this.parseStopWords(matchOptions.language);
                        continue;
                    }
                    if (!this.eat("except")) continue block0;
                    this.parseStopWords(matchOptions.language);
                }
            }
            if (this.eat("using default stop words")) {
                this.checkOption(hashSet, "stopwords");
                this.currentModule.error("FTST0008", this.tokenStart, "stop-words are not supported");
                while (true) {
                    if (this.eat("union")) {
                        this.parseStopWords(matchOptions.language);
                        continue;
                    }
                    if (!this.eat("except")) continue block0;
                    this.parseStopWords(matchOptions.language);
                }
            }
            if (!this.eat("using option %Q %S")) break;
            IQName iQName = this.resolveVarName();
        }
    }

    private void parseStopWords(String string) throws CompilationException {
        if (this.eat("at %S")) {
            String string2 = this.extractStringToken();
        } else {
            this.want("( %S");
            String string3 = this.extractStringToken();
            while (this.eat(", %S")) {
                string3 = this.extractStringToken();
            }
            this.want(")");
        }
    }

    private void parseThesaurus(FullText.MatchOptions matchOptions) throws CompilationException {
        RangeExpr rangeExpr;
        if (this.eat("default")) {
            matchOptions.addThesaurus(this.getThesaurus("default", null, null, null));
            return;
        }
        if (!this.eat("at %S")) {
            this.syntax("expecting thesaurus URI");
        }
        String string = this.extractStringToken();
        String string2 = null;
        if (this.eat("relationship %S")) {
            string2 = this.extractStringToken();
        }
        if ((rangeExpr = this.parseFTRange()) != null) {
            this.want("levels");
        }
        matchOptions.addThesaurus(this.getThesaurus(string, matchOptions.language, string2, rangeExpr));
    }

    private Thesaurus getThesaurus(String string, String string2, String string3, RangeExpr rangeExpr) {
        Thesaurus thesaurus;
        FullTextFactory fullTextFactory = this.currentModule.getFulltextFactory();
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        if (rangeExpr != null) {
            if (rangeExpr.lower != null) {
                n = this.evalConstantLevel(rangeExpr.lower);
            }
            if (rangeExpr.upper != null) {
                n2 = this.evalConstantLevel(rangeExpr.upper);
            }
        }
        if ((thesaurus = fullTextFactory.getThesaurus(string, string2, string3, n, n2)) == null) {
            this.currentModule.error("FTST0008", this.tokenStart, "unreachable thesaurus '" + string + "'");
        }
        return thesaurus;
    }

    private int evalConstantLevel(Expression expression) {
        Expression expression2 = this.currentModule.evalConstantExpr(expression);
        if (!(expression2 instanceof IntegerLiteral)) {
            this.currentModule.error("FTST0008", this.prevTokenLoc, "only constant bounds accepted for thesaurus level");
            return 0;
        }
        return (int)((IntegerLiteral)expression2).value;
    }

    private RangeExpr parseFTRange() throws CompilationException {
        RangeExpr rangeExpr = new RangeExpr(null, null);
        if (this.eat("exactly")) {
            rangeExpr.lower = rangeExpr.upper = this.parseAdditiveExpr();
        } else if (this.eat("at least")) {
            rangeExpr.lower = this.parseAdditiveExpr();
        } else if (this.eat("at most")) {
            rangeExpr.upper = this.parseAdditiveExpr();
        } else if (this.eat("from")) {
            rangeExpr.lower = this.parseAdditiveExpr();
            this.want(" to");
            rangeExpr.upper = this.parseAdditiveExpr();
        } else {
            return null;
        }
        return rangeExpr;
    }

    private void checkOption(HashSet hashSet, String string) {
        if (hashSet.contains(string)) {
            this.currentModule.error("FTST0019", this.tokenStart, "duplicate " + string + " option");
        }
        hashSet.add(string);
    }

    private InsertExpr parseInsertNodes() throws CompilationException {
        InsertExpr insertExpr = new InsertExpr();
        this.locate(insertExpr);
        insertExpr.what = this.parseExprSingle();
        if (this.eat("into")) {
            insertExpr.mode = 1;
        } else if (this.eat("as first into")) {
            insertExpr.mode = 2;
        } else if (this.eat("as last into")) {
            insertExpr.mode = 3;
        } else if (this.eat("before")) {
            insertExpr.mode = 4;
        } else if (this.eat("after")) {
            insertExpr.mode = 5;
        } else {
            this.syntax("invalid insertion mode: expecting 'into' or 'as' or 'before' or 'after'");
        }
        insertExpr.where = this.parseExprSingle();
        return insertExpr;
    }

    private Expression parseDeleteNodes() throws CompilationException {
        DeleteExpr deleteExpr = new DeleteExpr();
        this.locate(deleteExpr);
        deleteExpr.where = this.parseExprSingle();
        return deleteExpr;
    }

    private ReplaceExpr parseReplaceNode(boolean bl) throws CompilationException {
        ReplaceExpr replaceExpr = new ReplaceExpr();
        this.locate(replaceExpr);
        replaceExpr.mode = bl ? 1 : 0;
        replaceExpr.where = this.parseExprSingle();
        this.want("with");
        replaceExpr.what = this.parseExprSingle();
        return replaceExpr;
    }

    private RenameExpr parseRenameNode() throws CompilationException {
        RenameExpr renameExpr = new RenameExpr();
        this.locate(renameExpr);
        renameExpr.where = this.parseExprSingle();
        this.want("as");
        renameExpr.what = this.parseExprSingle();
        return renameExpr;
    }

    private Expression parseTransform() throws CompilationException {
        TransformExpr transformExpr = new TransformExpr();
        this.locate(transformExpr);
        LetClause letClause = this.parseLetClause(false);
        transformExpr.copies = new LetClause[]{letClause};
        while (this.eat(MORE_VAR)) {
            letClause = this.parseLetClause(false);
            transformExpr.copies = (LetClause[])Expression.addExpr(transformExpr.copies, letClause);
        }
        this.want("modify");
        transformExpr.modify = this.parseExprSingle();
        this.want("return");
        transformExpr.result = this.parseExprSingle();
        return transformExpr;
    }

    private void moduleImport(int n, String string, ArrayList arrayList) {
        if (string == null || string.length() == 0) {
            this.currentModule.error("XQST0088", n, "empty namespace URI in module import");
            return;
        }
        if (this.currentModule.alreadyImportedModule(string)) {
            this.currentModule.error("XQST0047", n, "module already imported '" + string + "'");
        }
        String[] stringArray = Util.toStringArray(arrayList);
        URL[] uRLArray = null;
        try {
            if (this.moduleResolver != null) {
                uRLArray = this.moduleResolver.resolve(string, stringArray);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.currentModule.error("XQST0059", n, "error during resolution of module " + string + ": " + malformedURLException);
        }
        if (uRLArray == null || uRLArray.length == 0) {
            this.currentModule.error("XQST0059", n, "module " + string + " cannot be resolved");
            return;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                ModuleContext moduleContext = this.moduleManager.loadModule(this.currentModule, uRLArray[i]);
                if (!string.equals(moduleContext.getNamespaceURI())) {
                    this.currentModule.error("XQST0059", n, "module imported from '" + string + "' declares a different URI (" + moduleContext.getNamespaceURI() + ")");
                }
                ModuleImport moduleImport = new ModuleImport(moduleContext);
                this.currentModule.addDeclaration(this.locate(moduleImport, n));
                continue;
            }
            catch (IOException iOException) {
                Exception exception = iOException;
                if (iOException.getMessage() == null && iOException.getCause() instanceof Exception) {
                    exception = (Exception)iOException.getCause();
                }
                this.currentModule.error("XQST0059", n, "in import of module " + string + ": " + exception);
                continue;
            }
            catch (CompilationException compilationException) {
                this.currentModule.error("XQST0059", n, "in import of module " + string + ": " + compilationException);
            }
        }
    }

    private int checkOptionKeyword(String[] stringArray) throws CompilationException {
        this.want("%N");
        String string = this.savedName;
        int n = stringArray.length;
        while (--n >= 0) {
            if (!stringArray[n].equals(string)) continue;
            return n;
        }
        String string2 = "expecting " + stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + " or " + stringArray[i];
        }
        this.syntax(string2);
        return 0;
    }

    private String expandPrefix(String string) {
        String string2 = this.currentModule.convertPrefixToNamespace(string);
        if (string2 == null) {
            if (string.length() > 0) {
                this.currentModule.error("XPST0081", this.tokenStart, "unknown prefix '" + string + "'");
            }
            string2 = "";
        }
        return string2;
    }

    private String expandPrefix(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        return this.expandPrefix(string);
    }

    private IQName resolveQName(String string) throws CompilationException {
        if (string == null) {
            string = "";
        }
        return IQName.get(this.expandPrefix(this.savedPrefix, string), this.savedName);
    }

    private IQName resolveElementName() throws CompilationException {
        return this.resolveQName(this.currentModule.getDefaultElementNamespace());
    }

    private IQName resolveVarName() throws CompilationException {
        return this.resolveQName(null);
    }

    private Expression makeStringLiteral() throws CompilationException {
        return this.locate2(new StringLiteral(this.extractStringToken()));
    }

    private BigDecimal makeDecimal() throws CompilationException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = Conversion.toDecimal(this.saveBuffer.toString(), false);
        }
        catch (EvaluationException evaluationException) {
            this.currentModule.error("XPST0003", this.tokenStart, "invalid value of decimal literal '" + this.saveBuffer + "'");
            bigDecimal = new BigDecimal(0);
        }
        return bigDecimal;
    }

    private double makeNumber() throws CompilationException {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.saveBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.currentModule.error("XPST0003", this.tokenStart, "invalid value of double literal '" + this.saveBuffer + "'");
        }
        return d;
    }

    private long makeInteger() throws CompilationException {
        long l = 0L;
        try {
            l = Conversion.toInteger(this.saveBuffer.toString());
        }
        catch (EvaluationException evaluationException) {
            this.currentModule.error("XPST0003", this.tokenStart, "value of integer literal '" + this.saveBuffer + "' out of bounds");
        }
        return l;
    }

    Expression locate(Expression expression, int n) {
        expression.offset = n;
        expression.module = this.currentModule;
        return expression;
    }

    Expression locate(Expression expression) {
        return this.locate(expression, this.tokenStart);
    }

    Expression locate2(Expression expression) {
        return this.locate(expression, this.prevTokenLoc);
    }

    NodeFilter locate(int n, BaseNodeFilter baseNodeFilter) {
        baseNodeFilter.srcLocation = n;
        return baseNodeFilter;
    }

    public void setModuleResolver(ModuleResolver moduleResolver) {
        this.moduleResolver = moduleResolver;
    }
}

