/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CoreDataModel;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NodeConstructor;

public class AtomConstructor
extends NodeConstructor {
    public int kind;

    public AtomConstructor(int n, Expression expression) {
        Expression[] expressionArray;
        this.kind = n;
        if (expression == null) {
            expressionArray = new Expression[]{};
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = expression;
        }
        this.contents = expressionArray;
        this.type = XQType.TEXT;
        if (n == 6) {
            this.type = XQType.COMMENT;
        }
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.property("kind", "" + this.kind);
        exprDisplay.children(this.contents);
    }

    public BasicNode evalAsNode(Focus focus, EvalContext evalContext) throws EvaluationException {
        CoreDataModel.TextNode textNode;
        CoreDataModel coreDataModel = new CoreDataModel(null);
        if (this.kind == 7) {
            textNode = coreDataModel.newTextNode();
        } else if (this.kind == 6) {
            textNode = coreDataModel.newCommentNode("");
        } else {
            throw new RuntimeException("bad AtomConstructor");
        }
        boolean bl = true;
        for (int i = 0; i < this.contents.length; ++i) {
            XQValue xQValue = this.contents[i].eval(focus, evalContext);
            while (xQValue.next()) {
                if (!bl) {
                    ((CoreDataModel.CoreNode)textNode).addText(" ");
                }
                bl = false;
                ((CoreDataModel.CoreNode)textNode).addText(xQValue.getString());
            }
        }
        if (bl) {
            return null;
        }
        if (this.kind == 6) {
            try {
                String string = textNode.getStringValue();
                if (!XMLUtil.checkComment(string)) {
                    evalContext.error("XQDY0072", (Expression)this, "invalid comment");
                }
            }
            catch (DataModelException dataModelException) {
                this.dmError(evalContext, dataModelException);
            }
        }
        return textNode;
    }

    public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
        evalContext.at(this);
        try {
            if (this.kind == 7) {
                for (int i = 0; i < this.contents.length; ++i) {
                    XQValue xQValue = this.contents[i].eval(focus, evalContext);
                    while (xQValue.next()) {
                        xMLPushStreamBase.putAtomText(xQValue.getString());
                    }
                }
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.contents.length; ++i) {
                XQValue xQValue = this.contents[i].eval(focus, evalContext);
                while (xQValue.next()) {
                    stringBuffer.append(xQValue.getString());
                }
            }
            String string = stringBuffer.toString();
            if (this.kind != 6) {
                throw new RuntimeException("bad AtomConstructor");
            }
            xMLPushStreamBase.putComment(string);
        }
        catch (DataModelException dataModelException) {
            this.dmError(evalContext, dataModelException);
        }
    }
}

