/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.api.util.time.Duration;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleDecimal;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleDuration;
import com.qizx.xquery.dt.SingleFloat;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NumericOp;
import java.math.BigDecimal;

public class DivOp
extends NumericOp {
    static final int PRECISION = 18;

    public DivOp(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Prototype[] getProtos() {
        return null;
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        switch (this.combinedArgTypes(moduleContext)) {
            default: 
        }
        return this.transfer(new ExecAny(), this.operands);
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child(this.operands[0]);
        exprDisplay.child("expr2", this.operands[1]);
    }

    public static class ExecAny
    extends Function.NumericCall {
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            XQItem xQItem2 = this.args[1].evalAsOptItem(focus, evalContext);
            if (xQItem == null || xQItem2 == null) {
                return XQValue.empty;
            }
            switch (NumericOp.combinedArgTypes(xQItem, xQItem2)) {
                case 17: {
                    long l = xQItem.getInteger();
                    long l2 = xQItem2.getInteger();
                    if (l2 == 0L) {
                        evalContext.error("FODT0002", this.args[1], "divide by 0");
                    }
                    BigDecimal bigDecimal = BigDecimal.valueOf(l);
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(l2);
                    BigDecimal bigDecimal3 = Conversion.divide(bigDecimal, bigDecimal2);
                    return new SingleDecimal(bigDecimal3);
                }
                case 18: 
                case 33: 
                case 34: {
                    BigDecimal bigDecimal = xQItem2.getDecimal();
                    try {
                        BigDecimal bigDecimal4 = Conversion.divide(xQItem.getDecimal(), bigDecimal);
                        return new SingleDecimal(bigDecimal4);
                    }
                    catch (ArithmeticException arithmeticException) {
                        evalContext.error("FOAR0002", this.args[1], arithmeticException.getMessage());
                    }
                }
                case 19: 
                case 35: 
                case 49: 
                case 50: 
                case 51: {
                    return new SingleFloat(xQItem.getFloat() / xQItem2.getFloat());
                }
                case 20: 
                case 36: 
                case 52: 
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    return new SingleDouble(xQItem.getDouble() / xQItem2.getDouble());
                }
                case 170: {
                    double d = xQItem.getDuration().getTotalMonths();
                    double d2 = xQItem2.getDuration().getTotalMonths();
                    if (d2 == 0.0) {
                        evalContext.error("FODT0002", this.args[1], "divide by 0");
                    }
                    return new SingleDecimal(Conversion.toDecimal(d / d2));
                }
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    try {
                        double d = xQItem2.getDouble();
                        if (d == 0.0) {
                            evalContext.error("FODT0002", this.args[1], "divide by 0");
                        }
                        if (Double.isNaN(d)) {
                            evalContext.error("FOCA0005", (Expression)this, "invalid argument");
                        }
                        Duration duration = xQItem.getDuration();
                        return SingleDuration.newYM(Duration.newYearMonth((int)Math.round((double)duration.getTotalMonths() / d)));
                    }
                    catch (DateTimeException dateTimeException) {
                        evalContext.error("OOPS", (Expression)this, "OOPS " + dateTimeException);
                    }
                }
                case 187: {
                    double d = xQItem.getDuration().getTotalSeconds();
                    double d3 = xQItem2.getDuration().getTotalSeconds();
                    if (d3 == 0.0) {
                        evalContext.error("FOAR0001", this.args[1], "divide by 0");
                    }
                    return new SingleDecimal(Conversion.toDecimal(d / d3));
                }
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    try {
                        double d = xQItem2.getDouble();
                        if (d == 0.0) {
                            evalContext.error("FODT0002", this.args[1], "divide by 0");
                        }
                        if (Double.isNaN(d)) {
                            evalContext.error("FOCA0005", (Expression)this, "invalid argument");
                        }
                        Duration duration = xQItem.getDuration();
                        return SingleDuration.newDT(Duration.newDayTime(duration.getTotalSeconds() / d));
                    }
                    catch (DateTimeException dateTimeException) {
                        evalContext.error("OOPS", (Expression)this, "OOPS " + dateTimeException);
                    }
                }
            }
            evalContext.error("XPTY0004", (Expression)this, "invalid types for operator div");
            return new SingleItem(xQItem);
        }
    }
}

