/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.dt.Atomizer;
import com.qizx.xquery.dt.IntegerValue;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleSourceSequence;
import com.qizx.xquery.dt.SingleString;
import com.qizx.xquery.dt.StringValue;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.op.AndExpr;
import com.qizx.xquery.op.Comparison;
import com.qizx.xquery.op.Expr;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.ForClause;
import com.qizx.xquery.op.GroupingVariable;
import com.qizx.xquery.op.Join;
import com.qizx.xquery.op.LetClause;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.NodeSortExpr;
import com.qizx.xquery.op.OrderSpec;
import com.qizx.xquery.op.PathExpr;
import com.qizx.xquery.op.ValueNeOp;
import com.qizx.xquery.op.VarClause;
import com.qizx.xquery.op.VarReference;
import com.qizx.xquery.op.WindowClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class FLWRExpr
extends Expression {
    static boolean noJoins = System.getProperty("xquest.nojoins") != null;
    static int genId;
    private static final XQItem EMPTY_ITEM;
    public Expression where;
    public Expression expr;
    private Expression[] clauses = new Expression[0];
    private OrderSpec[] orderSpecs;
    public boolean stableOrder;
    public boolean checked;
    protected boolean hasScore;
    public GroupingVariable[] groupingKeys;
    public LetClause[] postGroupingLets;
    public Expression postGroupingWhere;
    private LocalVariable[] nonGroupingVars;
    private LocalVariable[] outGroupingVars;
    private LocalVariable[] outNonGroupingVars;

    public VarClause addClause(VarClause varClause) {
        this.clauses = FLWRExpr.addExpr(this.clauses, varClause);
        return varClause;
    }

    public VarClause addPostLetClause(LetClause letClause) {
        this.postGroupingLets = (LetClause[])FLWRExpr.addExpr(this.postGroupingLets, letClause);
        return letClause;
    }

    public void addClause(VarClause varClause, VarClause varClause2) {
        this.clauses = FLWRExpr.addExpr(this.clauses, varClause);
        int n = this.clauses.length;
        while (--n > 0) {
            this.clauses[n] = this.clauses[n - 1];
            if (this.clauses[n] != varClause2) continue;
            this.clauses[n - 1] = varClause;
            break;
        }
    }

    VarClause getClause(int n) {
        return n < 0 || n >= this.clauses.length ? null : (VarClause)this.clauses[n];
    }

    public void addOrderSpec(OrderSpec orderSpec) {
        if (this.orderSpecs == null) {
            this.orderSpecs = new OrderSpec[]{orderSpec};
        } else {
            OrderSpec[] orderSpecArray = this.orderSpecs;
            this.orderSpecs = new OrderSpec[orderSpecArray.length + 1];
            System.arraycopy(orderSpecArray, 0, this.orderSpecs, 0, orderSpecArray.length);
            this.orderSpecs[orderSpecArray.length] = orderSpec;
        }
    }

    OrderSpec getOrderSpec(int n) {
        return n < 0 || this.orderSpecs == null || n >= this.orderSpecs.length ? null : this.orderSpecs[n];
    }

    public Expression child(int n) {
        if (n < this.clauses.length) {
            return this.clauses[n];
        }
        n -= this.clauses.length;
        if (this.where != null) {
            if (n == 0) {
                return this.where;
            }
            --n;
        }
        if (this.orderSpecs != null) {
            if (n < this.orderSpecs.length) {
                return this.orderSpecs[n];
            }
            n -= this.orderSpecs.length;
        }
        return n == 0 ? this.expr : null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.children(this.clauses);
        if (this.where != null) {
            exprDisplay.child("where", this.where);
        }
        if (this.groupingKeys != null) {
            int n;
            for (n = 0; n < this.groupingKeys.length; ++n) {
                exprDisplay.child(this.groupingKeys[n]);
                exprDisplay.child("out", "" + this.outGroupingVars[n]);
            }
            for (n = 0; n < this.nonGroupingVars.length; ++n) {
                exprDisplay.child("nonGroupingVar", "" + this.nonGroupingVars[n]);
                exprDisplay.child("out", "" + this.outNonGroupingVars[n]);
            }
            for (n = 0; n < this.postGroupingLets.length; ++n) {
                exprDisplay.child("post-let", this.postGroupingLets[n]);
            }
            if (this.postGroupingWhere != null) {
                exprDisplay.child("where", this.postGroupingWhere);
            }
        }
        if (this.orderSpecs != null) {
            exprDisplay.children("orderBy", this.orderSpecs);
        }
        exprDisplay.child("return", this.expr);
    }

    public int getFlags() {
        return this.expr.getFlags();
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        JoinInfo joinInfo;
        ForClause forClause;
        int n2;
        LocalVariable localVariable = moduleContext.latestLocalVariable();
        for (n2 = 0; n2 < this.clauses.length; ++n2) {
            ((VarClause)this.clauses[n2]).owner = this;
            moduleContext.staticCheck(this.clauses[n2], 0);
            if (!(this.clauses[n2] instanceof ForClause)) continue;
            forClause = (ForClause)this.clauses[n2];
            if (forClause.scoreDecl == null) continue;
            this.hasScore = true;
        }
        if (this.where != null) {
            this.where = moduleContext.staticCheck(this.where, 0);
        }
        if (this.groupingKeys != null) {
            this.checkGroupBy(moduleContext);
        }
        if (this.orderSpecs != null) {
            for (n2 = 0; n2 < this.orderSpecs.length; ++n2) {
                moduleContext.staticCheck(this.orderSpecs[n2], 0);
            }
        }
        this.expr = moduleContext.simpleStaticCheck(this.expr, 0);
        this.type = this.expr.getType().itemType().star;
        if (this.where != null && !noJoins && (joinInfo = this.joinablePredicate(this.where)) != null) {
            LocalVariable localVariable2;
            this.where = joinInfo.remainder;
            forClause = (ForClause)joinInfo.innerVar.owner;
            LocalVariable localVariable3 = joinInfo.innerVar;
            while ((localVariable2 = localVariable3.pred) != null && localVariable2.owner != null && localVariable2.name != null && !Expr.depends(forClause.expr, localVariable2)) {
                localVariable3 = localVariable2;
            }
            LocalVariable localVariable4 = moduleContext.newLocal(null, XQType.WRAPPED_OBJECT, null);
            localVariable4.declareBefore(localVariable3);
            localVariable4.address = -1;
            LetClause letClause = new LetClause(localVariable4.name);
            localVariable4.owner = letClause;
            letClause.varDecl = localVariable4;
            LocalVariable localVariable5 = moduleContext.newLocal(null, XQType.NODE, null);
            localVariable4.addAfter(localVariable5);
            localVariable5.address = -1;
            Expr.VarReplacer varReplacer = new Expr.VarReplacer(joinInfo.innerVar, localVariable5);
            varReplacer.visit(joinInfo.innerExpr);
            letClause.expr = new Join.Maker(forClause.expr, joinInfo.innerExpr, localVariable5, joinInfo.type);
            VarClause varClause = (VarClause)localVariable3.owner;
            FLWRExpr fLWRExpr = (FLWRExpr)varClause.owner;
            letClause.owner = fLWRExpr;
            fLWRExpr.addClause(letClause, varClause);
            forClause.expr = new Join.Get(joinInfo.outerExpr, localVariable4, joinInfo.comparison);
        }
        moduleContext.popLocalVariables(localVariable);
        FLWRExpr fLWRExpr = FLWRExpr.tryToRemoveWhere(this);
        return FLWRExpr.tryToRemoveLoop(fLWRExpr);
    }

    private void checkGroupBy(ModuleContext moduleContext) {
        int n;
        int n2;
        for (int i = 0; i < this.groupingKeys.length; ++i) {
            this.groupingKeys[i] = (GroupingVariable)moduleContext.staticCheck(this.groupingKeys[i], 0);
        }
        VarRefCollector varRefCollector = new VarRefCollector();
        for (n2 = 0; n2 < this.postGroupingLets.length; ++n2) {
            varRefCollector.visit(this.postGroupingLets[n2]);
        }
        if (this.postGroupingWhere != null) {
            varRefCollector.visit(this.postGroupingWhere);
        }
        if (this.orderSpecs != null) {
            for (n2 = 0; n2 < this.orderSpecs.length; ++n2) {
                varRefCollector.visit(this.orderSpecs[n2]);
            }
        }
        varRefCollector.visit(this.expr);
        ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>();
        LocalVariable localVariable = moduleContext.firstLocalVariable();
        LocalVariable localVariable2 = moduleContext.latestLocalVariable();
        while (localVariable != null) {
            block12: {
                QName qName = localVariable.name;
                if (qName != null && varRefCollector.vars.contains(qName) && !localVariable.grouped) {
                    int n3 = this.groupingKeys.length;
                    while (--n3 >= 0) {
                        if (this.groupingKeys[n3].decl != localVariable) continue;
                        break block12;
                    }
                    arrayList.add(localVariable);
                    if (localVariable == localVariable2) break;
                }
            }
            localVariable = localVariable.succ;
        }
        this.nonGroupingVars = arrayList.toArray(new LocalVariable[arrayList.size()]);
        this.outGroupingVars = new LocalVariable[this.groupingKeys.length];
        for (n = 0; n < this.groupingKeys.length; ++n) {
            LocalVariable localVariable3 = this.groupingKeys[n].decl;
            if (localVariable3 == null) continue;
            this.outGroupingVars[n] = moduleContext.defineLocalVariable(localVariable3.name, localVariable3.type, localVariable3.owner);
            localVariable3.grouped = true;
        }
        this.outNonGroupingVars = new LocalVariable[this.nonGroupingVars.length];
        for (n = 0; n < this.nonGroupingVars.length; ++n) {
            LocalVariable localVariable4 = this.nonGroupingVars[n];
            if (localVariable4 == null) continue;
            XQItemType xQItemType = (XQItemType)localVariable4.type.getItemType();
            this.outNonGroupingVars[n] = moduleContext.defineLocalVariable(localVariable4.name, xQItemType.star, localVariable4.owner);
            localVariable4.grouped = true;
        }
        for (n = 0; n < this.postGroupingLets.length; ++n) {
            moduleContext.staticCheck(this.postGroupingLets[n], 0);
        }
        if (this.postGroupingWhere != null) {
            this.postGroupingWhere = moduleContext.staticCheck(this.postGroupingWhere, 0);
        }
    }

    JoinInfo joinablePredicate(Expression expression) {
        if (expression instanceof AndExpr) {
            AndExpr andExpr = (AndExpr)expression;
            int n = andExpr.args.length;
            for (int i = 0; i < n; ++i) {
                JoinInfo joinInfo = this.joinablePredicate(andExpr.args[i]);
                if (joinInfo == null) continue;
                if (n == 2) {
                    joinInfo.remainder = andExpr.args[1 - i];
                } else {
                    AndExpr andExpr2 = new AndExpr();
                    andExpr2.args = new Expression[n - 1];
                    System.arraycopy(andExpr.args, 0, andExpr2.args, 0, i);
                    System.arraycopy(andExpr.args, i + 1, andExpr2.args, i, n - i - 1);
                    joinInfo.remainder = andExpr2;
                }
                return joinInfo;
            }
            return null;
        }
        if (!(expression instanceof Comparison.Exec)) {
            return null;
        }
        Comparison.Exec exec = (Comparison.Exec)expression;
        Expression expression2 = exec.args[0];
        Expression expression3 = exec.args[1];
        if (expression2 instanceof NodeSortExpr) {
            expression2 = ((NodeSortExpr)expression2).expr;
        }
        if (expression3 instanceof NodeSortExpr) {
            expression3 = ((NodeSortExpr)expression3).expr;
        }
        Expr.ForVarCollector forVarCollector = new Expr.ForVarCollector();
        forVarCollector.visit(expression2);
        if (forVarCollector.found == null || forVarCollector.found2 != null) {
            return null;
        }
        LocalVariable localVariable = forVarCollector.found;
        forVarCollector.reset();
        forVarCollector.visit(expression3);
        if (forVarCollector.found == null || forVarCollector.found2 != null) {
            return null;
        }
        LocalVariable localVariable2 = forVarCollector.found;
        if (localVariable == localVariable2 || exec.test == ValueNeOp.TEST) {
            return null;
        }
        XQItemType xQItemType = localVariable.getType().itemType();
        XQItemType xQItemType2 = localVariable2.getType().itemType();
        if (XQType.ATOM.isSuperType(xQItemType) && XQType.ATOM.isSuperType(xQItemType2)) {
            return null;
        }
        JoinInfo joinInfo = new JoinInfo();
        joinInfo.outerVar = localVariable;
        joinInfo.innerVar = localVariable2;
        joinInfo.outerExpr = expression2;
        joinInfo.innerExpr = expression3;
        LocalVariable localVariable3 = localVariable2;
        while (localVariable3 != null && localVariable3 != localVariable) {
            localVariable3 = localVariable3.pred;
        }
        if (localVariable3 == null) {
            exec.args[0] = expression3;
            exec.args[1] = expression2;
            exec.test = exec.test.reverse();
            joinInfo.outerVar = localVariable2;
            joinInfo.innerVar = localVariable;
            joinInfo.outerExpr = expression3;
            joinInfo.innerExpr = expression2;
        }
        joinInfo.comparison = exec.test;
        XQItemType xQItemType3 = joinInfo.innerExpr.getType().itemType();
        XQItemType xQItemType4 = joinInfo.outerExpr.getType().itemType();
        joinInfo.type = XQType.NUMERIC.isSuperType(xQItemType3) || XQType.NUMERIC.isSuperType(xQItemType4) ? XQType.NUMERIC : XQType.STRING;
        return joinInfo;
    }

    static FLWRExpr tryToRemoveWhere(FLWRExpr fLWRExpr) {
        if (fLWRExpr.clauses.length != 1 || fLWRExpr.where == null || fLWRExpr.orderSpecs != null) {
            return fLWRExpr;
        }
        VarClause varClause = fLWRExpr.getClause(0);
        if (!(varClause instanceof ForClause)) {
            return fLWRExpr;
        }
        if (((ForClause)varClause).position != null) {
            return fLWRExpr;
        }
        Expression expression = varClause.expr;
        if (expression instanceof NodeSortExpr) {
            expression = ((NodeSortExpr)expression).expr;
        }
        if (!(expression instanceof PathExpr)) {
            return fLWRExpr;
        }
        LocalVariable localVariable = varClause.varDecl;
        Expr.DottingVarFinder dottingVarFinder = new Expr.DottingVarFinder(localVariable);
        if (!dottingVarFinder.visit(fLWRExpr.where)) {
            return fLWRExpr;
        }
        new Expr.VarReplacer(localVariable, null).visit(fLWRExpr.where);
        varClause.expr = Expr.addPredicate(varClause.expr, fLWRExpr.where);
        fLWRExpr.where = null;
        return fLWRExpr;
    }

    static Expression tryToRemoveLoop(FLWRExpr fLWRExpr) {
        if (fLWRExpr.orderSpecs != null || fLWRExpr.where != null || fLWRExpr.clauses.length != 1 || fLWRExpr.hasScore) {
            return fLWRExpr;
        }
        VarClause varClause = fLWRExpr.getClause(0);
        if (!(varClause instanceof ForClause) || !(fLWRExpr.expr instanceof VarReference.Local) || varClause.declaredType != null) {
            return fLWRExpr;
        }
        LocalVariable localVariable = varClause.varDecl;
        VarReference.Local local = (VarReference.Local)fLWRExpr.expr;
        if (local.decl != localVariable) {
            return fLWRExpr;
        }
        return varClause.expr;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        VarClause.SingleDummy singleDummy = new VarClause.SingleDummy(focus, evalContext);
        for (int i = 0; i < this.clauses.length; ++i) {
            VarClause.SingleDummy singleDummy2 = (VarClause.SingleDummy)this.clauses[i].eval(focus, evalContext);
            singleDummy2.setSource(singleDummy);
            singleDummy = singleDummy2;
        }
        if (this.orderSpecs == null && this.groupingKeys == null && !(singleDummy instanceof WindowClause.Sequence)) {
            XQItemType xQItemType = this.expr.getType().itemType();
            int n = this.expr.getType().getOccurrence();
            if (xQItemType == XQType.INTEGER && !XQType.isRepeatable(n)) {
                return new IntSequence(singleDummy, focus, evalContext);
            }
            if (xQItemType == XQType.STRING && !XQType.isRepeatable(n)) {
                return new StringSequence(singleDummy, focus, evalContext);
            }
            if (n == 1) {
                return new ItemSequence(singleDummy, focus, evalContext);
            }
        }
        Expression expression = this.where;
        if (this.groupingKeys != null) {
            GroupBySequence groupBySequence = new GroupBySequence(singleDummy, this.where, evalContext, null);
            singleDummy = groupBySequence;
            for (int i = 0; i < this.postGroupingLets.length; ++i) {
                VarClause.SingleDummy singleDummy3 = (VarClause.SingleDummy)this.postGroupingLets[i].eval(focus, evalContext);
                singleDummy3.setSource(singleDummy);
                singleDummy = singleDummy3;
            }
            expression = this.postGroupingWhere;
        }
        Sequence sequence = new Sequence(singleDummy, expression, focus, evalContext);
        if (this.orderSpecs != null) {
            return this.sorted(sequence, focus, evalContext);
        }
        return sequence;
    }

    public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
        evalContext.at(this);
        if (this.orderSpecs != null || this.groupingKeys != null) {
            super.evalAsEvents(xMLPushStreamBase, focus, evalContext);
            return;
        }
        VarClause.SingleDummy singleDummy = new VarClause.SingleDummy(focus, evalContext);
        for (int i = 0; i < this.clauses.length; ++i) {
            VarClause.SingleDummy singleDummy2 = (VarClause.SingleDummy)this.clauses[i].eval(focus, evalContext);
            singleDummy2.setSource(singleDummy);
            singleDummy = singleDummy2;
        }
        while (singleDummy.next()) {
            if (this.where != null && !this.where.evalEffectiveBooleanValue(focus, evalContext)) continue;
            evalContext.at(this.expr);
            this.expr.evalAsEvents(xMLPushStreamBase, focus, evalContext);
        }
    }

    private ArraySequence sorted(XQValue xQValue, Focus focus, EvalContext evalContext) throws EvaluationException {
        Object object;
        int n;
        Object[] objectArray;
        Object[] objectArray2 = new Object[8];
        int n2 = 0;
        int n3 = this.hasScore ? 2 : 1;
        int n4 = this.orderSpecs.length;
        while (xQValue.next()) {
            objectArray = new XQItem[n4 + n3];
            objectArray[0] = xQValue.getItem();
            for (n = 0; n < n4; ++n) {
                object = this.orderSpecs[n].key.eval(focus, evalContext);
                if (!object.next()) {
                    objectArray[n + 1] = null;
                    continue;
                }
                objectArray[n + 1] = Atomizer.toSingleAtom(object.getItem());
                if (!object.next()) continue;
                evalContext.error("XPTY0004", (Expression)this.orderSpecs[n], "order key must be atomic");
            }
            if (this.hasScore) {
                objectArray[n4 + 1] = new SingleDouble(xQValue.getFulltextScore(objectArray[0]));
            }
            if (n2 >= objectArray2.length) {
                Object[] objectArray3 = objectArray2;
                objectArray2 = new Object[objectArray3.length * 2];
                System.arraycopy(objectArray3, 0, objectArray2, 0, objectArray3.length);
            }
            objectArray2[n2++] = objectArray;
        }
        try {
            if (n2 > 1) {
                Arrays.sort(objectArray2, 0, n2, new OrderComparator(evalContext));
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof EvaluationException) {
                throw (EvaluationException)runtimeException.getCause();
            }
            throw runtimeException;
        }
        objectArray = this.hasScore ? new double[n2] : null;
        n = n2;
        while (--n >= 0) {
            object = (XQItem[])objectArray2[n];
            objectArray2[n] = object[0];
            if (!this.hasScore) continue;
            objectArray[n] = (XQItem)object[n4 + 1].getDouble();
        }
        ArraySequence arraySequence = new ArraySequence(objectArray2, n2);
        arraySequence.setOrigin(xQValue);
        arraySequence.setScores((double[])objectArray);
        return arraySequence;
    }

    static {
        EMPTY_ITEM = new SingleString("");
    }

    private static class VarRefCollector
    extends Expression.Visitor {
        public HashSet vars = new HashSet();

        private VarRefCollector() {
        }

        public boolean preTest(Expression expression) {
            if (!(expression instanceof VarReference)) {
                return true;
            }
            VarReference varReference = (VarReference)expression;
            this.vars.add(varReference.name);
            return true;
        }
    }

    private class GroupBySequence
    extends VarClause.SingleDummy {
        private XQValue input;
        private Expression where;
        private HashMap groups;
        private Iterator groupIterator;

        public GroupBySequence(XQValue xQValue, Expression expression, EvalContext evalContext, HashMap hashMap) {
            super(null, evalContext);
            this.input = xQValue;
            this.where = expression;
            this.groups = hashMap;
            if (hashMap != null) {
                this.groupIterator = hashMap.keySet().iterator();
            }
        }

        public XQValue bornAgain() {
            return new GroupBySequence(this.input.bornAgain(), this.where, this.context, this.groups);
        }

        public boolean next() throws EvaluationException {
            if (this.groups == null) {
                this.expandAndGroup();
                this.groupIterator = this.groups.keySet().iterator();
            }
            if (!this.groupIterator.hasNext()) {
                return false;
            }
            Group group = (Group)this.groupIterator.next();
            int n = FLWRExpr.this.groupingKeys.length;
            while (--n >= 0) {
                this.context.storeLocalItem(((FLWRExpr)FLWRExpr.this).outGroupingVars[n].address, group.keyValues[n]);
            }
            n = FLWRExpr.this.outNonGroupingVars.length;
            while (--n >= 0) {
                ArraySequence arraySequence = group.values[n];
                arraySequence.pack();
                this.context.storeLocal(((FLWRExpr)FLWRExpr.this).outNonGroupingVars[n].address, arraySequence, false, null);
            }
            return true;
        }

        private void expandAndGroup() throws EvaluationException {
            this.groups = new HashMap();
            int n = FLWRExpr.this.groupingKeys.length;
            int n2 = FLWRExpr.this.nonGroupingVars.length;
            Group group = new Group(n, n2);
            while (this.input.next()) {
                for (int i = 0; i < n; ++i) {
                    XQItem xQItem = this.context.loadLocalItem(FLWRExpr.this.groupingKeys[i].decl.address);
                    if (xQItem == null) {
                        xQItem = EMPTY_ITEM;
                    }
                    group.keyValues[i] = xQItem;
                    group.keys[i] = Atomizer.toSingleAtom(xQItem);
                }
                Group group2 = (Group)this.groups.get(group);
                if (group2 == null) {
                    group2 = new Group(n, n2);
                    for (int i = 0; i < n; ++i) {
                        group2.keys[i] = group.keys[i];
                        group2.keyValues[i] = group.keyValues[i];
                    }
                    this.groups.put(group2, group2);
                }
                for (int i = 0; i < n2; ++i) {
                    XQValue xQValue = this.context.loadLocal(((FLWRExpr)FLWRExpr.this).nonGroupingVars[i].address);
                    if (group2.values[i] == null) {
                        group2.values[i] = new ArraySequence(4, xQValue);
                    }
                    group2.values[i].append(xQValue);
                }
            }
        }

        private class Group {
            XQItem[] keys;
            XQItem[] keyValues;
            ArraySequence[] values;

            Group(int n, int n2) {
                this.keys = new XQItem[n];
                this.keyValues = new XQItem[n];
                this.values = new ArraySequence[n2];
            }

            public int hashCode() {
                int n = 0;
                int n2 = this.keys.length;
                while (--n2 >= 0) {
                    n ^= this.keys[n2].hashCode();
                }
                return n;
            }

            public boolean equals(Object object) {
                if (object instanceof Group) {
                    Group group = (Group)object;
                    try {
                        int n = this.keys.length;
                        while (--n >= 0) {
                            if (this.keys[n].compareTo(group.keys[n], FLWRExpr.this.groupingKeys[n], 0) == 0) continue;
                            return false;
                        }
                    }
                    catch (EvaluationException evaluationException) {
                        return false;
                    }
                }
                return true;
            }
        }
    }

    private final class OrderComparator
    implements Comparator {
        private final EvalContext context;

        private OrderComparator(EvalContext evalContext) {
            this.context = evalContext;
        }

        public int compare(Object object, Object object2) {
            try {
                OrderSpec orderSpec;
                XQItem[] xQItemArray = (XQItem[])object;
                XQItem[] xQItemArray2 = (XQItem[])object2;
                int n = 0;
                for (int i = 1; i <= FLWRExpr.this.orderSpecs.length && (n = (orderSpec = FLWRExpr.this.orderSpecs[i - 1]).compare(xQItemArray[i], xQItemArray2[i], this.context)) == 0; ++i) {
                }
                return n;
            }
            catch (EvaluationException evaluationException) {
                throw new RuntimeException(evaluationException);
            }
        }
    }

    protected class StringSequence
    extends StringValue {
        Focus focus;
        EvalContext context;
        XQValue source;
        String curItem;

        StringSequence(XQValue xQValue, Focus focus, EvalContext evalContext) {
            this.source = xQValue;
            this.focus = focus;
            this.context = evalContext;
        }

        public XQValue bornAgain() {
            return new StringSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public String getString() {
            return this.curItem;
        }

        protected String getValue() {
            return this.curItem;
        }

        public boolean next() throws EvaluationException {
            while (this.source.next()) {
                if (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context)) continue;
                this.context.at(FLWRExpr.this.expr);
                try {
                    this.curItem = FLWRExpr.this.expr.evalAsOptString(this.focus, this.context);
                    if (this.curItem == null) continue;
                    return true;
                }
                catch (EmptyException emptyException) {
                    continue;
                }
                break;
            }
            return false;
        }
    }

    public class IntSequence
    extends IntegerValue {
        Focus focus;
        EvalContext context;
        XQValue source;
        long curItem;

        IntSequence(XQValue xQValue, Focus focus, EvalContext evalContext) {
            this.source = xQValue;
            this.focus = focus;
            this.context = evalContext;
        }

        public XQValue bornAgain() {
            return new IntSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public long getInteger() {
            return this.curItem;
        }

        protected long getValue() {
            return this.curItem;
        }

        public boolean next() throws EvaluationException {
            while (this.source.next()) {
                if (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context)) continue;
                this.context.at(FLWRExpr.this.expr);
                try {
                    this.curItem = FLWRExpr.this.expr.evalAsOptInteger(this.focus, this.context);
                    return true;
                }
                catch (EmptyException emptyException) {
                    continue;
                }
                break;
            }
            return false;
        }
    }

    public class ItemSequence
    extends SingleSourceSequence {
        Focus focus;
        EvalContext context;

        ItemSequence(XQValue xQValue, Focus focus, EvalContext evalContext) {
            super(xQValue);
            this.focus = focus;
            this.context = evalContext;
        }

        public XQValue bornAgain() {
            return new ItemSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public boolean next() throws EvaluationException {
            do {
                if (this.source.next()) continue;
                return false;
            } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
            this.context.at(FLWRExpr.this.expr);
            this.item = FLWRExpr.this.expr.evalAsItem(this.focus, this.context);
            return true;
        }

        public boolean nextCollection() throws EvaluationException {
            do {
                if (this.source.nextCollection()) continue;
                return false;
            } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
            this.item = FLWRExpr.this.expr.evalAsItem(this.focus, this.context);
            return true;
        }
    }

    public class Sequence
    extends SingleSourceSequence {
        Focus focus;
        EvalContext context;
        Expression whereFilter;
        XQValue current;

        Sequence(XQValue xQValue, Expression expression, Focus focus, EvalContext evalContext) {
            super(xQValue);
            this.whereFilter = expression;
            this.focus = focus;
            this.context = evalContext;
            this.current = XQValue.empty;
        }

        public XQValue bornAgain() {
            return new Sequence(this.source.bornAgain(), this.whereFilter, this.focus, this.context);
        }

        public boolean next() throws EvaluationException {
            while (true) {
                if (this.current.next()) {
                    this.item = this.current.getItem();
                    return true;
                }
                do {
                    if (this.source.next()) continue;
                    return false;
                } while (this.whereFilter != null && !this.whereFilter.evalEffectiveBooleanValue(this.focus, this.context));
                this.current = FLWRExpr.this.expr.eval(this.focus, this.context);
            }
        }
    }

    public static class JoinInfo {
        LocalVariable outerVar;
        LocalVariable innerVar;
        Expression outerExpr;
        Expression innerExpr;
        Expression remainder;
        Comparison.Test comparison;
        XQType type;
    }
}

