/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.TextTokenizer;
import com.qizx.queries.FullText;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.StringArraySequence;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FTSelectionOp;
import com.qizx.xquery.op.RangeExpr;
import java.util.regex.PatternSyntaxException;

public class FTWordsOp
extends FTSelectionOp {
    public int anyAll = 0;
    public RangeExpr occs;

    public FTWordsOp(Expression expression) {
        super(expression);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        super.staticCheck(moduleContext, n);
        this.occs = (RangeExpr)moduleContext.staticCheck(this.occs, n);
        return this;
    }

    public boolean isConstant() {
        return this.children[0].isConstant() && (this.occs == null || this.occs.isConstant());
    }

    public boolean hasExcludesOrOccurs() {
        if (this.occs != null) {
            return true;
        }
        return super.hasExcludesOrOccurs();
    }

    public FullText.Selection expand(Focus focus, EvalContext evalContext, FullText.MatchOptions matchOptions, float f) throws EvaluationException {
        FullText.Selection selection;
        FullText.SelectionList selectionList = null;
        XQValue xQValue = this.children[0].eval(focus, evalContext);
        String[] stringArray = null;
        try {
            stringArray = StringArraySequence.expand(xQValue, true);
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(this, xQTypeException);
        }
        FullText.MatchOptions matchOptions2 = this.expandMatchOptions(matchOptions);
        float f2 = this.expandWeight(focus, evalContext, f);
        ModuleContext moduleContext = evalContext.getStaticContext();
        FullTextFactory fullTextFactory = moduleContext.getFulltextFactory();
        TextTokenizer textTokenizer = fullTextFactory.getTokenizer(matchOptions2.language);
        if (textTokenizer == null) {
            throw new EvaluationException(ModuleContext.xqueryErrorCode("FTST0009"), "no tokenizer available for language " + matchOptions2.language);
        }
        textTokenizer.setAcceptingWildcards(matchOptions2.wildcards == 1);
        textTokenizer.setParsingSpecialChars(false);
        switch (this.anyAll) {
            case 3: {
                int n;
                selectionList = new FullText.All();
                for (n = 0; n < stringArray.length; ++n) {
                    this.expandTerms(stringArray[n], selectionList, textTokenizer, matchOptions2, f2);
                }
                break;
            }
            case 1: {
                int n;
                selectionList = new FullText.Any();
                selectionList.setWeight(f2);
                for (n = 0; n < stringArray.length; ++n) {
                    this.expandTerms(stringArray[n], selectionList, textTokenizer, matchOptions2, f2);
                }
                break;
            }
            case 2: {
                int n;
                if (stringArray.length == 1) {
                    selectionList = new FullText.Phrase();
                    this.expandTerms(stringArray[0], selectionList, textTokenizer, matchOptions2, f2);
                    break;
                }
                selectionList = new FullText.All();
                for (n = 0; n < stringArray.length; ++n) {
                    selectionList.addChild(this.expandTerms(stringArray[n], new FullText.Phrase(), textTokenizer, matchOptions2, f2));
                }
                break;
            }
            case 0: {
                int n;
                if (stringArray.length == 1) {
                    selectionList = new FullText.Phrase();
                    this.expandTerms(stringArray[0], selectionList, textTokenizer, matchOptions2, f2);
                    break;
                }
                selectionList = new FullText.Any();
                for (n = 0; n < stringArray.length; ++n) {
                    selectionList.addChild(this.expandTerms(stringArray[n], new FullText.Phrase(), textTokenizer, matchOptions2, f2));
                }
                break;
            }
            case 4: {
                int n;
                selectionList = new FullText.Phrase();
                for (n = 0; n < stringArray.length; ++n) {
                    this.expandTerms(stringArray[n], selectionList, textTokenizer, matchOptions2, f2);
                }
                break;
            }
        }
        if (this.occs != null) {
            selectionList.occRange = this.occs.evaluate(focus, evalContext);
        }
        selectionList.setMatchOptions(matchOptions2);
        selectionList.setPosFilters(this.expandPositionFilters(focus, evalContext));
        if (selectionList.getChildCount() == 0) {
            return FullText.NULL_QUERY;
        }
        if (selectionList.getChildCount() == 1 && (selection = selectionList.getChild(0)).getMatchOptions() == matchOptions2 && selection.occRange == null && selection.getPosFilters() == null && (selectionList.getPosFilters() == null || selectionList.getPosFilters().content == 0)) {
            selection.setPosFilters(selectionList.getPosFilters());
            selection.occRange = selectionList.occRange;
            selection.setWeight(selectionList.getWeight());
            return selection;
        }
        return selectionList;
    }

    private FullText.Selection expandTerms(String string, FullText.SelectionList selectionList, TextTokenizer textTokenizer, FullText.MatchOptions matchOptions, float f) throws EvaluationException {
        textTokenizer.start(string);
        selectionList.setWeight(f);
        selectionList.setMatchOptions(matchOptions);
        try {
            int n = textTokenizer.nextToken();
            while (n != 0) {
                if (n == 1) {
                    char[] cArray = textTokenizer.getTokenChars();
                    FullText.Selection selection = textTokenizer.gotWildcard() ? new FullText.Wildcard(cArray) : new FullText.SimpleWord(cArray);
                    selection.setWeight(selectionList.getWeight());
                    selection.setMatchOptions(matchOptions);
                    selectionList.addChild(selection);
                }
                n = textTokenizer.nextToken();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            EvaluationException evaluationException = new EvaluationException("wildcard pattern error: " + patternSyntaxException.getMessage());
            evaluationException.setErrorCode("FTDY0020");
            throw evaluationException;
        }
        return selectionList;
    }
}

