/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.IQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.BooleanValue;
import com.qizx.xquery.dt.SingleSourceSequence;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Last;
import com.qizx.xquery.fn.Name;
import com.qizx.xquery.fn.Number;
import com.qizx.xquery.fn.Position;
import com.qizx.xquery.op.BasicStep;
import com.qizx.xquery.op.DoubleLiteral;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FunctionCall;
import com.qizx.xquery.op.SelfStep;
import com.qizx.xquery.op.ValueEqOp;

public class FilterExpr
extends Expression {
    private static QName POSITION = IQName.get(NamespaceContext.FN, "position");
    public Expression source;
    public Expression[] predicates;

    public FilterExpr(Expression expression) {
        this.source = expression;
        this.predicates = new Expression[0];
    }

    public void addPredicate(Expression expression) {
        this.predicates = FilterExpr.addExpr(this.predicates, expression);
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("source", this.source);
        exprDisplay.children(this.predicates);
    }

    public Expression child(int n) {
        return n == 0 ? this.source : (n <= this.predicates.length ? this.predicates[n - 1] : null);
    }

    public int getFlags() {
        return this.source.getFlags();
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.source = moduleContext.staticCheck(this.source, 0);
        moduleContext.pushDotType(this.source.getType());
        for (int i = 0; i < this.predicates.length; ++i) {
            this.predicates[i] = moduleContext.staticCheck(this.predicates[i], 0);
            Expression expression = this.predicates[i];
            XQItemType xQItemType = expression.getType().itemType();
            if (!XQType.NUMERIC.isSuperType(xQItemType) || expression instanceof Last.Exec) continue;
            if (expression.findSubExpression(Position.Exec.class) == null && expression.findSubExpression(Last.Exec.class) == null && expression.findSubExpression(SelfStep.class) == null && !this.containsCallTo(Number.Exec.class, 0, expression) && !this.containsCallTo(Name.Exec.class, 0, expression)) {
                this.predicates[i] = new PosTest(expression);
                continue;
            }
            ValueEqOp valueEqOp = new ValueEqOp(new DoubleLiteral(0.0), new FunctionCall(POSITION));
            this.predicates[i] = moduleContext.staticCheck(valueEqOp, 0);
            Function.Call call = (Function.Call)this.predicates[i];
            call.args[0] = expression;
        }
        if (this.source instanceof BasicStep) {
            ((BasicStep)this.source).naturalStepOrder = true;
        }
        moduleContext.popDotType();
        this.type = this.source.getType();
        this.type = XQType.isRepeatable(this.type.getOccurrence()) ? this.type.itemType().star : this.type.itemType().opt;
        return this;
    }

    private boolean containsCallTo(Class clazz, int n, Expression expression) {
        Function.Call call = (Function.Call)expression.findSubExpression(clazz);
        if (call == null) {
            return false;
        }
        return n < 0 || call.args.length == n;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        XQValue xQValue = this.source.eval(focus, evalContext);
        for (int i = 0; i < this.predicates.length; ++i) {
            Expression expression = this.predicates[i];
            if (expression instanceof PosTest) {
                long l;
                Expression expression2 = ((PosTest)expression).index;
                double d = expression2.evalAsDouble(focus, evalContext);
                if (d != (double)(l = (long)d)) {
                    l = -1L;
                }
                xQValue = new Index(xQValue, l);
                continue;
            }
            xQValue = expression instanceof Last.Exec ? new LastFilter(xQValue) : new Sequence(xQValue, expression, evalContext);
        }
        return xQValue;
    }

    public static class Slice
    extends Index {
        long indexHi;

        public Slice(XQValue xQValue, long l, long l2) {
            super(xQValue, l);
            this.indexHi = l2;
        }

        public XQValue bornAgain() {
            return new Slice(this.source.bornAgain(), this.index, this.indexHi);
        }

        public boolean next() throws EvaluationException {
            do {
                ++this.position;
                if (this.source.next() && this.position <= this.indexHi) continue;
                return false;
            } while (this.position < this.index);
            this.item = this.source.getItem();
            return true;
        }
    }

    public static class Index
    extends Sequence {
        long index;

        public Index(XQValue xQValue, long l) {
            super(xQValue, null, null);
            this.index = l;
        }

        public XQValue bornAgain() {
            return new Index(this.source.bornAgain(), this.index);
        }

        public boolean next() throws EvaluationException {
            if (this.source.hasQuickIndex()) {
                if (this.position > 0L) {
                    return false;
                }
                this.item = this.source.quickIndex(this.index);
                if (this.item == null) {
                    return false;
                }
                this.position = 1L;
                return true;
            }
            do {
                ++this.position;
                if (this.source.next() && this.position <= this.index) continue;
                return false;
            } while (this.position != this.index);
            this.item = this.source.getItem();
            return true;
        }
    }

    public static class LastFilter
    extends Sequence {
        private boolean started = false;

        public LastFilter(XQValue xQValue) {
            super(xQValue, null, null);
        }

        public XQValue bornAgain() {
            return new LastFilter(this.getSource().bornAgain());
        }

        public boolean next() throws EvaluationException {
            if (this.started) {
                return false;
            }
            this.started = true;
            while (this.source.next()) {
                this.item = this.source.getItem();
            }
            return this.item != null;
        }
    }

    static class PosTest
    extends Expression {
        Expression index;

        PosTest(Expression expression) {
            this.index = expression;
        }

        public Expression child(int n) {
            return n == 0 ? this.index : null;
        }

        public boolean evalEffectiveBooleanValue(Focus focus, EvalContext evalContext) throws EvaluationException {
            return (double)focus.getPosition() == this.index.evalAsDouble(focus, evalContext);
        }
    }

    public static class Sequence
    extends SingleSourceSequence
    implements Focus {
        protected Expression predicate;
        protected EvalContext evalContext;
        long position = 0L;
        long last = -1L;

        Sequence(XQValue xQValue, Expression expression, EvalContext evalContext) {
            super(xQValue);
            this.evalContext = evalContext;
            this.predicate = expression;
        }

        public boolean next() throws EvaluationException {
            double d;
            XQItem xQItem;
            do {
                this.evalContext.at(this.predicate);
                if (!this.source.next()) {
                    return false;
                }
                this.item = this.source.getItem();
                ++this.position;
            } while ((xQItem = this.predicate.evalForPredicate(this, this.evalContext)) == null || !(xQItem instanceof BooleanValue ? xQItem.getBoolean() : (d = xQItem.getDouble()) == (double)this.position));
            return true;
        }

        public XQValue bornAgain() {
            return new Sequence(this.source.bornAgain(), this.predicate, this.evalContext);
        }

        public XQItem currentItem() {
            return this.item;
        }

        public Node currentItemAsNode() throws EvaluationException {
            if (!this.source.isNode()) {
                throw new EvaluationException("current item is not a node");
            }
            return this.source.getNode();
        }

        public long currentItemAsInteger() throws EvaluationException {
            return this.source.getInteger();
        }

        public double currentItemAsDouble() throws EvaluationException {
            return this.source.getDouble();
        }

        public String currentItemAsString() throws EvaluationException {
            return this.source.getString();
        }

        public long getPosition() {
            return this.position;
        }

        public long getLast() throws EvaluationException {
            if (this.last < 0L) {
                XQValue xQValue = this.source.bornAgain();
                this.last = 0L;
                while (xQValue.next()) {
                    ++this.last;
                }
            }
            return this.last;
        }
    }
}

