/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.QName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.op.Expression;

public class FunctionCall
extends Expression {
    public QName name;
    Expression[] args = new Expression[0];

    public FunctionCall(QName qName) {
        this.name = qName;
    }

    public FunctionCall(QName qName, Expression[] expressionArray) {
        this.name = qName;
        this.args = expressionArray;
    }

    public void addArgument(Expression expression) {
        this.args = FunctionCall.addExpr(this.args, expression);
    }

    public int getArgCount() {
        return this.args.length;
    }

    public Expression child(int n) {
        return n < this.args.length ? this.args[n] : null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.property("name", this.name);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = moduleContext.staticCheck(this.args[i], 0);
        }
        Function function = moduleContext.functionLookup(this.name);
        if (function == null) {
            moduleContext.error("XPST0017", (Expression)this, "unknown function '" + moduleContext.prefixedName(this.name) + "'");
            return this;
        }
        return function.staticCheck(this.name, moduleContext, this.args, this);
    }

    public XQValue eval(Focus focus, EvalContext evalContext) {
        throw new RuntimeException("BUG: FunctionCall.eval(" + this.name + ") : should not happen");
    }
}

