/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.FunctionItem;
import com.qizx.xquery.dt.FunctionType;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;

public class FunctionLiteral
extends Expression {
    QName name;
    int arity;
    Prototype proto;

    public FunctionLiteral(QName qName, long l) {
        this.name = qName;
        this.arity = (int)l;
    }

    public Expression child(int n) {
        return null;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.property("value", this.toString());
    }

    public String toString() {
        return this.name + "#" + this.arity + " " + this.proto;
    }

    public int getFlags() {
        return 32;
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.proto = moduleContext.functionLookup(this.name, this.arity);
        if (this.proto == null) {
            moduleContext.error("XPST0017", (Expression)this, "no function '" + moduleContext.prefixedName(this.name) + "' accepting " + this.arity + " arguments");
            return this;
        }
        this.setType(new FunctionType(this.proto));
        return this;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        return new FunctionItem(this.proto, evalContext);
    }

    public XQItem evalAsItem(Focus focus, EvalContext evalContext) throws EvaluationException {
        return new FunctionItem(this.proto, evalContext);
    }
}

