/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NumericOp;
import java.math.BigDecimal;

public class IDivOp
extends NumericOp {
    public IDivOp(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.binary(this, this.operands[0], this.operands[1]);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        switch (this.combinedArgTypes(moduleContext)) {
            default: 
        }
        return this.transfer(new ExecAny(), this.operands);
    }

    public static class ExecAny
    extends Function.NumericCall {
        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            XQItem xQItem = this.args[0].evalAsOptItem(focus, evalContext);
            XQItem xQItem2 = this.args[1].evalAsOptItem(focus, evalContext);
            evalContext.at(this);
            if (xQItem == null || xQItem2 == null) {
                return XQValue.empty;
            }
            switch (NumericOp.combinedArgTypes(xQItem, xQItem2)) {
                case 17: {
                    long l = xQItem.getInteger();
                    long l2 = xQItem2.getInteger();
                    if (l2 == 0L) {
                        evalContext.error("FOAR0001", (Expression)this, "division by zero");
                    }
                    return new SingleInteger(l / l2);
                }
                case 18: 
                case 33: 
                case 34: {
                    BigDecimal bigDecimal = xQItem.getDecimal();
                    BigDecimal bigDecimal2 = xQItem2.getDecimal();
                    BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 0, 1);
                    return new SingleInteger(bigDecimal3.longValue());
                }
                case 19: 
                case 35: 
                case 49: 
                case 50: 
                case 51: {
                    float f = xQItem.getFloat();
                    float f2 = xQItem2.getFloat();
                    if (f != f || Float.isInfinite(f) || f2 != f2) {
                        evalContext.error("FOAR0002", this.args[0]);
                    }
                    return new SingleInteger((long)(f / f2));
                }
                case 20: 
                case 36: 
                case 52: 
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    double d = xQItem.getDouble();
                    double d2 = xQItem2.getDouble();
                    if (d != d || Double.isInfinite(d) || d2 != d2) {
                        evalContext.error("FOAR0002", this.args[0]);
                    }
                    return new SingleInteger((long)(d / d2));
                }
            }
            evalContext.error("XPTY0004", (Expression)this, "invalid types for operator idiv");
            return null;
        }
    }
}

