/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CoreDataModel;
import com.qizx.xdm.XMLPushStreamBase;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.NamedConstructor;
import com.qizx.xquery.op.StringLiteral;

public class PIConstructor
extends NamedConstructor {
    private static final String URI_NOT_EMPTY = "URI part of PI target is not empty";

    public PIConstructor(String string) {
        super(null);
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && !Character.isWhitespace(string.charAt(n)); ++n) {
        }
        String string2 = string.substring(0, n);
        this.name = new StringLiteral(string2);
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        this.contents = new Expression[]{new StringLiteral(n >= n2 ? "" : string.substring(n))};
        this.type = XQType.PI;
        this.setDirect();
    }

    public PIConstructor(Expression expression, Expression expression2) {
        super(expression);
        if (expression2 != null) {
            this.addItem(expression2);
        }
    }

    public BasicNode evalAsNode(Focus focus, EvalContext evalContext) throws EvaluationException {
        QName qName = this.evalName(focus, evalContext);
        if (qName == null) {
            System.err.println("PIConstructor.evalAsNode : OOPS");
        }
        CoreDataModel.PINode pINode = new CoreDataModel(null).newPINode(qName.getLocalPart());
        String string = XMLUtil.normalizePI(this.evalContents(focus, evalContext));
        if (string == null) {
            evalContext.error("XQDY0026", (Expression)this, "invalid PI contents");
        } else {
            ((CoreDataModel.CoreNode)pINode).addText(string);
        }
        return pINode;
    }

    public void evalAsEvents(XMLPushStreamBase xMLPushStreamBase, Focus focus, EvalContext evalContext) throws EvaluationException {
        evalContext.at(this);
        QName qName = this.evalName(focus, evalContext);
        String string = XMLUtil.normalizePI(this.evalContents(focus, evalContext));
        if (string == null) {
            evalContext.error("XQDY0026", (Expression)this, "invalid PI contents");
        }
        try {
            xMLPushStreamBase.putProcessingInstruction(qName.getLocalPart(), string);
        }
        catch (DataModelException dataModelException) {
            this.dmError(evalContext, dataModelException);
        }
    }

    private QName evalName(Focus focus, EvalContext evalContext) throws EvaluationException {
        QName qName = null;
        try {
            qName = this.evalName(null, focus, evalContext);
            if (!qName.hasNoNamespace()) {
                evalContext.error("XQDY0041", (Expression)this, URI_NOT_EMPTY);
            }
            if ("xml".equalsIgnoreCase(qName.getLocalPart())) {
                throw new XQTypeException("XQDY0064", "illegal PI name: " + qName);
            }
        }
        catch (EvaluationException evaluationException) {
            evaluationException.substituteCode("XQDY0074", "XQDY0041");
            throw evaluationException;
        }
        return qName;
    }
}

