/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.IntegerValue;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.impl.EmptyException;
import com.qizx.xquery.op.Expression;

public class RangeExpr
extends Expression {
    public Expression lower;
    public Expression upper;

    public RangeExpr(Expression expression, Expression expression2) {
        this.lower = expression;
        this.upper = expression2;
    }

    public Expression child(int n) {
        return n == 0 ? this.lower : (n == 1 ? this.upper : null);
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.child("lower", this.lower);
        exprDisplay.child("upper", this.upper);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        this.lower = moduleContext.staticCheck(this.lower, 0);
        this.upper = moduleContext.staticCheck(this.upper, 0);
        this.type = XQType.INTEGER.star;
        return this;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        evalContext.at(this);
        try {
            return new Sequence(this.lower.evalAsOptInteger(focus, evalContext), this.upper.evalAsOptInteger(focus, evalContext));
        }
        catch (EmptyException emptyException) {
            return XQValue.empty;
        }
    }

    public int[] evaluate(Focus focus, EvalContext evalContext) throws EvaluationException {
        long l;
        if (this.lower != null && !XQType.INTEGER.accepts(this.lower.getType())) {
            evalContext.invalidArgType(this, 0, this.lower.getType(), "integer");
        }
        if (this.upper != null && !XQType.INTEGER.accepts(this.upper.getType())) {
            evalContext.invalidArgType(this, 0, this.upper.getType(), "integer");
        }
        long l2 = l = this.lower == null ? -1L : this.lower.evalAsInteger(focus, evalContext);
        long l3 = this.upper == this.lower ? l : (this.upper == null ? Long.MAX_VALUE : this.upper.evalAsInteger(focus, evalContext));
        return new int[]{(int)l, (int)l3};
    }

    static class Sequence
    extends IntegerValue {
        long start;
        long end;
        long current;

        Sequence(long l, long l2) {
            this.start = l;
            this.end = l2;
            this.current = l <= l2 ? l - 1L : l + 1L;
        }

        public boolean next() {
            return ++this.current <= this.end;
        }

        public long quickCount(EvalContext evalContext) throws EvaluationException {
            return Math.max(0L, this.end - this.start + 1L);
        }

        public boolean hasQuickIndex() {
            return true;
        }

        public XQItem quickIndex(long l) {
            if (l < 1L || l > this.end - this.start + 1L) {
                return null;
            }
            this.current = this.start + l - 1L;
            return new SingleInteger(this.current);
        }

        public XQValue bornAgain() {
            return new Sequence(this.start, this.end);
        }

        public boolean worthExpanding() {
            return false;
        }

        public long getInteger() {
            return this.current;
        }

        public long getValue() {
            return this.current;
        }
    }
}

