/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.SequenceType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.UpdatingExpr;

public class ReplaceExpr
extends UpdatingExpr {
    public static final int VALUE = 1;
    private static final SequenceType[] TARGET_TYPES = new SequenceType[]{XQType.NODE.one};
    private static final SequenceType[] REPL_TYPES = new SequenceType[]{XQType.NODE.star};
    private static final SequenceType[] VREPL_TYPES = new SequenceType[]{XQType.NODE.star, XQType.ITEM.star};

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        Expression expression = super.staticCheck(moduleContext, n);
        moduleContext.staticTyping(this.where, TARGET_TYPES, "XUTY0008", "target node");
        if (this.mode == 1) {
            moduleContext.staticTyping(this.what, VREPL_TYPES, "XUTY0010", "value");
        } else {
            moduleContext.staticTyping(this.what, REPL_TYPES, "XUTY0010", "replacement node(s)");
            XQType xQType = this.where.getType();
            XQType xQType2 = this.what.getType();
            if (XQType.ELEMENT.one.acceptsStatic(xQType) && XQType.ATTRIBUTE.one.acceptsStatic(xQType2)) {
                moduleContext.error("XUTY0010", (Expression)this, "incompatible type " + xQType2 + " for replacing element");
            }
            if (XQType.ATTRIBUTE.one.acceptsStatic(xQType) && XQType.ELEMENT.one.acceptsStatic(xQType2)) {
                moduleContext.error("XUTY0011", (Expression)this, "incompatible type " + xQType2 + " for replacing attribute");
            }
        }
        return expression;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        try {
            evalContext.haveUpdateList().replaceNodes(this, focus, evalContext);
        }
        catch (DataModelException dataModelException) {
            evalContext.error(dataModelException.getErrorCode(), (Expression)this, dataModelException.getMessage());
        }
        return XQValue.empty;
    }
}

